/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.team.core.RepositoryProvider;

public class DisconnectHandler
extends AbstractGitHandler {
    private IJobChangeListener listener;

    public DisconnectHandler() {
    }

    public DisconnectHandler(IJobChangeListener listener) {
        this.listener = listener;
    }

    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        for (IResource resource : this.getSelectedResources()) {
            DisconnectHandler.disconnect(resource.getProject(), this.listener);
        }
        return null;
    }

    public static void disconnect(final IProject project, IJobChangeListener listener) {
        WorkspaceJob job = new WorkspaceJob(MessageFormat.format(Messages.DisconnectHandler_Job_Title, project.getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    project.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) throws CoreException {
                            if (proxy.isTeamPrivateMember()) {
                                proxy.requestResource().setTeamPrivateMember(false);
                            }
                            return true;
                        }
                    }, 2);
                }
                catch (CoreException e) {
                    IdeLog.logWarning((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                }
                sub.worked(20);
                try {
                    RepositoryProvider.unmap((IProject)project);
                }
                catch (Exception e) {
                    IdeLog.logWarning((Plugin)GitUIPlugin.getDefault(), (Throwable)e);
                }
                sub.worked(10);
                DisconnectHandler.getGitRepositoryManager().removeRepository(project);
                sub.worked(10);
                project.refreshLocal(2, (IProgressMonitor)sub.newChild(60));
                sub.done();
                return Status.OK_STATUS;
            }
        };
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }
}

