/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.core.util.StringUtil;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareWithDialog
extends StatusDialog {
    private GitRepository repo;
    private Combo refText;
    private final List<GitCommit> commits;
    private final Set<GitRef> simpleRefs;
    private String refValue;

    public CompareWithDialog(Shell parentShell, GitRepository repo, List<GitCommit> commits) {
        super(parentShell);
        this.setTitle(Messages.CompareWithDialog_Title);
        Assert.isNotNull((Object)repo, (String)"Must have a non-null git repository!");
        this.repo = repo;
        this.commits = commits;
        this.simpleRefs = repo.simpleRefs();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label description = new Label(composite, 64);
        description.setText(Messages.CompareWithDialog_Message);
        description.setLayoutData((Object)GridDataFactory.fillDefaults().hint(250, 70).create());
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 1).hint(250, 30).create());
        Label label = new Label(group, 0);
        label.setText(Messages.CompareWithDialog_Ref_label);
        this.refText = new Combo(group, 2052);
        this.refText.setLayoutData((Object)new GridData(768));
        this.refText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompareWithDialog.this.refValue = CompareWithDialog.this.refText.getText();
                int index = CompareWithDialog.this.refValue.indexOf(32);
                if (index != -1) {
                    CompareWithDialog.this.refValue = CompareWithDialog.this.refValue.substring(0, index);
                }
                CompareWithDialog.this.validate();
            }
        });
        this.refText.add("HEAD");
        for (GitRef ref : this.simpleRefs) {
            this.refText.add(ref.shortName());
        }
        for (GitCommit commit : this.commits) {
            this.refText.add(CompareWithDialog.commitMessage(commit));
        }
        this.refValue = "HEAD";
        this.refText.setText("HEAD");
        SearchingContentProposalProvider proposalProvider = new SearchingContentProposalProvider();
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.refText, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider, KeyStroke.getInstance((int)262144, (int)32), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        ControlDecoration decoration = new ControlDecoration((Control)this.refText, 16384);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        this.updateStatus(Status.OK_STATUS);
        return composite;
    }

    protected void validate() {
        if (StringUtil.isEmpty((String)this.refValue)) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CompareWithDialog_NonEmptyRefMessage));
            return;
        }
        IStatus status = this.repo.revParse(this.refValue);
        if (!status.isOK()) {
            status = new Status(4, GitUIPlugin.getPluginId(), Messages.CompareWithDialog_InvalidRefError);
        }
        this.updateStatus(status);
    }

    public GitCommit getRefCommit() {
        return new GitCommit(this.repo, this.refValue);
    }

    protected static String commitMessage(GitCommit commit) {
        return MessageFormat.format("{0} {1}", commit.sha().substring(0, 8), commit.getSubject());
    }

    private class SearchingContentProposalProvider
    implements IContentProposalProvider {
        private SearchingContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<SimpleContentProposal> list = new ArrayList<SimpleContentProposal>();
            if ("HEAD".indexOf(contents) != -1) {
                list.add(new SimpleContentProposal("HEAD"));
            }
            for (GitRef ref : CompareWithDialog.this.simpleRefs) {
                if (ref.shortName().indexOf(contents) != -1) {
                    list.add(new SimpleContentProposal(ref.shortName()));
                    continue;
                }
                if (ref.toString().indexOf(contents) == -1) continue;
                list.add(new SimpleContentProposal(ref.toString()));
            }
            for (GitCommit commit : CompareWithDialog.this.commits) {
                String msg = CompareWithDialog.commitMessage(commit);
                if (msg.indexOf(contents) == -1) continue;
                list.add(new SimpleContentProposal(msg));
            }
            return list.toArray(new IContentProposal[list.size()]);
        }
    }

    private static class SimpleContentProposal
    implements IContentProposal {
        private String msg;

        private SimpleContentProposal(String msg) {
            this.msg = msg;
        }

        public String getContent() {
            return this.msg;
        }

        public int getCursorPosition() {
            return this.msg.length();
        }

        public String getDescription() {
            return null;
        }

        public String getLabel() {
            return this.msg;
        }
    }
}

