/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.core.util.StringUtil;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.dialogs.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTagDialog
extends StatusDialog {
    private GitRepository repo;
    private Combo startPointText;
    private Text messageText;
    private String startPoint;
    private String message;
    private Text tagNameText;
    private String tagName;
    private List<GitCommit> commits;

    public CreateTagDialog(Shell parentShell, GitRepository repo, List<GitCommit> commits) {
        super(parentShell);
        this.setTitle(Messages.CreateTagDialog_Title);
        this.repo = repo;
        this.commits = commits;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label tagNameLabel = new Label(composite, 0);
        tagNameLabel.setText(Messages.CreateTagDialog_Message);
        this.tagNameText = new Text(composite, 2626);
        this.tagNameText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, 100).create());
        this.tagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTagDialog.this.tagName = CreateTagDialog.this.tagNameText.getText();
                CreateTagDialog.this.validate();
            }
        });
        Label tagMessageLabel = new Label(composite, 0);
        tagMessageLabel.setText(Messages.CreateTagDialog_Message_label);
        this.messageText = new Text(composite, 2626);
        this.messageText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, 100).create());
        this.messageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTagDialog.this.message = CreateTagDialog.this.messageText.getText();
                CreateTagDialog.this.validate();
            }
        });
        Group group = new Group(composite, -1);
        group.setText(Messages.CreateTagDialog_AdvancedOptions_label);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Label tagRevLabel = new Label((Composite)group, 0);
        tagRevLabel.setText(Messages.CreateTagDialog_StartPoint_label);
        this.startPointText = new Combo((Composite)group, 2052);
        this.startPoint = "HEAD";
        this.startPointText.setText("HEAD");
        this.startPointText.setLayoutData((Object)new GridData(768));
        this.startPointText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTagDialog.this.startPoint = CreateTagDialog.this.startPointText.getText();
                int index = CreateTagDialog.this.startPoint.indexOf(32);
                if (index != -1) {
                    CreateTagDialog.this.startPoint = CreateTagDialog.this.startPoint.substring(0, index);
                }
                CreateTagDialog.this.validate();
            }
        });
        for (GitCommit commit : this.commits) {
            this.startPointText.add(CreateTagDialog.commitMessage(commit));
        }
        SearchingContentProposalProvider proposalProvider = new SearchingContentProposalProvider(this.commits);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.startPointText, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)proposalProvider, KeyStroke.getInstance((int)262144, (int)32), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        ControlDecoration decoration = new ControlDecoration((Control)this.startPointText, 16384);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        return composite;
    }

    protected void validate() {
        if (StringUtil.isEmpty((String)this.tagName)) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CreateTagDialog_NonEmptyTagNameMessage));
            return;
        }
        String trimmed = this.tagName.trim();
        if (trimmed.contains(" ") || trimmed.contains("\t")) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CreateTagDialog_NoWhitespaceTagNameMessage));
            return;
        }
        if (this.repo.tags().contains(trimmed)) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CreateTagDialog_TagAlreadyExistsMessage));
            return;
        }
        if (!this.repo.validRefName("refs/tags/" + trimmed)) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CreateTagDialog_InvalidTagNameMessage));
            return;
        }
        IStatus status = this.repo.revParse(this.startPoint);
        if (!status.isOK()) {
            this.updateStatus((IStatus)new Status(4, GitUIPlugin.getPluginId(), Messages.CompareWithDialog_InvalidRefError));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    public String getStartPoint() {
        return this.startPoint;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTagName() {
        return this.tagName;
    }

    protected static String commitMessage(GitCommit commit) {
        return MessageFormat.format("{0} {1}", commit.sha().substring(0, 8), commit.getSubject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchingContentProposalProvider
    implements IContentProposalProvider {
        private List<GitCommit> commits;

        private SearchingContentProposalProvider(List<GitCommit> commits) {
            this.commits = commits;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<ContentProposal> list = new ArrayList<ContentProposal>();
            for (GitCommit commit : this.commits) {
                String msg = CreateTagDialog.commitMessage(commit);
                if (msg.indexOf(contents) == -1) continue;
                list.add(new ContentProposal(msg));
            }
            return list.toArray(new IContentProposal[list.size()]);
        }
    }
}

