/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal;

import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.BranchAddedEvent;
import com.aptana.git.core.model.BranchChangedEvent;
import com.aptana.git.core.model.BranchRemovedEvent;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoriesListener;
import com.aptana.git.core.model.IGitRepositoryListener;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.core.model.IndexChangedEvent;
import com.aptana.git.core.model.PullEvent;
import com.aptana.git.core.model.PushEvent;
import com.aptana.git.core.model.RepositoryAddedEvent;
import com.aptana.git.core.model.RepositoryRemovedEvent;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.CachedImageDescriptor;
import com.aptana.git.ui.internal.GitColors;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.TeamImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitLightweightDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator,
IGitRepositoryListener,
IGitRepositoriesListener {
    public static final String UNTRACKED_IMAGE = "icons/ovr/untracked.gif";
    public static final String STAGED_ADDED_IMAGE = "icons/ovr/staged_added.gif";
    public static final String STAGED_REMOVED_IMAGE = "icons/ovr/staged_removed.gif";
    private static final String DIRTY_PREFIX = "* ";
    private static final String DECORATOR_ID = "com.aptana.git.ui.internal.GitLightweightDecorator";
    private static ImageDescriptor conflictImage;
    private static UIJob refreshJob;
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private Map<RepoBranch, TimestampedString> cache = new HashMap<RepoBranch, TimestampedString>();

    public GitLightweightDecorator() {
        IGitRepositoryManager manager = this.getGitRepositoryManager();
        if (manager != null) {
            manager.addListener((IGitRepositoriesListener)this);
            manager.addListenerToEachRepository((IGitRepositoryListener)this);
        }
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    GitLightweightDecorator.refresh();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        GitPlugin plugin = GitPlugin.getDefault();
        return plugin == null ? null : plugin.getGitRepositoryManager();
    }

    public void decorate(Object element, IDecoration decoration) {
        IResource resource = GitLightweightDecorator.getResource(element);
        if (resource == null) {
            return;
        }
        if (!this.isWorkbenchRunning()) {
            return;
        }
        if (!this.isGitUIPluginActive()) {
            return;
        }
        if (resource.getType() == 8) {
            return;
        }
        if (!resource.exists() && !resource.isPhantom()) {
            return;
        }
        switch (resource.getType()) {
            case 4: {
                this.decorateProject(decoration, resource);
            }
            case 2: {
                this.decorateFolder(decoration, resource);
                break;
            }
            case 1: {
                this.decorateFile(decoration, resource);
            }
        }
    }

    protected boolean isGitUIPluginActive() {
        return GitUIPlugin.getDefault() != null;
    }

    protected boolean isWorkbenchRunning() {
        return PlatformUI.isWorkbenchRunning();
    }

    private void decorateFolder(IDecoration decoration, IResource resource) {
        GitRepository repo = this.getRepo(resource);
        if (repo == null) {
            return;
        }
        if (repo.resourceOrChildHasChanges(resource)) {
            decoration.addPrefix(DIRTY_PREFIX);
        }
    }

    private void decorateFile(IDecoration decoration, IResource resource) {
        IFile file = (IFile)resource;
        GitRepository repo = this.getRepo(resource);
        if (repo == null) {
            return;
        }
        ChangedFile changed = repo.getChangedFileForResource((IResource)file);
        if (changed == null) {
            return;
        }
        ImageDescriptor overlay = null;
        if (changed.hasUnstagedChanges()) {
            decoration.setForegroundColor(GitColors.redFG());
            decoration.setBackgroundColor(GitColors.redBG());
            if (changed.getStatus() == ChangedFile.Status.NEW) {
                overlay = this.untrackedImage();
            } else if (changed.getStatus() == ChangedFile.Status.UNMERGED) {
                overlay = this.conflictImage();
            }
        } else if (changed.hasStagedChanges()) {
            decoration.setForegroundColor(GitColors.greenFG());
            decoration.setBackgroundColor(GitColors.greenBG());
            if (changed.getStatus() == ChangedFile.Status.DELETED) {
                overlay = this.stagedRemovedImage();
            } else if (changed.getStatus() == ChangedFile.Status.NEW) {
                overlay = this.stagedAddedImage();
            }
        }
        decoration.addPrefix(DIRTY_PREFIX);
        if (overlay != null) {
            decoration.addOverlay(overlay);
        }
    }

    private ImageDescriptor conflictImage() {
        if (conflictImage == null) {
            conflictImage = new CachedImageDescriptor(TeamImages.getImageDescriptor((String)"ovr/confchg_ov.gif"));
        }
        return conflictImage;
    }

    private ImageDescriptor stagedRemovedImage() {
        return GitUIPlugin.getDefault().getImageRegistry().getDescriptor(STAGED_REMOVED_IMAGE);
    }

    private ImageDescriptor stagedAddedImage() {
        return GitUIPlugin.getDefault().getImageRegistry().getDescriptor(STAGED_ADDED_IMAGE);
    }

    private ImageDescriptor untrackedImage() {
        return GitUIPlugin.getDefault().getImageRegistry().getDescriptor(UNTRACKED_IMAGE);
    }

    private void decorateProject(IDecoration decoration, IResource resource) {
        GitRepository repo = this.getRepo(resource);
        if (repo == null) {
            return;
        }
        String branch = repo.currentBranch();
        RepoBranch repoBranch = new RepoBranch(repo, branch);
        TimestampedString result = this.cache.get(repoBranch);
        if (result != null && !result.isOlderThan(1000)) {
            decoration.addSuffix(result.string);
            return;
        }
        this.cache.remove(repoBranch);
        StringBuilder builder = new StringBuilder();
        builder.append(" [");
        builder.append(branch);
        String[] commits = repo.commitsAhead(branch);
        if (commits != null && commits.length > 0) {
            builder.append('+').append(commits.length);
        } else {
            commits = repo.commitsBehind(branch);
            if (commits != null && commits.length > 0) {
                builder.append('-').append(commits.length);
            }
        }
        builder.append(']');
        String value = builder.toString();
        this.cache.put(repoBranch, new TimestampedString(value));
        decoration.addSuffix(value);
    }

    public void dispose() {
        try {
            this.getGitRepositoryManager().removeListener((IGitRepositoriesListener)this);
            this.getGitRepositoryManager().removeListenerFromEachRepository((IGitRepositoryListener)this);
            InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
            this.cache.clear();
        }
        finally {
            super.dispose();
        }
    }

    private static IResource getResource(Object element) {
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        return resource;
    }

    protected GitRepository getRepo(IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        return this.getGitRepositoryManager().getAttached(project);
    }

    private void postLabelEvent(final LabelProviderChangedEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                GitLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    public void indexChanged(IndexChangedEvent e) {
        Set resources = e.getFilesWithChanges();
        resources.addAll(this.getAllAncestors(resources));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            GitRepository repo = this.getGitRepositoryManager().getAttached(project);
            if (repo != null && repo.equals((Object)e.getRepository())) {
                resources.add(project);
            }
            ++n2;
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
    }

    private Collection<? extends IResource> getAllAncestors(Set<IResource> resources) {
        HashSet<IContainer> ancestors = new HashSet<IContainer>();
        Iterator<IResource> iterator = resources.iterator();
        block0: while (iterator.hasNext()) {
            IResource resource;
            IResource child = resource = iterator.next();
            IContainer parent = null;
            while ((parent = child.getParent()) != null) {
                if (parent.getType() == 4 || parent.getType() == 8) continue block0;
                ancestors.add(parent);
                child = parent;
            }
        }
        return ancestors;
    }

    public void repositoryAdded(RepositoryAddedEvent e) {
        e.getRepository().addListener((IGitRepositoryListener)this);
        Set resources = e.getRepository().getChangedResources();
        resources.add(e.getProject());
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
    }

    public void repositoryRemoved(RepositoryRemovedEvent e) {
        e.getRepository().removeListener((IGitRepositoryListener)this);
    }

    private static void refresh() {
        if (refreshJob == null) {
            refreshJob = new UIJob("Refresh Git labels"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (monitor != null && monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    GitUIPlugin.getDefault().getWorkbench().getDecoratorManager().update(GitLightweightDecorator.DECORATOR_ID);
                    return Status.OK_STATUS;
                }
            };
            EclipseUtil.setSystemForJob((Job)refreshJob);
        }
        refreshJob.cancel();
        refreshJob.schedule(50L);
    }

    public void branchChanged(BranchChangedEvent e) {
        IProject[] projects;
        HashSet<IProject> resources = new HashSet<IProject>();
        GitRepository repo = e.getRepository();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (repo.equals((Object)this.getGitRepositoryManager().getAttached(project))) {
                resources.add(project);
            }
            ++n2;
        }
        this.postLabelEvent(new LabelProviderChangedEvent((IBaseLabelProvider)this, resources.toArray()));
    }

    public void pulled(PullEvent e) {
        this.cache.clear();
        GitLightweightDecorator.refresh();
    }

    public void pushed(PushEvent e) {
        this.cache.clear();
        GitLightweightDecorator.refresh();
    }

    public void branchAdded(BranchAddedEvent e) {
    }

    public void branchRemoved(BranchRemovedEvent e) {
    }

    private static class RepoBranch {
        GitRepository repo;
        String branch;

        RepoBranch(GitRepository repo, String branch) {
            this.repo = repo;
            this.branch = branch;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RepoBranch)) {
                return false;
            }
            RepoBranch other = (RepoBranch)obj;
            return other.repo.equals((Object)this.repo) && other.branch.equals(this.branch);
        }

        public int hashCode() {
            return (31 + this.repo.hashCode()) * (31 + this.branch.hashCode());
        }
    }

    private static class TimestampedString {
        String string;
        Long timestamp;

        TimestampedString(String value) {
            this.string = value;
            this.timestamp = System.currentTimeMillis();
        }

        public boolean isOlderThan(int millis) {
            return this.timestamp + (long)millis < System.currentTimeMillis();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TimestampedString)) {
                return false;
            }
            TimestampedString other = (TimestampedString)obj;
            return other.string.equals(this.string) && other.timestamp.equals(this.timestamp);
        }

        public int hashCode() {
            return (31 + this.string.hashCode()) * (31 + this.timestamp.hashCode());
        }
    }
}

