/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.actions.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AttachGitRepoHandler
extends AbstractHandler {
    private boolean enabled;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Object evaluationContext) {
        IProject selectedProject = this.getSelectedProject(evaluationContext);
        if (selectedProject == null) {
            this.enabled = false;
            return;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(selectedProject);
        this.enabled = repo == null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final IProject selectedProject = this.getSelectedProject(event.getApplicationContext());
        if (selectedProject == null) {
            return null;
        }
        Job job = new Job(Messages.GitProjectView_AttachGitRepo_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    try {
                        AttachGitRepoHandler.this.getGitRepositoryManager().createOrAttach(selectedProject, (IProgressMonitor)sub.newChild(100));
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                        IStatus iStatus = e.getStatus();
                        sub.done();
                        return iStatus;
                    }
                }
                finally {
                    sub.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
        return null;
    }

    private IProject getSelectedProject(Object applicationContext) {
        ISelection sel = this.getSelection(applicationContext);
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structured = (IStructuredSelection)sel;
        Object first = structured.getFirstElement();
        IResource resource = null;
        if (first instanceof IResource) {
            resource = (IResource)first;
        } else if (first instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)first;
            resource = (IResource)adaptable.getAdapter(IResource.class);
        }
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }

    protected IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private ISelection getSelection(Object evalContext) {
        if (evalContext instanceof IEvaluationContext) {
            Object obj = ((IEvaluationContext)evalContext).getVariable("selection");
            if (obj == null) {
                return null;
            }
            if (obj instanceof ISelection) {
                return (ISelection)obj;
            }
            return new StructuredSelection(obj);
        }
        return null;
    }
}

