/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.GitRevList;
import com.aptana.git.core.model.GitRevSpecifier;
import com.aptana.git.ui.dialogs.CompareWithDialog;
import com.aptana.git.ui.internal.actions.AbstractCompareRevisionHandler;
import com.aptana.git.ui.internal.history.GitCompareFileRevisionEditorInput;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;

public class CompareWithRevisionHandler
extends AbstractCompareRevisionHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        IResource resource = resources.iterator().next();
        if (resource == null || resource.getType() != 1) {
            return null;
        }
        GitRepository repo = CompareWithRevisionHandler.getGitRepositoryManager().getAttached(resource.getProject());
        if (repo == null) {
            return null;
        }
        IPath resourcePath = repo.relativePath(resource);
        GitRevList revList = new GitRevList(repo);
        repo.lazyReload();
        revList.walkRevisionListWithSpecifier(new GitRevSpecifier(new String[]{resourcePath.toOSString()}), (IProgressMonitor)new NullProgressMonitor());
        List commits = revList.getCommits();
        CompareWithDialog dialog = new CompareWithDialog(this.getShell(), repo, commits);
        if (dialog.open() == 1) {
            return null;
        }
        GitCommit commit = dialog.getRefCommit();
        ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)((IFile)resource));
        IFileRevision nextFile = GitPlugin.revisionForCommit((GitCommit)commit, (IPath)resourcePath);
        FileRevisionTypedElement next = new FileRevisionTypedElement(nextFile);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, (ITypedElement)next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
        return null;
    }

    protected boolean calculateEnabled() {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources == null || resources.isEmpty()) {
            return false;
        }
        for (IResource blah : resources) {
            GitRepository repo;
            if (blah == null || blah.getType() != 1 || (repo = CompareWithRevisionHandler.getGitRepositoryManager().getAttached(blah.getProject())) == null) continue;
            return true;
        }
        return false;
    }
}

