/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class DeleteBranchHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        String currentBranch = repo.currentBranch();
        ArrayList<MenuDialogItem> listOfMaps = new ArrayList<MenuDialogItem>();
        for (String branch : repo.localBranches()) {
            if (branch.equals(currentBranch)) continue;
            listOfMaps.add(new MenuDialogItem(branch));
        }
        QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.DeleteBranchHandler_PopupTitle);
        dialog.setInput(listOfMaps);
        if (dialog.open() != -1) {
            MenuDialogItem item = (MenuDialogItem)listOfMaps.get(dialog.getReturnCode());
            DeleteBranchHandler.deleteBranch(repo, item.getText());
        }
        return null;
    }

    public static void deleteBranch(final GitRepository repo, final String branchName) {
        Job job = new Job(NLS.bind((String)Messages.DeleteBranchHandler_JobName, (Object)branchName)){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = repo.deleteBranch(branchName);
                if (!status.isOK()) {
                    final IStatus theStatus = status;
                    final boolean[] result = new boolean[1];
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            result[0] = MessageDialog.openConfirm((Shell)UIUtils.getActiveShell(), (String)Messages.DeleteBranchAction_BranchDeletionFailed_Title, (String)MessageFormat.format(Messages.DeleteBranchAction_BranchDeletionFailed_Msg, branchName, theStatus.getMessage()));
                        }
                    });
                    if (result[0]) {
                        status = repo.deleteBranch(branchName, true);
                    } else {
                        return Status.OK_STATUS;
                    }
                }
                if (status.isOK()) {
                    DeleteBranchHandler.showSuccessToast(branchName);
                }
                return status;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        job.schedule();
    }

    private static void showSuccessToast(final String branchName) {
        UIJob job = new UIJob("show toast"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                final Shell shell = UIUtils.getActiveShell();
                String text = MessageFormat.format(Messages.DeleteBranchAction_BranchDelete_Msg, branchName);
                DefaultToolTip toolTip = new DefaultToolTip((Control)shell){

                    public Point getLocation(Point size, Event event) {
                        Rectangle workbenchWindowBounds = shell.getBounds();
                        int xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
                        int yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
                        return new Point(xCoord, yCoord);
                    }
                };
                toolTip.setHideDelay(3000);
                toolTip.setText(text);
                toolTip.show(new Point(0, 0));
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(10);
        job.schedule();
    }
}

