/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.Launcher;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.osgi.util.NLS;

public class PushTagsHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            return null;
        }
        ArrayList<MenuDialogItem> remotes = new ArrayList<MenuDialogItem>();
        for (String remote : repo.remotes()) {
            remotes.add(new MenuDialogItem(remote));
        }
        if (!remotes.isEmpty()) {
            QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), Messages.PushTagsHandler_PopupTitle);
            dialog.setInput(remotes);
            if (dialog.open() != -1) {
                MenuDialogItem item = (MenuDialogItem)remotes.get(dialog.getReturnCode());
                PushTagsHandler.pushTagsToRemote(repo, item.getText());
            }
        }
        return null;
    }

    public static void pushTagsToRemote(final GitRepository repo, final String remoteName) {
        Job job = new Job(NLS.bind((String)"git push {0} --tags", (Object)remoteName)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                repo.enterWriteProcess();
                try {
                    ILaunch launch = Launcher.launch(repo, (IProgressMonitor)subMonitor.newChild(75), "push", remoteName, "--tags");
                    while (!launch.isTerminated()) {
                        if (subMonitor.isCanceled()) {
                            launch.terminate();
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        try {
                            Thread.yield();
                        }
                        catch (CoreException e) {
                            IdeLog.log((Plugin)GitUIPlugin.getDefault(), (IStatus)e.getStatus());
                            IStatus iStatus = e.getStatus();
                            return iStatus;
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
                            Status status = new Status(4, GitUIPlugin.getPluginId(), e.getMessage());
                            return status;
                        }
                    }
                }
                finally {
                    repo.exitWriteProcess();
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }
}

