/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitRef;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.internal.history.GitHistoryPage;
import java.util.ArrayList;
import java.util.SortedSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.actions.CompoundContributionItem;

public class SwitchHistoryBranchPulldownContributionItem
extends CompoundContributionItem {
    public SwitchHistoryBranchPulldownContributionItem() {
    }

    public SwitchHistoryBranchPulldownContributionItem(String id) {
        super(id);
    }

    protected GitHistoryPage getHistoryPage() {
        IHistoryView view = TeamUI.getHistoryView();
        IHistoryPage page = view.getHistoryPage();
        if (page instanceof GitHistoryPage) {
            return (GitHistoryPage)page;
        }
        return null;
    }

    private void switchRef(IResource manager, String refName) {
        GitHistoryPage page = this.getHistoryPage();
        if (page != null) {
            page.setRef(refName);
        }
    }

    protected IContributionItem[] getContributionItems() {
        GitHistoryPage historyPage = this.getHistoryPage();
        if (historyPage == null) {
            return new IContributionItem[0];
        }
        IResource resource = (IResource)historyPage.getInput();
        String currentRef = historyPage.getCurrentRef();
        IGitRepositoryManager manager = GitPlugin.getDefault().getGitRepositoryManager();
        GitRepository repo = manager.getAttached(resource.getProject());
        SortedSet refs = repo.simpleRefs();
        ArrayList<SwitchRefContributionItem> items = new ArrayList<SwitchRefContributionItem>(refs.size());
        for (GitRef ref : refs) {
            String refName = ref.shortName();
            boolean enabled = !currentRef.equals(refName);
            SwitchRefContributionItem item = new SwitchRefContributionItem(resource, refName, enabled);
            items.add(item);
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private class SwitchRefContributionItem
    extends ContributionItem {
        private IResource resource;
        private String branchName;
        private boolean enabled;

        SwitchRefContributionItem(IResource resource, String refName, boolean enabled) {
            this.resource = resource;
            this.branchName = refName;
            this.enabled = enabled;
        }

        public void fill(Menu menu, int index) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(this.branchName);
            menuItem.setEnabled(this.enabled);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SwitchHistoryBranchPulldownContributionItem.this.switchRef(SwitchRefContributionItem.this.resource, SwitchRefContributionItem.this.branchName);
                }
            });
        }
    }
}

