/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.history;

import com.aptana.core.util.ArrayUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.Diff;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.history.GitCompareFileRevisionEditorInput;
import com.aptana.git.ui.internal.history.GitHistoryPage;
import com.aptana.git.ui.internal.history.Messages;
import com.aptana.git.ui.internal.history.OpenRevisionAction;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;

class CommitFileDiffViewer
extends TableViewer {
    CommitFileDiffViewer(Composite parent, final GitHistoryPage historyPage) {
        super(parent, 68354);
        Table rawTable = this.getTable();
        rawTable.setHeaderVisible(true);
        rawTable.setLinesVisible(false);
        TableLayout layout = new TableLayout();
        rawTable.setLayout((Layout)layout);
        this.createColumns(rawTable, layout);
        this.setContentProvider((IContentProvider)new CommitDiffContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new SingleCommitLabelProvider());
        this.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)s;
                Diff d = (Diff)iss.getFirstElement();
                CommitFileDiffViewer.this.showTwoWayFileDiff(d);
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new OpenRevisionAction(historyPage.getSite().getPage(), CommitFileDiffViewer.this.getTable()));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    private void showTwoWayFileDiff(Diff d) {
        if (d == null || d.isBinary()) {
            return;
        }
        GitCommit c = d.commit();
        IFileRevision baseFile = GitPlugin.revisionForCommit((GitCommit)c.getFirstParent(), (IPath)Path.fromPortableString((String)d.oldName()));
        IFileRevision nextFile = GitPlugin.revisionForCommit((GitCommit)c, (IPath)Path.fromPortableString((String)d.newName()));
        FileRevisionTypedElement base = new FileRevisionTypedElement(baseFile);
        FileRevisionTypedElement next = new FileRevisionTypedElement(nextFile);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput((ITypedElement)base, (ITypedElement)next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
    }

    private void createColumns(Table rawTable, TableLayout layout) {
        TableColumn mode = new TableColumn(rawTable, 0);
        mode.setResizable(true);
        mode.setText("");
        mode.setWidth(5);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        TableColumn path = new TableColumn(rawTable, 0);
        path.setResizable(true);
        path.setText(Messages.CommitFileDiffViewer_PathColumnLabel);
        path.setWidth(250);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }

    private static class CommitDiffContentProvider
    implements IStructuredContentProvider {
        private CommitDiffContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof GitCommit) {
                GitCommit commit = (GitCommit)inputElement;
                return commit.getDiff().toArray();
            }
            return ArrayUtil.NO_OBJECTS;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class SingleCommitLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private SingleCommitLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Diff diff = (Diff)element;
            switch (columnIndex) {
                case 0: {
                    if (diff.fileCreated()) {
                        return GitUIPlugin.getImage("icons/obj16/empty_file.png");
                    }
                    if (diff.fileDeleted()) {
                        return GitUIPlugin.getImage("icons/obj16/deleted_file.png");
                    }
                    return GitUIPlugin.getImage("icons/obj16/new_file.png");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Diff diff = (Diff)element;
            switch (columnIndex) {
                case 0: {
                    if (diff.renamed()) {
                        return Messages.CommitFileDiffViewer_Renamed;
                    }
                    if (diff.fileCreated()) {
                        return Messages.CommitFileDiffViewer_Created;
                    }
                    if (diff.fileDeleted()) {
                        return Messages.CommitFileDiffViewer_Deleted;
                    }
                    return Messages.CommitFileDiffViewer_Modified;
                }
                case 1: {
                    if (diff.renamed()) {
                        return String.valueOf(diff.oldName()) + " -> " + diff.newName();
                    }
                    return diff.fileName();
                }
            }
            return "";
        }
    }
}

