/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.history;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.core.model.GitRevList;
import com.aptana.git.core.model.GitRevSpecifier;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.history.CommitFileDiffViewer;
import com.aptana.git.ui.internal.history.CommitGraphTable;
import com.aptana.git.ui.internal.history.Messages;
import com.aptana.ui.util.UIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.osgi.framework.Bundle;

public class GitHistoryPage
extends HistoryPage {
    private static final String POPUP_MENU_ID = "com.aptana.git.ui.git_history";
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat(Messages.GitHistoryPage_DateFormat);
    private Composite ourControl;
    private SashForm graphDetailSplit;
    private SashForm revInfoSplit;
    private CommitGraphTable graph;
    private Browser commentViewer;
    private CommitFileDiffViewer fileViewer;
    private String currentRef;

    public boolean inputSet() {
        if (this.graph == null) {
            return false;
        }
        Object input = super.getInput();
        IResource resource = null;
        if (input instanceof IResource[]) {
            IResource[] resources = (IResource[])input;
            if (resources.length == 0) {
                return false;
            }
            resource = resources[0];
        } else if (input instanceof IResource) {
            resource = (IResource)input;
        }
        if (resource == null) {
            return false;
        }
        GitRepository repo = this.getGitRepositoryManager().getAttached(resource.getProject());
        this.currentRef = repo.currentBranch();
        this.loadHistory(resource, this.currentRef);
        return true;
    }

    private void loadHistory(final IResource resource, final String ref) {
        this.currentRef = ref;
        Job job = new Job(Messages.GitHistoryPage_GeneratingHistoryJob_title){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                GitRepository repo = GitHistoryPage.this.getGitRepositoryManager().getAttached(resource.getProject());
                if (repo == null) {
                    return Status.OK_STATUS;
                }
                GitRevList revList = new GitRevList(repo);
                IPath resourcePath = repo.relativePath(resource);
                if (subMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                repo.lazyReload();
                subMonitor.worked(5);
                GitRevSpecifier rev = resourcePath.isEmpty() ? new GitRevSpecifier(new String[]{ref}) : new GitRevSpecifier(new String[]{ref, "--", resourcePath.toOSString()});
                IStatus result = revList.walkRevisionListWithSpecifier(rev, (IProgressMonitor)subMonitor.newChild(95));
                if (result != null && result.isOK()) {
                    final List commits = revList.getCommits();
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            GitHistoryPage.this.graph.setCommits(commits);
                            if (GitHistoryPage.this.getControl() != null && !GitHistoryPage.this.getControl().isDisposed()) {
                                GitHistoryPage.this.getSite().getPage().activate((IWorkbenchPart)GitHistoryPage.this.getHistoryView());
                                ((IViewPart)GitHistoryPage.this.getHistoryView()).getViewSite().getActionBars().updateActionBars();
                            }
                        }
                    });
                }
                subMonitor.done();
                return result;
            }
        };
        job.setUser(true);
        job.setPriority(20);
        this.schedule(job);
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    private IWorkbenchPartSite getWorkbenchSite() {
        IWorkbenchPart part = this.getHistoryPageSite().getPart();
        return part != null ? part.getSite() : null;
    }

    private void schedule(Job j) {
        IWorkbenchPartSite site = this.getWorkbenchSite();
        if (site == null) {
            j.schedule();
            return;
        }
        IWorkbenchSiteProgressService p = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
        if (p != null) {
            p.schedule(j, 0L, true);
            return;
        }
        j.schedule();
    }

    public void createControl(Composite parent) {
        this.ourControl = this.createMainPanel(parent);
        GridData gd = GridDataFactory.fillDefaults().grab(true, true).create();
        this.ourControl.setLayoutData((Object)gd);
        this.graphDetailSplit = new SashForm(this.ourControl, 512);
        this.graphDetailSplit.setLayoutData((Object)gd);
        this.graph = this.createCommitTable((Composite)this.graphDetailSplit);
        this.revInfoSplit = new SashForm((Composite)this.graphDetailSplit, 256);
        this.commentViewer = new Browser((Composite)this.revInfoSplit, 8);
        this.fileViewer = new CommitFileDiffViewer((Composite)this.revInfoSplit, this);
        this.graphDetailSplit.setWeights(new int[]{500, 500});
        this.revInfoSplit.setWeights(new int[]{700, 300});
        this.attachCommitSelectionChanged();
        this.hookContextMenu((Control)this.commentViewer);
        this.layout();
        this.commentViewer.setText(MessageFormat.format("<html><head></head><body style=\"background-color: {0};\"></body></html>", this.toHex(this.getBackground())));
        this.getHistoryPageSite().setSelectionProvider(this.getSelectionProvider());
        this.hookContextMenu(this.graph);
    }

    private void hookContextMenu(TableViewer treeViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(POPUP_MENU_ID, menuMgr, (ISelectionProvider)treeViewer);
    }

    protected RGB getBackground() {
        return UIUtils.getDisplay().getSystemColor(22).getRGB();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.graph;
    }

    private void hookContextMenu(Control browserControl) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(browserControl);
        browserControl.setMenu(menu);
    }

    private CommitGraphTable createCommitTable(Composite parent) {
        return new CommitGraphTable(parent);
    }

    private void attachCommitSelectionChanged() {
        this.graph.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    GitHistoryPage.this.commentViewer.setText("");
                    GitHistoryPage.this.fileViewer.setInput(null);
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)s;
                GitCommit commit = (GitCommit)sel.getFirstElement();
                GitHistoryPage.this.commentViewer.setText(GitHistoryPage.this.commitToHTML(commit));
                GitHistoryPage.this.fileViewer.setInput(commit);
            }
        });
    }

    private Composite createMainPanel(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        c.setLayout((Layout)parentLayout);
        return c;
    }

    private void layout() {
        this.graphDetailSplit.setMaximizedControl(null);
        this.revInfoSplit.setMaximizedControl(null);
        this.ourControl.layout();
    }

    public Control getControl() {
        return this.ourControl;
    }

    public void setFocus() {
        this.graph.getControl().setFocus();
    }

    public String getDescription() {
        return this.getName();
    }

    public String getName() {
        Object input = super.getInput();
        IResource resource = null;
        if (input instanceof IResource[]) {
            IResource[] resources = (IResource[])input;
            if (resources.length == 0) {
                return "";
            }
            resource = resources[0];
        } else if (input instanceof IResource) {
            resource = (IResource)input;
        }
        if (resource == null) {
            return "";
        }
        return resource.getProject().getName();
    }

    public boolean isValidInput(Object object) {
        return GitHistoryPage.canShowHistoryFor(object);
    }

    public void refresh() {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private String commitToHTML(GitCommit commit) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("\\{sha\\}", commit.sha());
        variables.put("\\{themeBG\\}", this.toHex(this.getBackground()));
        variables.put("\\{date\\}", TIMESTAMP_FORMAT.format(commit.date()));
        variables.put("\\{author\\}", commit.getAuthor());
        variables.put("\\{subject\\}", commit.getSubject());
        String comment = commit.getComment();
        comment = comment.replaceAll("http://(.+)", "<a href=\"$0\" target=\"_blank\">http://$1</a>");
        comment = comment.replaceAll("\r?\n|\r", "<br />");
        variables.put("\\{comment\\}", comment);
        String avatar = "";
        if (commit.getAuthorEmail() != null) {
            avatar = StringUtil.md5((String)commit.getAuthorEmail().toLowerCase());
        }
        variables.put("\\{avatar\\}", avatar);
        StringBuilder parents = new StringBuilder();
        if (commit.parents() != null && !commit.parents().isEmpty()) {
            for (String parentSha : commit.parents()) {
                parents.append(parentSha).append("<br />");
            }
        }
        variables.put("\\{parent\\}", parents.toString());
        return StringUtil.replaceAll((String)this.loadTemplate(), variables);
    }

    private String loadTemplate() {
        try {
            InputStream stream = FileLocator.openStream((Bundle)GitUIPlugin.getDefault().getBundle(), (IPath)new Path("templates").append("commit_details.html"), (boolean)false);
            return IOUtil.read((InputStream)stream);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            return "";
        }
    }

    protected static boolean canShowHistoryFor(Object object) {
        if (object instanceof IResource[]) {
            IResource[] array = (IResource[])object;
            if (array.length == 0) {
                return false;
            }
            IResource[] iResourceArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                IResource r = iResourceArray[n2];
                if (!GitHistoryPage.typeOk(r)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (object instanceof IResource) {
            return GitHistoryPage.typeOk((IResource)object);
        }
        return false;
    }

    private static boolean typeOk(IResource object) {
        switch (object.getType()) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private String toHex(RGB rgb) {
        return MessageFormat.format("#{0}{1}{2}", this.pad(Integer.toHexString(rgb.red), 2, '0'), this.pad(Integer.toHexString(rgb.green), 2, '0'), this.pad(Integer.toHexString(rgb.blue), 2, '0'));
    }

    private String pad(String string, int desiredLength, char padChar) {
        StringBuilder builder = new StringBuilder(string);
        while (builder.length() < desiredLength) {
            builder.insert(0, padChar);
        }
        return builder.toString();
    }

    public void setRef(String branchName) {
        Object input = super.getInput();
        IResource resource = null;
        if (input instanceof IResource[]) {
            IResource[] resources = (IResource[])input;
            if (resources.length > 0) {
                resource = resources[0];
            }
        } else if (input instanceof IResource) {
            resource = (IResource)input;
        }
        this.loadHistory(resource, branchName);
    }

    public String getCurrentRef() {
        return this.currentRef;
    }
}

