/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.theme.DelayedTextAttribute;
import com.aptana.theme.RGBa;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.eclipse.core.runtime.Plugin;

public class ThemeExporter {
    public void export(File themeFile, Theme theme) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n");
        buffer.append("<plist version=\"1.0\">\n");
        buffer.append("<dict>\n");
        buffer.append("  <key>name</key>\n");
        buffer.append("  <string>").append(this.escape(theme.getName())).append("</string>\n");
        buffer.append("  <key>uuid</key>\n");
        buffer.append("  <string>").append(UUID.nameUUIDFromBytes(theme.getName().getBytes())).append("</string>\n");
        buffer.append("  <key>settings</key>\n");
        buffer.append("  <array>\n");
        buffer.append("    <dict>\n");
        buffer.append("      <key>settings</key>\n");
        buffer.append("      <dict>\n");
        buffer.append("        <key>foreground</key>\n");
        buffer.append("        <string>").append(Theme.toHex(theme.getForeground())).append("</string>\n");
        buffer.append("        <key>background</key>\n");
        buffer.append("        <string>").append(Theme.toHex(theme.getBackground())).append("</string>\n");
        buffer.append("        <key>caret</key>\n");
        buffer.append("        <string>").append(Theme.toHex(theme.getCaret())).append("</string>\n");
        buffer.append("        <key>lineHighlight</key>\n");
        buffer.append("        <string>").append(Theme.toHex(theme.getLineHighlight())).append("</string>\n");
        buffer.append("        <key>selection</key>\n");
        buffer.append("        <string>").append(Theme.toHex(theme.getSelection())).append("</string>\n");
        buffer.append("        <key>invisibles</key>\n");
        buffer.append("        <string>#404040</string>\n");
        buffer.append("      </dict>\n");
        buffer.append("    </dict>\n");
        for (ThemeRule rule : theme.getTokens()) {
            buffer.append("    <dict>\n");
            buffer.append("      <key>name</key>\n");
            buffer.append("      <string>").append(this.escape(rule.getName())).append("</string>\n");
            buffer.append("      <key>scope</key>\n");
            buffer.append("      <string>").append(this.escape(rule.getScopeSelector().toString())).append("</string>\n");
            buffer.append("      <key>settings</key>\n");
            buffer.append("      <dict>\n");
            DelayedTextAttribute attr = rule.getTextAttribute();
            RGBa color = attr.foreground;
            if (color != null) {
                buffer.append("        <key>foreground</key>\n");
                buffer.append("        <string>").append(Theme.toHex(color)).append("</string>\n");
            }
            if ((color = attr.background) != null) {
                buffer.append("        <key>background</key>\n");
                buffer.append("        <string>").append(Theme.toHex(color)).append("</string>\n");
            }
            StringBuilder value = new StringBuilder();
            int style = attr.style;
            if ((style & 2) != 0) {
                value.append("italic").append(',');
            }
            if ((style & 0x40000000) != 0) {
                value.append("underline").append(',');
            }
            if ((style & 1) != 0) {
                value.append("bold").append(',');
            }
            if (value.length() > 0) {
                value.deleteCharAt(value.length() - 1);
                buffer.append("        <key>fontStyle</key>\n");
                buffer.append("        <string>").append((CharSequence)value).append("</string>\n");
            }
            buffer.append("      </dict>\n");
            buffer.append("    </dict>\n");
        }
        buffer.append("  </array>\n");
        buffer.append("</dict>\n");
        buffer.append("</plist>\n");
        try {
            IOUtil.write((OutputStream)new FileOutputStream(themeFile), (String)buffer.toString());
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    private String escape(String raw) {
        return StringUtil.sanitizeHTML((String)raw);
    }
}

