/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.launch;

import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.launch.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class DebugPortNotificationDialog
extends MessageDialogWithToggle {
    private final IStatus detailedInformation;

    public DebugPortNotificationDialog(Shell parentShell, String dialogTitle, Image image, String message, IStatus detailedInformation, int dialogImageType, String toggleMessage, boolean toggleState) {
        super(parentShell, dialogTitle, image, message, dialogImageType, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.ABORT_LABEL}, 0, toggleMessage, toggleState);
        this.detailedInformation = detailedInformation;
        this.setPrefStore(PHPDebugPlugin.getDefault().getPreferenceStore());
        this.setPrefKey("com.aptana.php.debug.notifyNonStandardPort");
    }

    protected Button createToggleButton(Composite parent) {
        this.createInformationArea(parent);
        Label buffer = new Label(parent, 0);
        buffer.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        return super.createToggleButton(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId != 1 && this.getToggleState() && this.getPrefStore() != null && this.getPrefKey() != null) {
            this.getPrefStore().setValue(this.getPrefKey(), "never");
        }
    }

    protected void createInformationArea(Composite parent) {
        if (this.detailedInformation != null) {
            Group supportArea = new Group(parent, 0);
            supportArea.setText(Messages.DebugPortNotificationDialog_detailsGroupText);
            GridData supportData = new GridData(4, 4, true, true);
            supportArea.setLayoutData((Object)supportData);
            supportArea.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).create());
            IStatus[] status = null;
            status = this.detailedInformation.isMultiStatus() ? this.detailedInformation.getChildren() : new IStatus[]{this.detailedInformation};
            IStatus[] iStatusArray = status;
            int n = status.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus s = iStatusArray[n2];
                Image image = null;
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                switch (s.getSeverity()) {
                    case 4: {
                        image = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                        break;
                    }
                    case 1: {
                        image = sharedImages.getImage("IMG_OBJS_INFO_TSK");
                        break;
                    }
                    case 2: {
                        image = sharedImages.getImage("IMG_OBJS_WARN_TSK");
                    }
                }
                if (image != null) {
                    CLabel label = new CLabel((Composite)supportArea, 64);
                    label.setText(s.getMessage());
                    label.setImage(image);
                }
                ++n2;
            }
        }
    }
}

