/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core.server;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.server.PHPWebServer;
import com.aptana.webserver.core.AbstractWebServer;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;

public class PHPServersManager {
    public static final String DEFAULT_SERVER_PREFERENCES_KEY = "server_preferences";
    private static List<IServer> tempServers = new ArrayList<IServer>();
    private static final int DEFAULT_PORT = 80;

    public static IServer[] getTemporaryServers() {
        return tempServers.toArray(new IServer[tempServers.size()]);
    }

    public static AbstractWebServer createTemporaryServer(String host, int port, boolean isSecure) {
        return new PHPWebServer(host, port, isSecure, false);
    }

    public static void addTemporaryServer(IServer server) {
        tempServers.add(server);
    }

    public void removeTemporaryServer(AbstractWebServer server) {
        if (!tempServers.remove(server)) {
            URL url = server.getBaseURL();
            String host = url.getHost();
            int port = url.getPort();
            if (port < 0) {
                port = 80;
            }
            IServer temporaryServer = PHPServersManager.getTemporaryServer(host, port);
            tempServers.remove(temporaryServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IServer getTemporaryServer(String host, int port) {
        List<IServer> list = tempServers;
        synchronized (list) {
            for (IServer configuration : tempServers) {
                URL url = configuration.getBaseURL();
                if (!url.getHost().equals(host) || url.getPort() != port) continue;
                return configuration;
            }
        }
        return null;
    }

    public static IServer getServer(String name) {
        List<IServer> servers = PHPServersManager.getServers();
        for (IServer p : servers) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static IServer getServer(InetAddress address) {
        List<IServer> servers = PHPServersManager.getServers();
        for (IServer p : servers) {
            URL url = p.getBaseURL();
            String hostname = url.getHost();
            int port = url.getPort();
            if (port < 0) {
                port = 80;
            }
            try {
                InetAddress serverInetAddress = InetAddress.getByName(hostname);
                if (!address.equals(serverInetAddress)) continue;
                return p;
            }
            catch (UnknownHostException e) {
                IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Unknown host", (Throwable)e, (String)"com.aptana.php.debug/debug");
            }
        }
        return null;
    }

    public static IServer getDefaultServer(IProject project) {
        List<IServer> servers = PHPServersManager.getServers();
        if (CollectionsUtil.isEmpty(servers)) {
            return null;
        }
        return servers.get(0);
    }

    public static List<IServer> getServers() {
        return WebServerCorePlugin.getDefault().getServerManager().getServers();
    }
}

