/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.core.util.StringUtil;
import com.aptana.php.debug.ui.phpini.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPHPIniEntryDialog
extends TitleAreaDialog {
    private Text nameEdit;
    private Text contentEdit;
    private String name;
    private String value;
    private List<String> forbiddenNames = null;

    public NewPHPIniEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setForbiddenNames(List<String> names) {
        this.forbiddenNames = names;
    }

    protected void okPressed() {
        if (this.nameEdit != null) {
            this.name = this.nameEdit.getText();
        }
        if (this.contentEdit != null) {
            this.value = this.contentEdit.getText();
        }
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite returned = (Composite)super.createDialogArea(parent);
        Composite par = new Composite(returned, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        par.setLayoutData((Object)data);
        this.getShell().setText(Messages.NewPHPIniEntryDialog_createEntry);
        this.setTitle(Messages.NewPHPIniEntryDialog_createEntry);
        this.setMessage(Messages.NewPHPIniEntryDialog_inputNameValue);
        par.setLayout((Layout)new GridLayout(4, false));
        this.createNameEdit(par);
        this.createContentEdit(par);
        this.setTooltipText();
        return par;
    }

    private void createContentEdit(Composite par) {
        Label contentLabel = new Label(par, 0);
        contentLabel.setText(StringUtil.makeFormLabel((String)Messages.NewPHPIniEntryDialog_value));
        contentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentEdit = new Text(par, 2048);
        this.contentEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.value != null) {
            this.contentEdit.setText(this.value);
        }
        this.contentEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPIniEntryDialog.this.validate();
            }
        });
    }

    private void createNameEdit(Composite par) {
        Label nameLabel = new Label(par, 0);
        nameLabel.setText(StringUtil.makeFormLabel((String)Messages.NewPHPIniEntryDialog_name));
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameEdit = new Text(par, 2048);
        this.nameEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.nameEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPHPIniEntryDialog.this.validate();
            }
        });
        if (this.name != null) {
            this.nameEdit.setText(this.name);
        }
    }

    protected void setTooltipText() {
        this.contentEdit.setToolTipText(Messages.NewPHPIniEntryDialog_enterEntryValueTooltip);
    }

    private void validate() {
        String contentText = this.contentEdit.getText();
        String nameText = this.nameEdit.getText();
        if (nameText.length() == 0) {
            this.setOKButtonEnabled(false);
            this.setErrorMessage(Messages.NewPHPIniEntryDialog_entryNameMissingError);
            return;
        }
        String trimmedName = nameText.trim();
        if (this.forbiddenNames != null && this.forbiddenNames.contains(trimmedName)) {
            this.setOKButtonEnabled(false);
            this.setErrorMessage(Messages.NewPHPIniEntryDialog_entryNameDuplicateError);
            return;
        }
        if (contentText.length() == 0) {
            this.setErrorMessage(Messages.NewPHPIniEntryDialog_missingEntryValueError);
            this.setOKButtonEnabled(false);
            return;
        }
        this.setErrorMessage(null);
        this.setOKButtonEnabled(true);
    }

    private void setOKButtonEnabled(boolean enabled) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }
}

