/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.core.util.ArrayUtil;
import com.aptana.php.debug.core.PHPDebugSupportManager;
import com.aptana.php.debug.ui.phpini.INIFileSection;
import com.aptana.php.debug.ui.phpini.IPhpIniFileModifier;
import com.aptana.php.debug.ui.phpini.PHPIniEntry;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class PHPIniContentProvider
implements ITreeContentProvider {
    private IPhpIniFileModifier modifier;
    private String fileName;

    public PHPIniContentProvider(String fileName) throws IOException {
        this.modifier = PHPDebugSupportManager.getLaunchSupport().getPhpIniFileModifier(new File(fileName));
        this.fileName = fileName;
    }

    public Object[] getElements(Object inputElement) {
        List<INIFileSection> sections = this.modifier.getSections();
        return sections.toArray();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof INIFileSection) {
            List<PHPIniEntry> entries = ((INIFileSection)parentElement).getEntries();
            return entries.toArray();
        }
        return ArrayUtil.NO_OBJECTS;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == null) {
            return true;
        }
        if (element instanceof INIFileSection) {
            return !((INIFileSection)element).getEntries().isEmpty();
        }
        return false;
    }

    public void save() throws IOException {
        if (this.modifier != null) {
            this.modifier.flush();
        }
    }

    public boolean isDirtyINI() {
        if (this.modifier != null) {
            return this.modifier.isDirty();
        }
        return false;
    }

    public void modifyEntry(PHPIniEntry entry, String value) {
        this.modifier.addEntry(entry.getSection().getName(), entry.getKey(), value, true, Pattern.quote(entry.getValue()));
    }

    public void addEntry(INIFileSection section, String name, String value) {
        this.modifier.addEntry(section.getName(), name, value);
    }

    public void insertEntry(PHPIniEntry before, String name, String value) {
        this.modifier.insertEntry(before, name, value);
    }

    public void insertEntryToSectionBeginning(INIFileSection section, String name, String value) {
        this.modifier.insertEntryToSectionBeginning(section, name, value);
    }

    public INIFileSection getSectionByName(String name) {
        return this.modifier.getSectionByName(name);
    }

    public INIFileSection getGlobalSection() {
        return this.modifier.getGlobalSection();
    }

    public void removeEntry(PHPIniEntry entry) {
        this.modifier.removeEntry(entry.getSection().getName(), entry.getKey(), Pattern.quote(entry.getValue()));
    }

    public void removeSection(INIFileSection section) {
        this.modifier.removeSection(section);
    }

    public INIFileSection addSection(String sectionName) {
        return this.modifier.addSection(sectionName);
    }

    public List<INIFileSection> getSections() {
        return this.modifier.getSections();
    }

    public void commentEntry(PHPIniEntry entry) {
        this.modifier.commentEntry(entry.getSection().getName(), entry.getKey(), Pattern.quote(entry.getValue()));
    }

    public void uncommentEntry(PHPIniEntry entry) {
        this.modifier.uncommentEntry(entry.getSection().getName(), entry.getKey(), Pattern.quote(entry.getValue()));
    }
}

