/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.php.debug.ui.phpini.INIFileSection;
import java.util.Map;

public class PHPIniEntry
implements Map.Entry<String, String> {
    private static final String[] EXTENSION_ENTRIES = new String[]{"extension", "zend_extension", "zend_extension_ts"};
    private String key;
    private String value;
    private boolean commented;
    private VALIDATION validity;
    private String validationNote;
    private final INIFileSection parent;

    public PHPIniEntry(String key, String value, INIFileSection parent) {
        this.key = key;
        this.value = value;
        this.parent = parent;
        this.validity = VALIDATION.UNKNOWN;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String val) {
        this.value = val;
        return val;
    }

    public INIFileSection getSection() {
        return this.parent;
    }

    public VALIDATION getValidationState() {
        return this.validity;
    }

    public void setValidationState(VALIDATION state, String validationNote) {
        this.validity = state;
        this.validationNote = validationNote;
    }

    public String getValidationNote() {
        return this.validationNote;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public void setCommented(boolean commented) {
        this.commented = commented;
    }

    public boolean getCommented() {
        return this.commented;
    }

    public boolean isExtensionEntry() {
        if (this.getCommented()) {
            return false;
        }
        String[] stringArray = EXTENSION_ENTRIES;
        int n = EXTENSION_ENTRIES.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (ext.equalsIgnoreCase(this.getKey())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PHPIniEntry other = (PHPIniEntry)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static enum VALIDATION {
        UNKNOWN,
        OK,
        ERROR,
        WARNING;

    }
}

