/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.PHPDebugSupportManager;
import com.aptana.php.debug.core.util.FileUtils;
import com.aptana.php.debug.ui.phpini.INIFileSection;
import com.aptana.php.debug.ui.phpini.Messages;
import com.aptana.php.debug.ui.phpini.PHPIniContentProvider;
import com.aptana.php.debug.ui.phpini.PHPIniEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PHPIniValidator {
    private static final String PHP = "PHP";
    private static final String DYLD = "dyld:";
    private static final String DLL_EXT = ".dll";
    private static final String SO_EXT = ".so";
    private static final String PHP_LOADING_ERROR_STRING = "unable to load";
    private final PHPIniContentProvider provider;
    private final String phpExePath;
    private String libraryPath;
    private File iniFile;
    private boolean isRunning;
    private Object lock = new Object();
    private List<PHPIniEntry> faultingExtensions;
    private Map<String, PHPIniEntry> mappedEntries;
    private boolean validationCanceled;
    private boolean validationCompleted;
    private final String debuggerID;

    public PHPIniValidator(PHPIniContentProvider provider, String phpExePath, String debuggerID) {
        this.provider = provider;
        this.phpExePath = phpExePath;
        this.debuggerID = debuggerID;
        File exePath = new File(phpExePath);
        this.libraryPath = exePath.getParent();
        this.iniFile = new File(provider.getFileName());
        this.faultingExtensions = new ArrayList<PHPIniEntry>(5);
        FileUtils.setExecutablePermissions(exePath);
        this.loadActiveExtensions();
    }

    private void loadActiveExtensions() {
        this.mappedEntries = new HashMap<String, PHPIniEntry>();
        List<INIFileSection> sections = this.provider.getSections();
        for (INIFileSection section : sections) {
            List<PHPIniEntry> entries = section.getEntries();
            for (PHPIniEntry entry : entries) {
                if (!entry.isExtensionEntry()) continue;
                String extensionValue = entry.getValue();
                if (extensionValue.endsWith(SO_EXT)) {
                    extensionValue = extensionValue.substring(0, extensionValue.length() - 3);
                } else if (extensionValue.endsWith(DLL_EXT)) {
                    extensionValue = extensionValue.substring(0, extensionValue.length() - 4);
                }
                this.mappedEntries.put(extensionValue, entry);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void validate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [33[DOLOOP]], but top level block is 34[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void innerValidate(List<PHPIniEntry> extensions, IProgressMonitor monitor) throws IOException {
        this.validationCanceled = false;
        this.validationCompleted = false;
        List<String> processExecutionResults = this.getProcessExecutionResults(monitor);
        if (processExecutionResults == null) {
            return;
        }
        if (processExecutionResults.isEmpty()) {
            monitor.worked(extensions.size());
        } else {
            List<String> fatalErrors = PHPIniValidator.extractFatalErrors(processExecutionResults);
            if (fatalErrors.isEmpty()) {
                this.markEntriesWithWarning(processExecutionResults);
                monitor.worked(extensions.size());
            } else {
                monitor.worked(1);
                if (!monitor.isCanceled()) {
                    this.removeFaultingEntries(fatalErrors, extensions, monitor);
                }
            }
        }
    }

    private void markEntriesWithWarning(List<String> warnings) {
        this.markMatchingEntries(warnings, false, null);
    }

    private void removeFaultingEntries(List<String> fatalErrors, List<PHPIniEntry> extensions, IProgressMonitor monitor) throws IOException {
        this.markMatchingEntries(fatalErrors, true, extensions);
        this.provider.save();
        this.innerValidate(extensions, monitor);
    }

    private void markMatchingEntries(List<String> processOutputLines, boolean isError, List<PHPIniEntry> extensions) {
        block0: for (String line : processOutputLines) {
            for (String entryValue : this.mappedEntries.keySet()) {
                String testEntry = entryValue;
                if (testEntry.toLowerCase().startsWith("php_")) {
                    testEntry = testEntry.substring(4);
                }
                if (line.indexOf(testEntry) <= -1 && line.indexOf(entryValue) <= -1) continue;
                PHPIniEntry iniEntry = this.mappedEntries.get(entryValue);
                if (isError) {
                    iniEntry.setValidationState(PHPIniEntry.VALIDATION.ERROR, line);
                    this.faultingExtensions.add(iniEntry);
                    extensions.remove(iniEntry);
                    this.provider.commentEntry(iniEntry);
                    continue block0;
                }
                if (line.toLowerCase().indexOf(PHP_LOADING_ERROR_STRING) > -1) {
                    iniEntry.setValidationState(PHPIniEntry.VALIDATION.ERROR, line);
                    continue block0;
                }
                iniEntry.setValidationState(PHPIniEntry.VALIDATION.WARNING, line);
                continue block0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getProcessExecutionResults(final IProgressMonitor monitor) throws IOException {
        File tempIniFile = PHPDebugSupportManager.getLaunchSupport().generatePhpIni(this.iniFile, this.phpExePath, null, this.debuggerID);
        ProcessBuilder builder = new ProcessBuilder(this.phpExePath, "-c", tempIniFile.getAbsolutePath(), "-i");
        if (!"win32".equals(Platform.getOS())) {
            if ("macosx".equals(Platform.getOS())) {
                builder.environment().put("DYLD_LIBRARY_PATH", this.libraryPath);
            } else {
                builder.environment().put("LD_LIBRARY_PATH", this.libraryPath);
            }
        }
        builder.directory(new File(this.phpExePath).getParentFile());
        final Process process = builder.start();
        Job monitorCancelListener = new Job("Validation Cancel Listener"){

            protected IStatus run(IProgressMonitor monitor2) {
                int timeLimit = 60;
                while (--timeLimit > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (PHPIniValidator.this.validationCompleted) {
                        return Status.CANCEL_STATUS;
                    }
                    if (!monitor.isCanceled()) continue;
                    try {
                        process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        process.destroy();
                        PHPIniValidator.this.validationCanceled = true;
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        monitorCancelListener.setSystem(EclipseUtil.showSystemJobs());
        monitorCancelListener.setProgressGroup(monitor, -1);
        monitorCancelListener.schedule();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while (!monitor.isCanceled() && (line = reader.readLine()) != null) {
                if (!PHPDebugPlugin.DEBUG) continue;
                System.out.println(line);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return PHPIniValidator.getProcessErrorLines(process.getErrorStream());
    }

    public static List<String> getProcessErrorLines(InputStream errorStream) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(errorStream));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int linesCount;
                if (PHPDebugPlugin.DEBUG) {
                    System.err.println(line);
                }
                if (line.startsWith(PHP)) {
                    lines.add(line);
                    continue;
                }
                if (!line.startsWith(DYLD)) continue;
                StringBuilder stringBuilder = new StringBuilder();
                int n = linesCount = line.indexOf("error", 4) > -1 ? 3 : 2;
                if (linesCount < 3) {
                    lines.add(line);
                }
                while ((line = reader.readLine()) != null && linesCount-- > 0) {
                    if (PHPDebugPlugin.DEBUG) {
                        System.err.println(line);
                    }
                    if (line.startsWith(PHP)) {
                        lines.add(line);
                        break;
                    }
                    stringBuilder.append(FileUtil.NEW_LINE);
                    stringBuilder.append(line);
                    if (line.toLowerCase().startsWith("reason")) break;
                }
                lines.add(stringBuilder.toString());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return lines;
    }

    public static List<String> extractFatalErrors(List<String> processExecutionResults) {
        ArrayList<String> errors = new ArrayList<String>(processExecutionResults.size());
        ArrayList<String> warnings = new ArrayList<String>(processExecutionResults.size());
        for (String str : processExecutionResults) {
            String lowerCaseStr = str.toLowerCase();
            if (lowerCaseStr.indexOf(" fatal ") > -1 || lowerCaseStr.indexOf(DYLD) > -1) {
                errors.add(str);
                continue;
            }
            warnings.add(str);
        }
        processExecutionResults.clear();
        processExecutionResults.addAll(warnings);
        return errors;
    }

    private class ExtensionsValidatorRunnable
    implements IRunnableWithProgress {
        private final List<PHPIniEntry> extensions;

        ExtensionsValidatorRunnable(List<PHPIniEntry> extensions) {
            this.extensions = extensions;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.PHPIniValidator_validatingExtensionTaskName, this.extensions.size());
            try {
                try {
                    PHPIniValidator.this.innerValidate(this.extensions, monitor);
                }
                catch (IOException e) {
                    monitor.done();
                    IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Error while validating the PHP extensions", (Throwable)e, (String)"com.aptana.php.debug/debug");
                    MessageDialog.openError(null, (String)Messages.PHPIniValidator_errorTitle, (String)Messages.PHPIniValidator_extensionValidationErrorMessage);
                    monitor.done();
                    PHPIniValidator.this.validationCompleted = true;
                }
            }
            finally {
                monitor.done();
                PHPIniValidator.this.validationCompleted = true;
            }
        }
    }
}

