/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp.internal;

import com.aptana.filesystem.secureftp.internal.Messages;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SFTPFileDownloadInputStream
extends InputStream {
    private FileTransferInputStream ftpInputStream;

    public SFTPFileDownloadInputStream(FileTransferInputStream ftpInputStream) {
        this.ftpInputStream = ftpInputStream;
    }

    private void safeClose() {
        try {
            this.ftpInputStream.close();
        }
        catch (IOException e) {
            SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPFileDownloadInputStream_ErrorDownload, (Throwable)e));
        }
    }

    public int read() throws IOException {
        try {
            return this.ftpInputStream.read();
        }
        catch (IOException e) {
            this.safeClose();
            throw e;
        }
    }

    public int available() throws IOException {
        try {
            return this.ftpInputStream.available();
        }
        catch (IOException e) {
            this.safeClose();
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpInputStream.close();
        }
        finally {
            this.safeClose();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.ftpInputStream.read(b, off, len);
        }
        catch (IOException e) {
            this.safeClose();
            throw e;
        }
    }
}

