/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp.internal;

import com.aptana.filesystem.secureftp.internal.Messages;
import com.aptana.filesystem.secureftp.internal.SecureFTPPlugin;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SFTPFileUploadOutputStream
extends OutputStream {
    private SSHFTPClient ftpClient;
    private FileTransferOutputStream ftpOutputStream;
    private String filename;
    private Date modificationTime;
    private long permissions;
    private Runnable completeRunnable;

    public SFTPFileUploadOutputStream(SSHFTPClient ftpClient, FileTransferOutputStream ftpOutputStream, String filename, Date modificationTime, long permissions, Runnable completeRunnable) {
        this.ftpClient = ftpClient;
        this.ftpOutputStream = ftpOutputStream;
        this.filename = filename;
        this.modificationTime = modificationTime;
        this.permissions = permissions;
        this.completeRunnable = completeRunnable;
    }

    private void safeClose(boolean failed) {
        try {
            try {
                if (this.ftpClient.connected() && failed && this.filename != null) {
                    this.ftpClient.delete(this.ftpOutputStream.getRemoteFile());
                }
            }
            catch (Exception e) {
                SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPFileUploadOutputStream_ErrorUpload, (Throwable)e));
                try {
                    this.ftpOutputStream.close();
                }
                catch (IOException e2) {
                    SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPFileUploadOutputStream_ErrorCloseStream, (Throwable)e2));
                }
                if (this.completeRunnable != null) {
                    this.completeRunnable.run();
                    this.completeRunnable = null;
                }
            }
        }
        finally {
            try {
                this.ftpOutputStream.close();
            }
            catch (IOException e) {
                SecureFTPPlugin.log((IStatus)new Status(4, "com.aptana.filesystem.secureftp", Messages.SFTPFileUploadOutputStream_ErrorCloseStream, (Throwable)e));
            }
            if (this.completeRunnable != null) {
                this.completeRunnable.run();
                this.completeRunnable = null;
            }
        }
    }

    public void write(int b) throws IOException {
        try {
            this.ftpOutputStream.write(b);
        }
        catch (IOException e) {
            this.safeClose(true);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpOutputStream.close();
            try {
                String actualFilename;
                String string = actualFilename = this.filename != null ? this.filename : this.ftpOutputStream.getRemoteFile();
                if (this.filename != null) {
                    if (this.ftpClient.exists(this.filename)) {
                        this.ftpClient.delete(this.filename);
                        this.filename = null;
                    }
                    this.ftpClient.rename(this.ftpOutputStream.getRemoteFile(), actualFilename);
                    this.filename = null;
                }
                try {
                    if (this.modificationTime != null) {
                        this.ftpClient.setModTime(actualFilename, this.modificationTime);
                    }
                    if (this.permissions > 0L) {
                        this.ftpClient.changeMode((int)(this.permissions & 0x1FFL), actualFilename);
                    }
                }
                catch (FTPException e) {
                    if (e.getReplyCode() != 3) {
                        throw e;
                    }
                }
            }
            catch (FTPException e) {
                this.safeClose(true);
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
        }
        finally {
            this.safeClose(false);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.ftpOutputStream.write(b, off, len);
        }
        catch (IOException e) {
            this.safeClose(true);
            throw e;
        }
    }
}

