/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.samples.ui.portal.actionController;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.CommandHandlerActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.samples.ISamplesManager;
import com.aptana.samples.SamplesPlugin;
import com.aptana.samples.model.IProjectSample;
import com.aptana.samples.model.SampleCategory;
import com.aptana.samples.model.SamplesReference;
import com.aptana.samples.ui.SamplesUIPlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesActionController
extends AbstractActionController {
    protected static final String IMPORT_SAMPLE_COMMAND = "com.aptana.samples.ui.commands.import";
    protected static final String IMPORT_SAMPLE_COMMAND_ID = "id";
    protected static final String WEB_NATURE = "com.aptana.projects.webnature";
    protected static final String MOBILE_NATURE = "com.appcelerator.titanium.mobile.nature";

    @ControllerAction
    public Object getSamples() {
        ArrayList samples = new ArrayList();
        ISamplesManager samplesManager = SamplesPlugin.getDefault().getSamplesManager();
        List categories = samplesManager.getCategories();
        for (SampleCategory category : categories) {
            for (IProjectSample sample : samplesManager.getSamplesForCategory(category.getId())) {
                HashMap<String, String> sampleInfo = new HashMap<String, String>();
                sampleInfo.put(SAMPLE_INFO.CATEGORY.toString(), category.getName());
                sampleInfo.put(SAMPLE_INFO.NAME.toString(), sample.getName());
                sampleInfo.put(SAMPLE_INFO.ID.toString(), sample.getId());
                sampleInfo.put(SAMPLE_INFO.DESCRIPTION.toString(), sample.getDescription());
                sampleInfo.put(SAMPLE_INFO.IMAGE.toString(), "");
                samples.add(sampleInfo);
            }
        }
        return JSON.toString((Object[])samples.toArray(new Map[samples.size()]));
    }

    @ControllerAction
    public Object addSample(Object attributes) {
        ISamplesManager samplesManager = SamplesPlugin.getDefault().getSamplesManager();
        Object[] arr = (Object[])attributes;
        if (arr == null || arr.length < 1 || arr[0] == null || !(arr[0] instanceof HashMap)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"The addSample ControllerAction should get an attribute in JSON format", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        HashMap sampleData = (HashMap)arr[0];
        String id = (String)sampleData.get(SAMPLE_INFO.ID.toString());
        if (StringUtil.isEmpty((String)id)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample Missing required attribute id", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String name = (String)sampleData.get(SAMPLE_INFO.NAME.toString());
        if (StringUtil.isEmpty((String)name)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample Missing required attribute name", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String description = (String)sampleData.get(SAMPLE_INFO.DESCRIPTION.toString());
        if (StringUtil.isEmpty((String)description)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample Missing required attribute description", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String location = (String)sampleData.get(SAMPLE_INFO.PATH.toString());
        if (StringUtil.isEmpty((String)location)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample Missing required attribute path", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        boolean isRemote = !new File(location).exists();
        String category = (String)sampleData.get(SAMPLE_INFO.CATEGORY.toString());
        if (StringUtil.isEmpty((String)category)) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"Sample Missing required attribute category", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        SampleCategory sampleCategory = samplesManager.getCategory(category);
        if (sampleCategory == null) {
            sampleCategory = new SampleCategory(category, "Others", null);
        }
        URL iconUrl = null;
        String iconPath = null;
        try {
            iconPath = (String)sampleData.get(SAMPLE_INFO.IMAGE.toString());
            if (StringUtil.isEmpty((String)iconPath)) {
                IdeLog.logWarning((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("Unable to retrieve the icon at {0} for sample {1}", iconPath, name));
            } else {
                iconUrl = new URL(iconPath);
            }
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)MessageFormat.format("malformed icon URL at {0}", iconPath));
        }
        HashMap<String, URL> iconUrls = new HashMap<String, URL>();
        iconUrls.put("default", iconUrl);
        SamplesReference sample = new SamplesReference(sampleCategory, id, name, location, isRemote, description, iconUrls, (IPath)new Path("app"), null);
        String[] natures = (String[])sampleData.get(SAMPLE_INFO.NATURES.toString());
        if (natures == null || natures.length < 1) {
            natures = new String[]{WEB_NATURE, MOBILE_NATURE};
        }
        sample.setNatures(natures);
        samplesManager.addSample((IProjectSample)sample);
        return IBrowserNotificationConstants.JSON_OK;
    }

    @ControllerAction
    public Object importSample(Object attributes) {
        String sampleID = this.getSampleId(attributes);
        if (sampleID == null) {
            IdeLog.logError((Plugin)SamplesUIPlugin.getDefault(), (String)"The importSample ControllerAction should get a sampleID attribute", (String)"com.aptana.portal.ui/debug/startpage");
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        CommandHandlerActionController commandHandler = new CommandHandlerActionController();
        HashMap<String, String> commandArguments = new HashMap<String, String>();
        commandArguments.put(IMPORT_SAMPLE_COMMAND_ID, sampleID);
        String callback = this.getCallback(attributes);
        return commandHandler.execute((Object)new Object[]{IMPORT_SAMPLE_COMMAND, commandArguments, callback});
    }

    private String getSampleId(Object attributes) {
        if (attributes instanceof Object[]) {
            Object[] arr = (Object[])attributes;
            if (arr.length > 0 && arr[0] != null) {
                return arr[0].toString();
            }
            String message = MessageFormat.format("Wrong argument count passed to SamplesActionController::importSample. Expected 1 and got {0}", arr.length);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        } else {
            String message = MessageFormat.format("Wrong argument type passed to SamplesActionController::importSample. Expected Object[] and got {0}", attributes == null ? "null" : attributes.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return null;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SAMPLE_INFO {
        CATEGORY("category"),
        ID("id"),
        NAME("name"),
        DESCRIPTION("description"),
        PATH("location"),
        NATURES("natures"),
        IMAGE("image");

        private final String name;

        private SAMPLE_INFO(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

