/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter;

import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.editor.php.formatter.PHPCodeFormatterPlugin;
import com.aptana.editor.php.formatter.PHPFormatterContext;
import com.aptana.editor.php.formatter.PHPFormatterNodeBuilder;
import com.aptana.editor.php.formatter.PHPFormatterNodeRewriter;
import com.aptana.editor.php.internal.parser.PHPParseRootNode;
import com.aptana.editor.php.internal.parser.PHPParser;
import com.aptana.editor.php.internal.parser.nodes.PHPASTWrappingNode;
import com.aptana.formatter.AbstractScriptFormatter;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterIndentDetector;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.FormatterWriter;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterIndentGenerator;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.IScriptFormatter;
import com.aptana.formatter.epl.FormatterPlugin;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.ui.FormatterException;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.parsing.IParser;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.ast.ParseNode;
import com.aptana.ui.util.StatusLineMessageTimerManager;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org2.eclipse.php.internal.core.ast.match.ASTMatcher;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.rewrite.ASTRewriteFlattener;
import org2.eclipse.php.internal.core.ast.rewrite.RewriteEventStore;

public class PHPFormatter
extends AbstractScriptFormatter
implements IScriptFormatter {
    protected static final String[] BRACE_POSITIONS = new String[]{"php.formatter.brace.position.blocks", "php.formatter.brace.position.case.block", "php.formatter.brace.position.switch.block", "php.formatter.brace.position.function.declaration", "php.formatter.brace.position.class.declaration"};
    protected static final String[] NEW_LINES_POSITIONS = new String[]{"php.formatter.newline.before.catch", "php.formatter.newline.before.dowhile", "php.formatter.newline.before.else", "php.formatter.newline.before.if.in.elseif", "php.formatter.newline.between.array.creation.elements"};
    protected static final String[] INDENTATIONS = new String[]{"php.formatter.indent.php.body", "php.formatter.indent.blocks", "php.formatter.indent.namespace.blocks", "php.formatter.indent.case.body", "php.formatter.indent.switch.body", "php.formatter.indent.function.body", "php.formatter.indent.class.body", "php.formatter.indent.breakInCase"};
    protected static final String[] SPACES = new String[]{"php.formatter.spaces.after.staticInvocation", "php.formatter.spaces.before.staticInvocation", "php.formatter.spaces.before.assignment", "php.formatter.spaces.after.assignment", "php.formatter.spaces.before.commas", "php.formatter.spaces.after.commas", "php.formatter.spaces.after.case.colon", "php.formatter.spaces.before.case.colon", "php.formatter.spaces.before.colon", "php.formatter.spaces.after.colon", "php.formatter.spaces.before.semicolon", "php.formatter.spaces.after.semicolon", "php.formatter.spaces.before.dot", "php.formatter.spaces.after.dot", "php.formatter.spaces.before.arrow", "php.formatter.spaces.after.arrow", "php.formatter.spaces.before.keyValue", "php.formatter.spaces.after.keyValue", "php.formatter.spaces.before.relational", "php.formatter.spaces.after.relational", "php.formatter.spaces.before.conditional", "php.formatter.spaces.after.conditional", "php.formatter.spaces.before.postfix", "php.formatter.spaces.after.postfix", "php.formatter.spaces.before.prefix", "php.formatter.spaces.after.prefix", "php.formatter.spaces.before.arithmetic", "php.formatter.spaces.after.arithmetic", "php.formatter.spaces.before.unary", "php.formatter.spaces.after.unary", "php.formatter.spaces.before.namespaceSeparator", "php.formatter.spaces.after.namespaceSeparator", "php.formatter.spaces.before.forSemicolon", "php.formatter.spaces.after.forSemicolon", "php.formatter.spaces.before.parentheses", "php.formatter.spaces.after.parentheses", "php.formatter.spaces.before.parentheses.closing", "php.formatter.spaces.before.declaration.parentheses.opening", "php.formatter.spaces.after.declaration.parentheses.opening", "php.formatter.spaces.before.declaration.parentheses.closing", "php.formatter.spaces.before.invocation.parentheses.opening", "php.formatter.spaces.after.invocation.parentheses.opening", "php.formatter.spaces.before.invocation.parentheses.closing", "php.formatter.spaces.before.array.access.parentheses.opening", "php.formatter.spaces.after.array.access.parentheses.opening", "php.formatter.spaces.before.array.access.parentheses.closing", "php.formatter.spaces.before.loop.parentheses.opening", "php.formatter.spaces.after.loop.parentheses.opening", "php.formatter.spaces.before.loop.parentheses.closing", "php.formatter.spaces.before.conditional.parentheses.opening", "php.formatter.spaces.after.conditional.parentheses.opening", "php.formatter.spaces.before.conditional.parentheses.closing"};
    private static final String PHP_SHORT_TAG_OPEN = "<?";
    private static final String PHP_SHORT_ASSIGN_TAG_OPEN = "<?=";
    private static final String PHP_PREFIX = "<?php ";
    private static final String PHP_CLOSE_TAG = "?>";
    private static final Pattern PHP_OPEN_TAG_PATTERNS = Pattern.compile("<\\?php|<\\?=|<\\?");
    private static final Pattern MULTI_LINE_FLATTEN_PATTERN = Pattern.compile("\\s|/|\\*");
    private static final Pattern SINGLE_LINE_FLATTEN_PATTERN = Pattern.compile("\\s|/|#");

    protected PHPFormatter(String lineSeparator, Map<String, String> preferences, String mainContentType) {
        super(preferences, mainContentType, lineSeparator);
    }

    public int detectIndentationLevel(IDocument document, int offset, boolean isSelection, IFormattingContext formattingContext) {
        int indent = 0;
        try {
            ITypedRegion partition = document.getPartition(offset);
            if (partition != null && partition.getOffset() == offset) {
                char onOffset;
                int indentationLevel = super.detectIndentationLevel(document, offset);
                if (!this.getBoolean("php.formatter.indent.php.body") && ((onOffset = document.getChar(offset)) == '\r' ? document.getChar(offset - 1) != '\n' : onOffset == '\n')) {
                    return indentationLevel - 1;
                }
                return indentationLevel;
            }
            String source = document.get();
            PHPParser parser = (PHPParser)this.checkoutParser();
            Program ast = parser.parseAST((Reader)new StringReader(source));
            this.checkinParser((IParser)parser);
            if (ast != null) {
                PHPParseRootNode rootNode = new PHPParseRootNode((Symbol[])new ParseNode[0], ast.getStart(), ast.getEnd());
                rootNode.addChild((IParseNode)new PHPASTWrappingNode(ast));
                PHPFormatterNodeBuilder builder = new PHPFormatterNodeBuilder();
                FormatterDocument formatterDocument = this.createFormatterDocument(source, offset);
                IFormatterContainerNode root = builder.build((IParseNode)rootNode, formatterDocument);
                new PHPFormatterNodeRewriter((IParseRootNode)rootNode, formatterDocument).rewrite(root);
                PHPFormatterContext context = new PHPFormatterContext(0);
                FormatterIndentDetector detector = new FormatterIndentDetector(offset);
                try {
                    root.accept((IFormatterContext)context, (IFormatterWriter)detector);
                    return detector.getLevel();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            return super.detectIndentationLevel(document, offset);
        }
        return indent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextEdit format(String source, int offset, int length, int indentationLevel, boolean isSelection, IFormattingContext context, String indentSufix) throws FormatterException {
        int offsetIncludedOpenTag = offset;
        int offsetBySelection = 0;
        int lengthBySelection = 0;
        if (isSelection) {
            IRegion selectedRegion = (IRegion)context.getProperty((Object)"formatting.context.region");
            offsetBySelection = selectedRegion.getOffset();
            lengthBySelection = selectedRegion.getLength();
        }
        offsetIncludedOpenTag = Math.max(0, this.findOpenTagOffset(source, offset, offsetBySelection, offsetBySelection + lengthBySelection));
        String input = source.substring(offsetIncludedOpenTag, offset + length);
        try {
            String trimmed;
            boolean forcedPHPEndTag = false;
            if (!input.startsWith(PHP_SHORT_TAG_OPEN)) {
                input = PHPFormatter.leftTrim((String)input, (int)0);
                input = PHP_PREFIX + input;
            } else if (input.startsWith(PHP_SHORT_ASSIGN_TAG_OPEN) && this.shouldAppendPHPCloseTag(trimmed = input.trim())) {
                input = String.valueOf(input) + PHP_CLOSE_TAG;
                forcedPHPEndTag = true;
            }
            PHPParser parser = (PHPParser)this.checkoutParser("com.aptana.contenttype.php");
            Program ast = parser.parseAST((Reader)new StringReader(input));
            this.checkinParser((IParser)parser);
            if (ast != null) {
                String suffix = this.beginsWithCloseTag(source, offset + length) ? " " : "";
                PHPParseRootNode rootNode = new PHPParseRootNode((Symbol[])new ParseNode[0], ast.getStart(), ast.getEnd());
                rootNode.addChild((IParseNode)new PHPASTWrappingNode(ast));
                String output = this.format(input, (IParseRootNode)rootNode, indentationLevel, offsetIncludedOpenTag, isSelection, suffix, indentSufix);
                if (forcedPHPEndTag) {
                    input = input.substring(0, input.length() - PHP_CLOSE_TAG.length());
                }
                if (output == null) return null;
                if (input.equals(output)) return new MultiTextEdit();
                if (this.equalContent(ast, input, output)) {
                    Matcher matcher = PHP_OPEN_TAG_PATTERNS.matcher(output);
                    if (!matcher.find()) return new ReplaceEdit(offset, length, output);
                    output = output.substring(matcher.end());
                    return new ReplaceEdit(offset, length, output);
                }
                if (ast.getAST().hasErrors()) {
                    StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.PHPFormatter_fatalSyntaxErrors, (long)3000L, (boolean)true);
                    return null;
                } else {
                    this.logError(input, output);
                }
                return null;
            } else {
                StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.PHPFormatter_fatalSyntaxErrors, (long)3000L, (boolean)true);
            }
            return null;
        }
        catch (FormatterException e) {
            StatusLineMessageTimerManager.setErrorMessage((String)NLS.bind((String)FormatterMessages.Formatter_formatterParsingErrorStatus, (Object)e.getMessage()), (long)3000L, (boolean)true);
            return null;
        }
        catch (Exception e) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorStatus, (long)3000L, (boolean)true);
            IdeLog.logError((Plugin)PHPCodeFormatterPlugin.getDefault(), (Throwable)e, (String)"com.aptana.formatter.epl/debug");
        }
        return null;
    }

    private boolean shouldAppendPHPCloseTag(String content) {
        return !content.endsWith(";") && !content.endsWith("}") && !content.endsWith(PHP_CLOSE_TAG);
    }

    private boolean beginsWithCloseTag(String source, int offset) {
        int closeTagIndex = source.indexOf(PHP_CLOSE_TAG, offset);
        return closeTagIndex > -1 && source.substring(offset, closeTagIndex).trim().length() == 0;
    }

    private boolean equalContent(Program inputAST, String inputString, String outputString) {
        if (outputString == null) {
            return false;
        }
        if ((outputString = outputString.trim()).startsWith(PHP_SHORT_ASSIGN_TAG_OPEN)) {
            if (this.shouldAppendPHPCloseTag(outputString)) {
                outputString = String.valueOf(outputString) + PHP_CLOSE_TAG;
            }
        } else {
            outputString = String.valueOf(outputString) + '\n';
        }
        PHPParser parser = (PHPParser)this.checkoutParser("com.aptana.contenttype.php");
        Program outputAST = parser.parseAST((Reader)new StringReader(outputString));
        this.checkinParser((IParser)parser);
        if (outputAST == null) {
            return false;
        }
        ASTMatcher matcher = new ASTMatcher(true);
        boolean result = true;
        boolean matchWithoutComments = true;
        result = this.getBoolean("php.formatter.wrap.comments") ? (matchWithoutComments = matcher.match(inputAST.getProgramRoot(), (Object)outputAST.getProgramRoot(), false)) && this.matchComments(inputAST.comments(), outputAST.comments(), inputString, outputString) : matcher.match(inputAST.getProgramRoot(), (Object)outputAST.getProgramRoot(), true);
        if (!result && (FormatterPlugin.getDefault().isDebugging() || EclipseUtil.isTesting()) && matchWithoutComments) {
            String flattenedInputAST = ASTRewriteFlattener.asString((ASTNode)inputAST, (RewriteEventStore)new RewriteEventStore());
            String flattenedOutputAST = ASTRewriteFlattener.asString((ASTNode)outputAST, (RewriteEventStore)new RewriteEventStore());
            FormatterUtils.logDiff((String)flattenedInputAST, (String)flattenedOutputAST);
        }
        return result;
    }

    private int findOpenTagOffset(String source, int offset, int leftBound, int rightBound) {
        int openOffset;
        if (leftBound > 0 && rightBound > leftBound) {
            source = source.substring(leftBound, rightBound);
        }
        if ((openOffset = source.lastIndexOf(PHP_SHORT_TAG_OPEN, offset)) > -1) {
            if (leftBound > 0) {
                return leftBound - openOffset;
            }
            return openOffset;
        }
        return offset;
    }

    public int getIndentSize() {
        return this.getInt("php.formatter.formatter.indentation.size", 1);
    }

    public String getIndentType() {
        return this.getString("php.formatter.formatter.tabulation.char");
    }

    public int getTabSize() {
        return this.getInt("php.formatter.formatter.tabulation.size", this.getEditorSpecificTabWidth());
    }

    public int getEditorSpecificTabWidth() {
        return EditorUtil.getSpaceIndentSize((String)PHPEplPlugin.getDefault().getBundle().getSymbolicName());
    }

    public boolean isEditorInsertSpacesForTabs() {
        return FormatterUtils.isInsertSpacesForTabs((IPreferenceStore)PHPEplPlugin.getDefault().getPreferenceStore());
    }

    private String format(String input, IParseRootNode parseResult, int indentationLevel, int offset, boolean isSelection, String suffix, String indentSufix) throws Exception {
        PHPFormatterNodeBuilder builder = new PHPFormatterNodeBuilder();
        FormatterDocument document = this.createFormatterDocument(input, offset);
        IFormatterContainerNode root = builder.build((IParseNode)parseResult, document);
        new PHPFormatterNodeRewriter(parseResult, document).rewrite(root);
        PHPFormatterContext context = new PHPFormatterContext(indentationLevel);
        IFormatterIndentGenerator indentGenerator = this.createIndentGenerator();
        FormatterWriter writer = new FormatterWriter((IFormatterDocument)document, this.lineSeparator, indentGenerator);
        writer.setWrapLength(this.getInt("php.formatter.wrap.comments.length"));
        writer.setLinesPreserve(this.getInt("php.formatter.line.preserve"));
        root.accept((IFormatterContext)context, (IFormatterWriter)writer);
        writer.flush((IFormatterContext)context);
        if (builder.hasErrors()) {
            StatusLineMessageTimerManager.setErrorMessage((String)FormatterMessages.Formatter_formatterErrorCompletedWithErrors, (long)3000L, (boolean)true);
        }
        String output = writer.getOutput();
        List offOnRegions = builder.getOffOnRegions();
        if (offOnRegions != null && !offOnRegions.isEmpty()) {
            List<IRegion> outputOnOffRegions = this.getOutputOnOffRegions(output, this.getString("php.formatter.formatter.off"), this.getString("php.formatter.formatter.on"));
            output = FormatterUtils.applyOffOnRegions((String)input, (String)output, (List)offOnRegions, outputOnOffRegions);
        }
        if (indentationLevel > 1 && "".equals(indentSufix)) {
            StringBuilder indentBuilder = new StringBuilder();
            indentGenerator.generateIndent(Math.max(1, indentationLevel - 1), indentBuilder);
            indentSufix = indentBuilder.toString();
        }
        output = this.processNestedOutput(output.trim(), this.lineSeparator, suffix, indentSufix, false, true);
        return output;
    }

    protected List<IRegion> getOutputOnOffRegions(String output, String formatterOffPattern, String formatterOnPattern) {
        PHPParser parser = (PHPParser)this.checkoutParser("com.aptana.contenttype.php");
        Program ast = parser.parseAST((Reader)new StringReader(output));
        this.checkinParser((IParser)parser);
        List onOffRegions = null;
        if (ast != null) {
            LinkedHashMap<Integer, String> commentsMap = new LinkedHashMap<Integer, String>(ast.comments().size());
            for (Comment comment : ast.comments()) {
                int start = comment.getStart();
                int end = comment.getEnd();
                String commentStr = output.substring(start, end);
                commentsMap.put(start, commentStr);
            }
            if (!commentsMap.isEmpty()) {
                Pattern onPattern = Pattern.compile(Pattern.quote(formatterOnPattern));
                Pattern offPattern = Pattern.compile(Pattern.quote(formatterOffPattern));
                onOffRegions = FormatterUtils.resolveOnOffRegions(commentsMap, (Pattern)onPattern, (Pattern)offPattern, (int)(output.length() - 1));
            }
        }
        return onOffRegions;
    }

    private FormatterDocument createFormatterDocument(String input, int offset) {
        String key;
        FormatterDocument document = new FormatterDocument(input);
        document.setInt("php.formatter.formatter.tabulation.size", this.getInt("php.formatter.formatter.tabulation.size"));
        document.setBoolean("php.formatter.wrap.comments", this.getBoolean("php.formatter.wrap.comments"));
        document.setInt("php.formatter.line.after.class.declaration", this.getInt("php.formatter.line.after.class.declaration"));
        document.setInt("php.formatter.line.after.function.declaration", this.getInt("php.formatter.line.after.function.declaration"));
        document.setInt("formatting.context.originalOffset", offset);
        document.setBoolean("php.formatter.formatter.on.off.enabled", this.getBoolean("php.formatter.formatter.on.off.enabled"));
        document.setString("php.formatter.formatter.on", this.getString("php.formatter.formatter.on"));
        document.setString("php.formatter.formatter.off", this.getString("php.formatter.formatter.off"));
        String[] stringArray = INDENTATIONS;
        int n = INDENTATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setBoolean(key, this.getBoolean(key));
            ++n2;
        }
        stringArray = NEW_LINES_POSITIONS;
        n = NEW_LINES_POSITIONS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setBoolean(key, this.getBoolean(key));
            ++n2;
        }
        stringArray = BRACE_POSITIONS;
        n = BRACE_POSITIONS.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setString(key, this.getString(key));
            ++n2;
        }
        stringArray = SPACES;
        n = SPACES.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            document.setInt(key, this.getInt(key));
            ++n2;
        }
        return document;
    }

    private boolean matchComments(List<Comment> inputComments, List<Comment> outputComments, String inputString, String outputString) {
        IteratorQueue<Comment> inputIterator = new IteratorQueue<Comment>(inputComments.iterator());
        IteratorQueue<Comment> outputIterator = new IteratorQueue<Comment>(outputComments.iterator());
        while (inputIterator.hasNext() && outputIterator.hasNext()) {
            String nextOutputComment;
            String nextInputComment = this.getNextFlattenedComment(inputIterator, inputString);
            if (nextInputComment.equals(nextOutputComment = this.getNextFlattenedComment(outputIterator, outputString))) continue;
            if (FormatterPlugin.getDefault().isDebugging()) {
                IdeLog.logError((Plugin)PHPCodeFormatterPlugin.getDefault(), (String)("PHP Formatter error. The following comments content did not match after the formatting: \nINPUT:\n" + nextInputComment + "\nOUTPUT:\n" + nextOutputComment));
            }
            return false;
        }
        if (inputIterator.hasNext() || outputIterator.hasNext()) {
            if (FormatterPlugin.getDefault().isDebugging()) {
                IdeLog.logError((Plugin)PHPCodeFormatterPlugin.getDefault(), (String)"PHP Formatter error: The formatter changed the comments count in the document");
            }
            return false;
        }
        return true;
    }

    private String getNextFlattenedComment(IteratorQueue<Comment> comments, String source) {
        StringBuilder builder = new StringBuilder(256);
        boolean isSingleLine = false;
        if (comments.hasNext()) {
            isSingleLine = comments.peek().getCommentType() == 0;
        }
        while (comments.hasNext()) {
            Comment comment = comments.peek();
            String commentContent = source.substring(comment.getStart(), comment.getEnd());
            if (comment.getCommentType() == 0) {
                if (!isSingleLine) break;
                builder.append(SINGLE_LINE_FLATTEN_PATTERN.matcher(commentContent).replaceAll(""));
                if (!comments.hasNext()) continue;
                comments.poll();
                continue;
            }
            if (isSingleLine) break;
            builder.append(MULTI_LINE_FLATTEN_PATTERN.matcher(commentContent).replaceAll(""));
            if (!comments.hasNext()) break;
            comments.poll();
            break;
        }
        return builder.toString();
    }

    class IteratorQueue<E>
    extends AbstractQueue<E> {
        private Iterator<E> iterator;
        private E nextItem;

        public IteratorQueue(Iterator<E> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.nextItem != null || this.iterator.hasNext();
        }

        @Override
        public boolean offer(E o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E poll() {
            E next = this.nextItem != null ? this.nextItem : this.iterator.next();
            this.nextItem = null;
            return next;
        }

        @Override
        public E peek() {
            if (this.nextItem == null) {
                this.nextItem = this.iterator.next();
            }
            return this.nextItem;
        }

        @Override
        public Iterator<E> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }
}

