/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter.nodes;

import com.aptana.editor.php.formatter.nodes.FormatterPHPTextNode;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterPHPPunctuationNode
extends FormatterPHPTextNode {
    private NodeTypes.TypePunctuation nodeType;
    private boolean forceLineTermination;

    public FormatterPHPPunctuationNode(IFormatterDocument document, NodeTypes.TypePunctuation nodeType) {
        super(document, true);
        this.nodeType = nodeType;
    }

    public FormatterPHPPunctuationNode(IFormatterDocument document, NodeTypes.TypePunctuation nodeType, boolean forceLineTermination) {
        this(document, nodeType);
        this.forceLineTermination = forceLineTermination;
    }

    @Override
    public int getSpacesCountBefore() {
        switch (this.nodeType) {
            case CASE_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.after.case.colon");
            }
            case GOTO_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.before.colon");
            }
            case COMMA: 
            case ARRAY_COMMA: {
                return this.getDocument().getInt("php.formatter.spaces.before.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("php.formatter.spaces.before.semicolon");
            }
            case FOR_SEMICOLON: {
                return this.getDocument().getInt("php.formatter.spaces.before.forSemicolon");
            }
            case NAMESPACE_SEPARATOR: {
                return this.getDocument().getInt("php.formatter.spaces.before.namespaceSeparator");
            }
        }
        return super.getSpacesCountBefore();
    }

    @Override
    public int getSpacesCountAfter() {
        switch (this.nodeType) {
            case CASE_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.before.case.colon");
            }
            case GOTO_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.after.colon");
            }
            case COMMA: 
            case ARRAY_COMMA: {
                return this.getDocument().getInt("php.formatter.spaces.after.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("php.formatter.spaces.after.semicolon");
            }
            case FOR_SEMICOLON: {
                return this.getDocument().getInt("php.formatter.spaces.after.forSemicolon");
            }
            case NAMESPACE_SEPARATOR: {
                return this.getDocument().getInt("php.formatter.spaces.after.namespaceSeparator");
            }
        }
        return super.getSpacesCountAfter();
    }

    protected boolean isAddingEndNewLine() {
        return this.forceLineTermination || super.isAddingEndNewLine();
    }
}

