/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.dtd.core.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.dtd.core.parsing.DTDTokenType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.utils.StringPool;

public class DTDScanner
extends Scanner {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[2];
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0001\u0012\u0000\u0001\u0001\u0001\u0007\u0001\u0004\u0001\u0019\u0001\u0000\u0001+\u0001\u000b\u0001\u0005\u0001%\u0001'\u0001(\u0001)\u0001*\u0001\b\u0001\u0002\u0001\u0000\n\u0002\u0001\u0003\u0001\f\u0001\u0006\u0001\u0000\u0001\t\u0001\n\u0001\u0000\u0001\u000f\u0001$\u0001\u001e\u0001\u001c\u0001\u0014\u0001\u001a\u0001\"\u0001\u0003\u0001\u0012\u0001\u0003\u0001#\u0001\u0011\u0001\u0015\u0001\u0016\u0001\u0018\u0001\u001d\u0001 \u0001\u001f\u0001\u0013\u0001\u0010\u0001!\u0002\u0003\u0001\u001b\u0001\u0017\u0001\u0003\u0001\r\u0001,\u0001\u000e\u0001\u0000\u0001\u0003\u0001\u0000\u001a\u0003\u0001\u0000\u0001&\uff83\u0000";
    private static final char[] ZZ_CMAP = DTDScanner.zzUnpackCMap("\t\u0000\u0001\u0001\u0001\u0001\u0001\u0000\u0001\u0001\u0001\u0001\u0012\u0000\u0001\u0001\u0001\u0007\u0001\u0004\u0001\u0019\u0001\u0000\u0001+\u0001\u000b\u0001\u0005\u0001%\u0001'\u0001(\u0001)\u0001*\u0001\b\u0001\u0002\u0001\u0000\n\u0002\u0001\u0003\u0001\f\u0001\u0006\u0001\u0000\u0001\t\u0001\n\u0001\u0000\u0001\u000f\u0001$\u0001\u001e\u0001\u001c\u0001\u0014\u0001\u001a\u0001\"\u0001\u0003\u0001\u0012\u0001\u0003\u0001#\u0001\u0011\u0001\u0015\u0001\u0016\u0001\u0018\u0001\u001d\u0001 \u0001\u001f\u0001\u0013\u0001\u0010\u0001!\u0002\u0003\u0001\u001b\u0001\u0017\u0001\u0003\u0001\r\u0001,\u0001\u000e\u0001\u0000\u0001\u0003\u0001\u0000\u001a\u0003\u0001\u0000\u0001&\uff83\u0000");
    private static final int[] ZZ_ACTION = DTDScanner.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0001\u0001\u0001\u0002\u0001\u0003\u0001\u0004\u0003\u0001\u0001\u0005\u0001\u0006\u0001\u0001\u0001\u0007\u0001\u0001\u0005\u0004\u0001\u0001\u0002\u0004\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u0000\u0001\u000f\u0001\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0002\u0004\u0001\u0010\u0007\u0004\u0004\u0000\u0002\u0004\u0001\u0000\u0001\u0011\u0004\u0000\u0001\u0012\u0001\u0013\u0001\u0014\t\u0004\u0004\u0000\u0002\u0004\u0005\u0000\u0001\u0015\t\u0004\u0004\u0000\u0002\u0004\u0005\u0000\u0001\u0004\u0001\u0016\u0002\u0004\u0001\u0017\u0003\u0004\u0001\u0018\u0004\u0000\u0001\u0004\u0001\u0019\u0005\u0000\u0001\u0004\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0004\u0001\u001d\u0002\u0004\u0001\u0000\u0001\u001e\u0002\u0000\u0001\u001f\u0001 \u0004\u0000\u0001!\u0001\u0004\u0001\"\u0001\u0004\u0001\u0000\u0001#\u0003\u0000\u0001$\u0001\u0000\u0001%\u0001&\u0001'\u0001(\u0001\u0000\u0001)\u0001*\u0001\u0000\u0001+\u0001,";
    private static final int[] ZZ_ROWMAP = DTDScanner.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000-\u0000Z\u0000\u0087\u0000\u00b4\u0000\u00e1\u0000\u010e\u0000\u013b\u0000-\u0000-\u0000\u0168\u0000-\u0000\u0195\u0000\u01c2\u0000\u01ef\u0000\u021c\u0000\u0249\u0000\u0276\u0000\u02a3\u0000\u02d0\u0000\u02fd\u0000-\u0000-\u0000-\u0000-\u0000-\u0000-\u0000\u0168\u0000\u032a\u0000-\u0000\u032a\u0000\u0357\u0000\u0357\u0000\u0384\u0000\u03b1\u0000\u03de\u0000\u040b\u0000\u0438\u0000\u0465\u0000\u0492\u0000\u04bf\u0000\u04ec\u0000\u0519\u0000\u0546\u0000\u0573\u0000\u05a0\u0000\u05cd\u0000\u05fa\u0000\u0627\u0000\u0654\u0000\u0681\u0000\u06ae\u0000\u06db\u0000\u0708\u0000-\u0000\u0735\u0000\u0762\u0000\u078f\u0000\u07bc\u0000-\u0000-\u0000\u00b4\u0000\u07e9\u0000\u0816\u0000\u0843\u0000\u0870\u0000\u089d\u0000\u08ca\u0000\u08f7\u0000\u0924\u0000\u0951\u0000\u097e\u0000\u09ab\u0000\u09d8\u0000\u0a05\u0000\u0a32\u0000\u0a5f\u0000\u0a8c\u0000\u0ab9\u0000\u0ae6\u0000\u0b13\u0000\u0b40\u0000-\u0000\u0b6d\u0000\u0b9a\u0000\u0bc7\u0000\u0bf4\u0000\u0c21\u0000\u0c4e\u0000\u0c7b\u0000\u0ca8\u0000\u0cd5\u0000\u0d02\u0000\u0d2f\u0000\u0d5c\u0000\u0d89\u0000\u0db6\u0000\u0de3\u0000\u0e10\u0000\u0e3d\u0000\u0e6a\u0000\u0e97\u0000\u0ec4\u0000\u0ef1\u0000\u0f1e\u0000\u0f4b\u0000\u0f78\u0000\u00b4\u0000\u0fa5\u0000\u0fd2\u0000\u0fff\u0000\u00b4\u0000\u102c\u0000\u1059\u0000\u1086\u0000\u10b3\u0000\u10e0\u0000\u00b4\u0000\u110d\u0000\u113a\u0000\u1167\u0000\u1194\u0000\u11c1\u0000\u11ee\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000\u121b\u0000\u00b4\u0000\u1248\u0000\u1275\u0000\u12a2\u0000-\u0000\u12cf\u0000\u12fc\u0000\u00b4\u0000-\u0000\u1329\u0000\u1356\u0000\u1383\u0000\u13b0\u0000\u00b4\u0000\u13dd\u0000\u140a\u0000\u1437\u0000\u1464\u0000-\u0000\u1491\u0000\u14be\u0000\u14eb\u0000-\u0000\u1518\u0000\u00b4\u0000\u00b4\u0000\u00b4\u0000-\u0000\u1545\u0000-\u0000-\u0000\u1572\u0000-\u0000-";
    private static final int[] ZZ_TRANS = DTDScanner.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\u0002\u0001\u0004\u0001\t\u0001\n\u0001\u000b\u0001\u0002\u0001\f\u0001\r\u0001\u000e\u0002\u0005\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0005\u0001\u0012\u0002\u0005\u0001\u0013\u0003\u0005\u0001\u0014\u0001\u0015\u0006\u0005\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u0002.\u0000\u0001\u0003-\u0000\u0002\u0004\u0004\u0000\u0001\u0004\u0006\u0000\n\u0004\u0001\u0000\u000b\u0004\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u000b\u0005\b\u0000\u0004\u001d\u0001\u001e'\u001d\u0001\u001f\u0005 \u0001\u001e& \u0001!\u0007\u0000\u0001\"\u0002\u0000\u0001#%\u0000\u0001$\u000b\u0000\n$\u0001\u0000\u000b$\u0016\u0000\u0001% \u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0007\u0005\u0001&\u0002\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0007\u0005\u0001'\u0002\u0005\u0001\u0000\u0002\u0005\u0001(\u0005\u0005\u0001)\u0002\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\b\u0005\u0001*\u0001\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0006\u0005\u0001+\u0001,\u0002\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0006\u0005\u0001-\u0002\u0005\u0001.\u0001\u0000\u0002\u0005\u0001/\b\u0005\u001a\u0000\u00010\u0007\u0000\u00011\u0002\u0000\u00012\u0001\u0000\u00013\u000f\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0007\u0005\u00014\u0003\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0002\u0005\u00015\b\u0005\b\u0000\u0004\u001d\u0001\u001e(\u001d\u0005 \u0001\u001e' \b\u0000\u00016\u0004\u0000\u00017\u0001\u0000\u00018\u0004\u0000\u00019\u0001\u0000\u0001:\u0016\u0000\n#\u0001;\"#\u0002\u0000\u0002$\u0004\u0000\u0001$\u0003\u0000\u0001<\u0002\u0000\n$\u0001\u0000\u000b$\u0011\u0000\u0001=%\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\b\u0005\u0001>\u0001\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0004\u0005\u0001?\u0006\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0005\u0005\u0001@\u0005\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0007\u0005\u0001A\u0002\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0004\u0005\u0001B\u0005\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0003\u0005\u0001C\u0007\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001D\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001E\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001F\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001G\t\u0005\u0001\u0000\u000b\u0005\u001d\u0000\u0001H)\u0000\u0001I8\u0000\u0001J\"\u0000\u0001K\u001a\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\n\u0005\u0001L\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001M\t\u0005\u0001\u0000\u000b\u0005\u0010\u0000\u0001N4\u0000\u0001O-\u0000\u0001P\u0004\u0000\u0001Q.\u0000\u0001R\u0014\u0000\t#\u0001S\u0001;\"#\u0002\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0002\u0005\u0001T\u0007\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001U\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\t\u0005\u0001V\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001W\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001X\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0003\u0005\u0001Y\u0006\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\t\u0005\u0001Z\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001[\t\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001\\\b\u0005\u0001\u0000\u000b\u0005%\u0000\u0001]*\u0000\u0001^-\u0000\u0001_0\u0000\u0001`\u000e\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0002\u0005\u0001a\u0007\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001b\b\u0005\u0001\u0000\u000b\u0005\b\u0000\bN\u0001c$N\u0010\u0000\u0001d0\u0000\u0001e(\u0000\u0001f,\u0000\u0001g\u001e\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0007\u0005\u0001h\u0003\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0001i\n\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0005\u0005\u0001j\u0005\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001k\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\b\u0005\u0001l\u0001\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001m\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\t\u0005\u0001n\u0001\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001\u0005\u0001o\b\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001p\t\u0005\u0001\u0000\u000b\u0005\u0019\u0000\u0001q/\u0000\u0001r'\u0000\u0001s>\u0000\u0001t\r\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0003\u0005\u0001u\u0006\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0001v\t\u0005\u0001\u0000\u000b\u0005\b\u0000\bN\u0001w$N\u0011\u0000\u0001x0\u0000\u0001y)\u0000\u0001z)\u0000\u0001{\u001f\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0002\u0005\u0001|\b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0004\u0005\u0001}\u0005\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001~\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0006\u0005\u0001\u007f\u0003\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0003\u0005\u0001\u0080\u0004\u0005\u0001\u0081\u0001\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001\u0082\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0003\u0005\u0001\u0083\u0006\u0005\u0001\u0000\u000b\u0005\u001a\u0000\u0001\u00846\u0000\u0001\u0085 \u0000\u0001\u0086.\u0000\u0001\u0087\u001c\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\n\u0005\u0001\u0000\u0004\u0005\u0001\u0088\u0006\u0005\b\u0000\bN\u0001w\u0001\u0089#N\u0012\u0000\u0001\u008a.\u0000\u0001\u008b(\u0000\u0001\u008c,\u0000\u0001\u008d\u001e\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001\u008e\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0005\u0005\u0001\u008f\u0004\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0007\u0005\u0001\u0090\u0002\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\t\u0005\u0001\u0091\u0001\u0000\u000b\u0005\u001c\u0000\u0001\u0092'\u0000\u0001\u0093<\u0000\u0001\u0094 \u0000\u0001\u0095/\u0000\u0001\u0096-\u0000\u0001\u0097'\u0000\u0001\u0098\u001c\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0004\u0005\u0001\u0099\u0005\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0004\u0005\u0001\u009a\u0005\u0005\u0001\u0000\u000b\u0005\n\u0000\u0002\u0005\u0004\u0000\u0001\u0005\u0006\u0000\u0007\u0005\u0001\u009b\u0002\u0005\u0001\u0000\u000b\u0005$\u0000\u0001\u009c$\u0000\u0001\u009d(\u0000\u0001\u009e,\u0000\u0001\u009f4\u0000\u0001\u00a00\u0000\u0001\u00a1&\u0000\u0001\u00a2\u0016\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = DTDScanner.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\u0001\t\u0006\u0001\u0002\t\u0001\u0001\u0001\t\t\u0001\u0006\t\u0001\u0001\u0001\u0000\u0001\t\u0001\u0001\u0001\u0000\u0001\u0001\u0004\u0000\n\u0001\u0004\u0000\u0002\u0001\u0001\u0000\u0001\t\u0004\u0000\u0002\t\n\u0001\u0004\u0000\u0002\u0001\u0005\u0000\u0001\t\t\u0001\u0004\u0000\u0002\u0001\u0005\u0000\t\u0001\u0004\u0000\u0002\u0001\u0005\u0000\b\u0001\u0001\u0000\u0001\t\u0002\u0000\u0001\u0001\u0001\t\u0004\u0000\u0004\u0001\u0001\u0000\u0001\t\u0003\u0000\u0001\t\u0001\u0000\u0003\u0001\u0001\t\u0001\u0000\u0002\t\u0001\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private Symbol _lastToken;
    private List<Symbol> tokenQueue = new ArrayList<Symbol>();
    private static final Pattern ENTITY = Pattern.compile("%([^; \\t\\n]+);");
    private Map<String, String> _entities;
    private StringPool _stringPool;

    private static int[] zzUnpackAction() {
        int[] result = new int[162];
        int offset = 0;
        offset = DTDScanner.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[162];
        int offset = 0;
        offset = DTDScanner.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[5535];
        int offset = 0;
        offset = DTDScanner.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[162];
        int offset = 0;
        offset = DTDScanner.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public DTDScanner() {
        this((Reader)null);
    }

    public Symbol getLastToken() {
        return this._lastToken;
    }

    private Symbol newToken(DTDTokenType type, Object value) {
        return this.newToken(type.getIndex(), value);
    }

    private Symbol newToken(DTDTokenType type) {
        return this.newToken(type.getIndex(), null);
    }

    private String pool(String value) {
        return this._stringPool.add(value);
    }

    private Symbol newToken(short id, Object value) {
        return new Symbol(id, this.yychar, this.yychar + this.yylength() - 1, value);
    }

    public Symbol nextToken() throws IOException, Scanner.Exception {
        if (!this.tokenQueue.isEmpty()) {
            return this.tokenQueue.remove(0);
        }
        try {
            this._lastToken = this.yylex();
        }
        catch (Scanner.Exception e) {
            String text = this.yytext();
            int end = this.yychar + text.length() - 1;
            this._lastToken = new Symbol(DTDTokenType.EOF.getIndex(), this.yychar, end, (Object)text);
        }
        return this._lastToken;
    }

    public void setSource(String source) {
        this.yyreset(new StringReader(source));
        this._stringPool = new StringPool();
        this._lastToken = null;
    }

    String getValue(String key) {
        String result = null;
        if (this._entities != null) {
            result = this._entities.get(key);
        }
        return result;
    }

    void register(String key, String value) {
        if (this._entities == null) {
            this._entities = new HashMap<String, String>();
        }
        if (!this._entities.containsKey(key)) {
            this._entities.put(key, value);
        }
    }

    Symbol registered(String peRef) throws IOException, Scanner.Exception {
        Symbol s;
        String key = peRef.substring(1, peRef.length() - 1);
        String text = this.getValue(key);
        if (text == null) {
            return this.newToken((short)13, (Object)peRef);
        }
        DTDScanner nested = new DTDScanner();
        nested.setSource(text);
        nested._entities = this._entities;
        while ((s = nested.nextToken()).getId() != 0) {
            s = new Symbol(s.getId(), s.getStart() + this.yychar, s.getEnd() + this.yychar, s.value);
            this.tokenQueue.add(s);
        }
        return this.tokenQueue.remove(0);
    }

    Symbol handleString(String text) {
        StringBuffer buffer = new StringBuffer();
        Matcher m = ENTITY.matcher(text);
        while (m.find()) {
            String name = m.group(1);
            String newText = this.getValue(name);
            if (newText == null) {
                newText = name;
            }
            m.appendReplacement(buffer, newText);
        }
        m.appendTail(buffer);
        return this.newToken((short)4, (Object)this.pool(buffer.toString()));
    }

    public DTDScanner(Reader in) {
        this.zzReader = in;
    }

    public DTDScanner(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 132) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Symbol yylex() throws IOException, Scanner.Exception {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block89: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 2: 
                case 45: {
                    continue block89;
                }
                case 36: {
                    return this.newToken(DTDTokenType.ENTITY);
                }
                case 46: {
                    continue block89;
                }
                case 7: {
                    return this.newToken(DTDTokenType.LBRACKET);
                }
                case 47: {
                    continue block89;
                }
                case 17: {
                    return this.newToken(DTDTokenType.SECTION_START);
                }
                case 48: {
                    continue block89;
                }
                case 9: {
                    return this.newToken(DTDTokenType.PIPE);
                }
                case 49: {
                    continue block89;
                }
                case 20: {
                    return this.newToken(DTDTokenType.ANY, (Object)this.pool("ANY"));
                }
                case 50: {
                    continue block89;
                }
                case 41: {
                    return this.newToken(DTDTokenType.ATTLIST);
                }
                case 51: {
                    continue block89;
                }
                case 16: {
                    return this.newToken(DTDTokenType.ID_TYPE, (Object)this.pool("ID"));
                }
                case 52: {
                    continue block89;
                }
                case 18: {
                    return this.registered(this.yytext());
                }
                case 53: {
                    continue block89;
                }
                case 4: {
                    return this.newToken(DTDTokenType.NAME, (Object)this.pool(this.yytext()));
                }
                case 54: {
                    continue block89;
                }
                case 40: {
                    return this.newToken(DTDTokenType.IMPLIED, (Object)this.pool("#IMPLIED"));
                }
                case 55: {
                    continue block89;
                }
                case 43: {
                    return this.newToken(DTDTokenType.REQUIRED, (Object)this.pool("#REQUIRED"));
                }
                case 56: {
                    continue block89;
                }
                case 33: {
                    return this.newToken(DTDTokenType.INCLUDE, (Object)this.pool("INCLUDE"));
                }
                case 57: {
                    continue block89;
                }
                case 44: {
                    return this.newToken(DTDTokenType.NOTATION);
                }
                case 58: {
                    continue block89;
                }
                case 6: {
                    return this.newToken(DTDTokenType.QUESTION);
                }
                case 59: {
                    continue block89;
                }
                case 24: {
                    return this.newToken(DTDTokenType.NDATA, (Object)this.pool("NDATA"));
                }
                case 60: {
                    continue block89;
                }
                case 8: {
                    return this.newToken(DTDTokenType.LPAREN);
                }
                case 61: {
                    continue block89;
                }
                case 3: {
                    return this.newToken(DTDTokenType.NMTOKEN, (Object)this.pool(this.yytext()));
                }
                case 62: {
                    continue block89;
                }
                case 39: {
                    return this.newToken(DTDTokenType.NOTATION_TYPE, (Object)this.pool("NOTATION"));
                }
                case 63: {
                    continue block89;
                }
                case 15: {
                    return this.handleString(this.yytext());
                }
                case 64: {
                    continue block89;
                }
                case 25: {
                    return this.newToken(DTDTokenType.CDATA_TYPE, (Object)this.pool("CDATA"));
                }
                case 65: {
                    continue block89;
                }
                case 31: {
                    return this.newToken(DTDTokenType.PUBLIC, (Object)this.pool("PUBLIC"));
                }
                case 66: {
                    continue block89;
                }
                case 29: {
                    return this.newToken(DTDTokenType.ENTITY_TYPE, (Object)this.pool("ENTITY"));
                }
                case 67: {
                    continue block89;
                }
                case 5: {
                    return this.newToken(DTDTokenType.GREATER_THAN);
                }
                case 68: {
                    continue block89;
                }
                case 26: {
                    return this.newToken(DTDTokenType.IDREFS_TYPE, (Object)this.pool("IDREFS"));
                }
                case 69: {
                    continue block89;
                }
                case 21: {
                    return this.newToken((short)14, (Object)this.pool(this.yytext()));
                }
                case 70: {
                    continue block89;
                }
                case 35: {
                    return this.newToken(DTDTokenType.PCDATA, (Object)this.pool("#PCDATA"));
                }
                case 71: {
                    continue block89;
                }
                case 34: {
                    return this.newToken(DTDTokenType.NMTOKEN_TYPE, (Object)this.pool("NMTOKEN"));
                }
                case 72: {
                    continue block89;
                }
                case 22: {
                    return this.newToken(DTDTokenType.IDREF_TYPE, (Object)this.pool("IDREF"));
                }
                case 73: {
                    continue block89;
                }
                case 38: {
                    return this.newToken(DTDTokenType.NMTOKENS_TYPE, (Object)this.pool("NMTOKENS"));
                }
                case 74: {
                    continue block89;
                }
                case 1: {
                    this.yybegin(0);
                    throw new Scanner.Exception("Unexpected character '" + this.yytext() + "' around offset " + this.yychar);
                }
                case 75: {
                    continue block89;
                }
                case 12: {
                    return this.newToken(DTDTokenType.PLUS);
                }
                case 76: {
                    continue block89;
                }
                case 42: {
                    return this.newToken(DTDTokenType.ELEMENT);
                }
                case 77: {
                    continue block89;
                }
                case 14: {
                    return this.newToken(DTDTokenType.PERCENT);
                }
                case 78: {
                    continue block89;
                }
                case 13: {
                    return this.newToken(DTDTokenType.COMMA);
                }
                case 79: {
                    continue block89;
                }
                case 28: {
                    return this.newToken(DTDTokenType.SYSTEM, (Object)this.pool("SYSTEM"));
                }
                case 80: {
                    continue block89;
                }
                case 37: {
                    return this.newToken(DTDTokenType.ENTITIES_TYPE, (Object)this.pool("ENTITIES"));
                }
                case 81: {
                    continue block89;
                }
                case 32: {
                    return this.newToken((short)15, (Object)this.pool(this.yytext()));
                }
                case 82: {
                    continue block89;
                }
                case 27: {
                    return this.newToken(DTDTokenType.IGNORE, (Object)this.pool("IGNORE"));
                }
                case 83: {
                    continue block89;
                }
                case 10: {
                    return this.newToken(DTDTokenType.RPAREN);
                }
                case 84: {
                    continue block89;
                }
                case 30: {
                    return this.newToken(DTDTokenType.FIXED, (Object)this.pool("#FIXED"));
                }
                case 85: {
                    continue block89;
                }
                case 23: {
                    return this.newToken(DTDTokenType.EMPTY, (Object)this.pool("EMPTY"));
                }
                case 86: {
                    continue block89;
                }
                case 11: {
                    return this.newToken(DTDTokenType.STAR);
                }
                case 87: {
                    continue block89;
                }
                case 19: {
                    return this.newToken(DTDTokenType.SECTION_END);
                }
                case 88: {
                    continue block89;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return this.newToken((short)0, (Object)"end-of-file");
            }
            this.zzScanError(1);
        }
    }
}

