/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.internal.ui.PHPPluginImages;
import com.aptana.editor.php.internal.ui.editor.IScriptAnnotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org2.eclipse.dltk.compiler.problem.CategorizedProblem;
import org2.eclipse.dltk.compiler.problem.IProblem;

public class ProblemAnnotation
extends Annotation
implements IScriptAnnotation,
IAnnotationPresentation,
IQuickFixableAnnotation {
    public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
    private static final int TASK_LAYER;
    private static final int INFO_LAYER;
    private static final int WARNING_LAYER;
    private static final int ERROR_LAYER;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static Image fgTaskImage;
    private static Image fgInfoImage;
    private static Image fgWarningImage;
    private static Image fgErrorImage;
    private static boolean fgImagesInitialized;
    private final ISourceModule fSourceModule;
    private List<IScriptAnnotation> fOverlaids;
    private final IProblem fProblem;
    private Image fImage;
    private boolean fImageInitialized = false;
    private int fLayer = 0;
    private boolean fIsQuickFixable;
    private boolean fIsQuickFixableStateSet = false;

    static {
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", lookup);
        INFO_LAYER = ProblemAnnotation.computeLayer("com.aptana.editor.php.epl.info", lookup);
        WARNING_LAYER = ProblemAnnotation.computeLayer("com.aptana.editor.php.epl.warning", lookup);
        ERROR_LAYER = ProblemAnnotation.computeLayer("com.aptana.editor.php.epl.error", lookup);
        fgImagesInitialized = false;
    }

    private static int computeLayer(String annotationType, AnnotationPreferenceLookup lookup) {
        Annotation annotation = new Annotation(annotationType, false, null);
        AnnotationPreference preference = lookup.getAnnotationPreference(annotation);
        if (preference != null) {
            return preference.getPresentationLayer() + 1;
        }
        return 1;
    }

    public ProblemAnnotation(IProblem problem, ISourceModule cu) {
        this.fProblem = problem;
        this.fSourceModule = cu;
        if (536871362 == this.fProblem.getID()) {
            this.setType("org.eclipse.ui.workbench.texteditor.task");
            this.fLayer = TASK_LAYER;
        } else if (this.fProblem.isWarning()) {
            this.setType("com.aptana.editor.php.epl.warning");
            this.fLayer = WARNING_LAYER;
        } else if (this.fProblem.isError()) {
            this.setType("com.aptana.editor.php.epl.error");
            this.fLayer = ERROR_LAYER;
        } else {
            this.setType("com.aptana.editor.php.epl.info");
            this.fLayer = INFO_LAYER;
        }
    }

    public int getLayer() {
        return this.fLayer;
    }

    private void initializeImage() {
        if (!this.fImageInitialized) {
            ProblemAnnotation.initializeImages();
            if (this.isQuickFixable()) {
                this.fImage = "com.aptana.editor.php.epl.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
            } else {
                String type = this.getType();
                if ("org.eclipse.ui.workbench.texteditor.task".equals(type)) {
                    this.fImage = fgTaskImage;
                } else if ("com.aptana.editor.php.epl.info".equals(type)) {
                    this.fImage = fgInfoImage;
                } else if ("com.aptana.editor.php.epl.warning".equals(type)) {
                    this.fImage = fgWarningImage;
                } else if ("com.aptana.editor.php.epl.error".equals(type)) {
                    this.fImage = fgErrorImage;
                }
            }
            this.fImageInitialized = true;
        }
    }

    private static void initializeImages() {
        if (fgImagesInitialized) {
            return;
        }
        fgQuickFixImage = PHPPluginImages.get("com.aptana.editor.php.epl.quickfix_warning_obj.gif");
        fgQuickFixErrorImage = PHPPluginImages.get("com.aptana.editor.php.epl.quickfix_error_obj.gif");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        fgTaskImage = sharedImages.getImage("IMG_OBJS_TASK_TSK");
        fgInfoImage = sharedImages.getImage("IMG_OBJS_INFO_TSK");
        fgWarningImage = sharedImages.getImage("IMG_OBJS_WARN_TSK");
        fgErrorImage = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
        fgImagesInitialized = true;
    }

    public void paint(GC gc, Canvas canvas, Rectangle r) {
        this.initializeImage();
        if (this.fImage != null) {
            ImageUtilities.drawImage((Image)this.fImage, (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }

    public Image getImage(Display display) {
        this.initializeImage();
        return this.fImage;
    }

    @Override
    public String getText() {
        String[] arguments = this.getArguments();
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String ar = arguments[i];
                if (ar.startsWith("description:")) {
                    return String.valueOf(this.fProblem.getMessage()) + '\n' + ar.substring("description:".length());
                }
                ++i;
            }
        }
        return this.fProblem.getMessage();
    }

    @Override
    public String[] getArguments() {
        return this.isProblem() ? this.fProblem.getArguments() : null;
    }

    @Override
    public int getId() {
        return this.fProblem.getID();
    }

    @Override
    public boolean isProblem() {
        String type = this.getType();
        return "com.aptana.editor.php.epl.warning".equals(type) || "com.aptana.editor.php.epl.error".equals(type) || SPELLING_ANNOTATION_TYPE.equals(type);
    }

    @Override
    public boolean hasOverlay() {
        return false;
    }

    @Override
    public IScriptAnnotation getOverlay() {
        return null;
    }

    @Override
    public void addOverlaid(IScriptAnnotation annotation) {
        if (this.fOverlaids == null) {
            this.fOverlaids = new ArrayList<IScriptAnnotation>(1);
        }
        this.fOverlaids.add(annotation);
    }

    @Override
    public void removeOverlaid(IScriptAnnotation annotation) {
        if (this.fOverlaids != null) {
            this.fOverlaids.remove(annotation);
            if (this.fOverlaids.size() == 0) {
                this.fOverlaids = null;
            }
        }
    }

    @Override
    public Iterator getOverlaidIterator() {
        if (this.fOverlaids != null) {
            return this.fOverlaids.iterator();
        }
        return null;
    }

    public ISourceModule getSourceModule() {
        return this.fSourceModule;
    }

    public IProblem getProblem() {
        return this.fProblem;
    }

    @Override
    public String getMarkerType() {
        if (this.fProblem instanceof CategorizedProblem) {
            return ((CategorizedProblem)this.fProblem).getMarkerType();
        }
        return null;
    }

    public void setQuickFixable(boolean state) {
        this.fIsQuickFixable = state;
        this.fIsQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.fIsQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        Assert.isTrue((boolean)this.isQuickFixableStateSet());
        return this.fIsQuickFixable;
    }
}

