/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor;

import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.internal.ui.editor.ProblemAnnotation;
import com.aptana.editor.php.internal.ui.editor.ScriptMarkerAnnotation;
import com.aptana.editor.php.internal.ui.editor.SourceModuleAnnotationModelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org2.eclipse.dltk.compiler.problem.IProblem;

public class SourceModuleAnnotationModel
extends ResourceMarkerAnnotationModel {
    private ThreadLocal<ProblemRequestorState> fProblemRequestorState = new ThreadLocal();
    private int fStateCount = 0;
    private ISourceModule fSourceModule;
    private List<ProblemAnnotation> fGeneratedAnnotations = new ArrayList<ProblemAnnotation>();
    private IProgressMonitor fProgressMonitor;
    private boolean fIsActive = false;
    private boolean fIsHandlingTemporaryProblems;
    private ReverseMap fReverseMap = new ReverseMap();
    private List<ScriptMarkerAnnotation> fPreviouslyOverlaid = null;
    private List<ScriptMarkerAnnotation> fCurrentlyOverlaid = new ArrayList<ScriptMarkerAnnotation>();

    public SourceModuleAnnotationModel(IResource resource) {
        super(resource);
    }

    public void setSourceModule(ISourceModule unit) {
        this.fSourceModule = unit;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        String markerType = MarkerUtilities.getMarkerType((IMarker)marker);
        if (markerType != null && markerType.startsWith("com.aptana.editor.php.epl")) {
            return new ScriptMarkerAnnotation(marker);
        }
        return super.createMarkerAnnotation(marker);
    }

    protected AnnotationModelEvent createAnnotationModelEvent() {
        return new SourceModuleAnnotationModelEvent((IAnnotationModel)this, this.getResource());
    }

    protected Position createPositionFromProblem(IProblem problem) {
        int start = problem.getSourceStart();
        if (start < 0) {
            return null;
        }
        int end = problem.getSourceEnd();
        if (end == 0 && start == 0) {
            return new Position(0, 0);
        }
        int length = end - start;
        if (length < 0) {
            return null;
        }
        return new Position(start, length);
    }

    public void beginReporting() {
        ProblemRequestorState state = this.fProblemRequestorState.get();
        if (state == null) {
            this.internalBeginReporting(false);
        }
    }

    public void beginReportingSequence() {
        ProblemRequestorState state = this.fProblemRequestorState.get();
        if (state == null) {
            this.internalBeginReporting(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalBeginReporting(boolean insideReportingSequence) {
        if (this.fSourceModule != null) {
            ProblemRequestorState state = new ProblemRequestorState();
            state.fInsideReportingSequence = insideReportingSequence;
            state.fReportedProblems = new ArrayList<IProblem>();
            Object object = this.getLockObject();
            synchronized (object) {
                this.fProblemRequestorState.set(state);
                ++this.fStateCount;
            }
        }
    }

    public void acceptProblem(IProblem problem) {
        ProblemRequestorState state;
        if (this.fIsHandlingTemporaryProblems && (state = this.fProblemRequestorState.get()) != null) {
            state.fReportedProblems.add(problem);
        }
    }

    public void endReporting() {
        ProblemRequestorState state = this.fProblemRequestorState.get();
        if (state != null && !state.fInsideReportingSequence) {
            this.internalEndReporting(state);
        }
    }

    public void endReportingSequence() {
        ProblemRequestorState state = this.fProblemRequestorState.get();
        if (state != null && state.fInsideReportingSequence) {
            this.internalEndReporting(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalEndReporting(ProblemRequestorState state) {
        int stateCount = 0;
        Object object = this.getLockObject();
        synchronized (object) {
            --this.fStateCount;
            stateCount = this.fStateCount;
            this.fProblemRequestorState.set(null);
        }
        if (stateCount == 0) {
            this.reportProblems(state.fReportedProblems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportProblems(List<IProblem> reportedProblems) {
        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            return;
        }
        boolean temporaryProblemsChanged = false;
        Object object = this.getLockObject();
        synchronized (object) {
            boolean isCanceled = false;
            this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
            this.fCurrentlyOverlaid = new ArrayList<ScriptMarkerAnnotation>();
            if (this.fGeneratedAnnotations.size() > 0) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (reportedProblems != null && reportedProblems.size() > 0) {
                Iterator<IProblem> e = reportedProblems.iterator();
                while (e.hasNext()) {
                    if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                        isCanceled = true;
                        break;
                    }
                    IProblem problem = e.next();
                    Position position = this.createPositionFromProblem(problem);
                    if (position == null) continue;
                    try {
                        ProblemAnnotation annotation = new ProblemAnnotation(problem, this.fSourceModule);
                        this.overlayMarkers(position, annotation);
                        this.addAnnotation(annotation, position, false);
                        this.fGeneratedAnnotations.add(annotation);
                        temporaryProblemsChanged = true;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            this.removeMarkerOverlays(isCanceled);
            this.fPreviouslyOverlaid = null;
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged();
        }
    }

    private void removeMarkerOverlays(boolean isCanceled) {
        if (isCanceled) {
            this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
        } else if (this.fPreviouslyOverlaid != null) {
            for (ScriptMarkerAnnotation annotation : this.fPreviouslyOverlaid) {
                annotation.setOverlay(null);
            }
        }
    }

    private void setOverlay(Object value, ProblemAnnotation problemAnnotation) {
        ScriptMarkerAnnotation annotation;
        if (value instanceof ScriptMarkerAnnotation && (annotation = (ScriptMarkerAnnotation)value).isProblem()) {
            annotation.setOverlay(problemAnnotation);
            this.fPreviouslyOverlaid.remove(annotation);
            this.fCurrentlyOverlaid.add(annotation);
        }
    }

    private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
        Object value = this.getAnnotations(position);
        if (value instanceof List) {
            List list = (List)value;
            Iterator e = list.iterator();
            while (e.hasNext()) {
                this.setOverlay(e.next(), problemAnnotation);
            }
        } else {
            this.setOverlay(value, problemAnnotation);
        }
    }

    private void startCollectingProblems() {
        this.fGeneratedAnnotations.clear();
    }

    private void stopCollectingProblems() {
        if (this.fGeneratedAnnotations != null) {
            this.removeAnnotations(this.fGeneratedAnnotations, true, true);
        }
        this.fGeneratedAnnotations.clear();
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void setIsActive(boolean isActive) {
        this.fIsActive = isActive;
    }

    public void setIsHandlingTemporaryProblems(boolean enable) {
        if (this.fIsHandlingTemporaryProblems != enable) {
            this.fIsHandlingTemporaryProblems = enable;
            if (this.fIsHandlingTemporaryProblems) {
                this.startCollectingProblems();
            } else {
                this.stopCollectingProblems();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAnnotations(Position position) {
        Object object = this.getLockObject();
        synchronized (object) {
            return this.fReverseMap.get(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAnnotation(Annotation annotation, Position position, boolean fireModelChanged) throws BadLocationException {
        super.addAnnotation(annotation, position, fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached == null) {
                this.fReverseMap.put(position, annotation);
            } else if (cached instanceof List) {
                List list = (List)cached;
                list.add(annotation);
            } else if (cached instanceof Annotation) {
                ArrayList<Annotation> list = new ArrayList<Annotation>(2);
                list.add((Annotation)cached);
                list.add(annotation);
                this.fReverseMap.put(position, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllAnnotations(boolean fireModelChanged) {
        super.removeAllAnnotations(fireModelChanged);
        Object object = this.getLockObject();
        synchronized (object) {
            this.fReverseMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotation(Annotation annotation, boolean fireModelChanged) {
        Position position = this.getPosition(annotation);
        Object object = this.getLockObject();
        synchronized (object) {
            Object cached = this.fReverseMap.get(position);
            if (cached instanceof List) {
                List list = (List)cached;
                list.remove(annotation);
                if (list.size() == 1) {
                    this.fReverseMap.put(position, list.get(0));
                    list.clear();
                }
            } else if (cached instanceof Annotation) {
                this.fReverseMap.remove(position);
            }
        }
        super.removeAnnotation(annotation, fireModelChanged);
    }

    private static class ProblemRequestorState {
        boolean fInsideReportingSequence = false;
        List<IProblem> fReportedProblems;

        private ProblemRequestorState() {
        }
    }

    protected static class ReverseMap {
        private List<Entry> fList = new ArrayList<Entry>(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int length = this.fList.size();
            int i = this.fAnchor;
            while (i < length) {
                entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            i = 0;
            while (i < this.fAnchor) {
                entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = i;
                    return entry.fValue;
                }
                ++i;
            }
            return null;
        }

        private int getIndex(Position position) {
            int length = this.fList.size();
            int i = 0;
            while (i < length) {
                Entry entry = this.fList.get(i);
                if (entry.fPosition.equals((Object)position)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public void put(Position position, Object value) {
            int index = this.getIndex(position);
            if (index == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = value;
                this.fList.add(entry);
            } else {
                Entry entry = this.fList.get(index);
                entry.fValue = value;
            }
        }

        public void remove(Position position) {
            int index = this.getIndex(position);
            if (index > -1) {
                this.fList.remove(index);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }
}

