/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.core.compiler;

import org2.eclipse.php.core.compiler.IPHPModifiers;

public class PHPFlags
implements IPHPModifiers {
    public static boolean isDefault(int flags) {
        return !PHPFlags.isPrivate(flags) && !PHPFlags.isProtected(flags) && !PHPFlags.isPublic(flags);
    }

    public static boolean isNamespace(int flags) {
        return (flags & 0x800) != 0;
    }

    public static boolean isConstant(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isNamedConstant(int flags) {
        return (flags & 0x16) != 0;
    }

    public static boolean isClass(int flags) {
        return !PHPFlags.isNamespace(flags) && !PHPFlags.isInterface(flags);
    }

    public static boolean isPrivate(int flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean isProtected(int flags) {
        return (flags & 0x20) != 0;
    }

    public static boolean isPublic(int flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean isStatic(int flags) {
        return (flags & 0x80) != 0;
    }

    public static boolean isFinal(int flags) {
        return (flags & 4) != 0;
    }

    public static boolean isAbstract(int flags) {
        return (flags & 1) != 0;
    }

    public static boolean isInterface(int flags) {
        return (flags & 8) != 0;
    }

    public static boolean isSynthetic(int flags) {
        return (flags & 0x20000) != 0;
    }

    public static String toString(int mod) {
        int len;
        StringBuffer sb = new StringBuffer();
        if ((mod & 0x40) != 0) {
            sb.append("public ");
        }
        if ((mod & 0x20) != 0) {
            sb.append("protected ");
        }
        if ((mod & 0x10) != 0) {
            sb.append("private ");
        }
        if ((mod & 1) != 0) {
            sb.append("abstract ");
        }
        if ((mod & 0x80) != 0) {
            sb.append("static ");
        }
        if ((mod & 4) != 0) {
            sb.append("final ");
        }
        if ((len = sb.length()) > 0) {
            return sb.toString().substring(0, len - 1);
        }
        return "";
    }
}

