/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.ast.match.ASTMatcher;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.ClassName;
import org2.eclipse.php.internal.core.ast.nodes.Expression;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.visitor.Visitor;

public class InstanceOfExpression
extends Expression {
    private Expression expression;
    private ClassName className;
    public static final ChildPropertyDescriptor EXPRESSION_PROPERTY = new ChildPropertyDescriptor(InstanceOfExpression.class, "expression", Expression.class, true, true);
    public static final ChildPropertyDescriptor CLASSNAME_PROPERTY = new ChildPropertyDescriptor(InstanceOfExpression.class, "className", ClassName.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(2);
        propertyList.add(CLASSNAME_PROPERTY);
        propertyList.add(EXPRESSION_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public InstanceOfExpression(int start, int end, AST ast, Expression expr, ClassName className) {
        super(start, end, ast);
        if (expr == null || className == null) {
            throw new IllegalArgumentException();
        }
        this.setExpression(expr);
        this.setClassName(className);
    }

    public InstanceOfExpression(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.expression.accept(visitor);
        this.className.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expression.traverseTopDown(visitor);
        this.className.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.expression.traverseBottomUp(visitor);
        this.className.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<InstanceofExpression");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.expression.toString(buffer, "\t" + tab);
        buffer.append("\n");
        this.className.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</InstanceofExpression>");
    }

    @Override
    public int getType() {
        return 39;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public void setClassName(ClassName classname) {
        if (classname == null) {
            throw new IllegalArgumentException();
        }
        ClassName oldChild = this.className;
        this.preReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
        this.className = classname;
        this.postReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CLASSNAME_PROPERTY) {
            if (get) {
                return this.getClassName();
            }
            this.setClassName((ClassName)child);
            return null;
        }
        if (property == EXPRESSION_PROPERTY) {
            if (get) {
                return this.getExpression();
            }
            this.setExpression((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public Expression getExpr() {
        return this.expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.expression;
        this.preReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
        this.expression = expression;
        this.postReplaceChild(oldChild, expression, EXPRESSION_PROPERTY);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expr = ASTNode.copySubtree(target, this.getExpression());
        ClassName klass = ASTNode.copySubtree(target, this.getClassName());
        InstanceOfExpression result = new InstanceOfExpression(this.getStart(), this.getEnd(), target, expr, klass);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

