/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.compiler.ast.nodes;

import com.aptana.editor.php.epl.PHPEplPlugin;
import java.util.LinkedList;
import org2.eclipse.dltk.ast.references.SimpleReference;
import org2.eclipse.dltk.ast.references.TypeReference;
import org2.eclipse.dltk.ast.references.VariableReference;
import org2.eclipse.php.internal.core.ast.nodes.AST;
import org2.eclipse.php.internal.core.ast.nodes.Comment;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;

public class PHPDocTag
extends Comment
implements IPHPDocTag {
    private static final long serialVersionUID = 7543654184965368295L;
    public static final String ERROR = "ERROR!!!";
    public static final String THROWS_NAME = "throws";
    public static final String VERSION_NAME = "version";
    public static final String USES_NAME = "uses";
    public static final String TUTORIAL_NAME = "tutorial";
    public static final String SUBPACKAGE_NAME = "subpackage";
    public static final String SINCE_NAME = "since";
    public static final String LINK_NAME = "link";
    public static final String LICENSE_NAME = "license";
    public static final String INTERNAL_NAME = "internal";
    public static final String IGNORE_NAME = "ignore";
    public static final String FILESOURCE_NAME = "filesource";
    public static final String EXAMPLE_NAME = "example";
    public static final String DESC_NAME = "desc";
    public static final String COPYRIGHT_NAME = "copyright";
    public static final String CATEGORY_NAME = "category";
    public static final String ACCESS_NAME = "access";
    public static final String PACKAGE_NAME = "package";
    public static final String VAR_NAME = "var";
    public static final String TODO_NAME = "todo";
    public static final String STATICVAR_NAME = "staticvar";
    public static final String STATIC_NAME = "static";
    public static final String SEE_NAME = "see";
    public static final String PARAM_NAME = "param";
    public static final String RETURN_NAME = "return";
    public static final String NAME_NAME = "name";
    public static final String GLOBAL_NAME = "global";
    public static final String FINAL_NAME = "final";
    public static final String DEPRECATED_NAME = "deprecated";
    public static final String AUTHOR_NAME = "author";
    public static final String ABSTRACT_NAME = "abstract";
    public static final String PROPERTY_NAME = "property";
    public static final String PROPERTY_READ_NAME = "property-read";
    public static final String PROPERTY_WRITE_NAME = "property-write";
    public static final String METHOD_NAME = "method";
    private static final SimpleReference[] EMPTY = new SimpleReference[0];
    private final int tagKind;
    private String value;
    private SimpleReference[] references;

    public PHPDocTag(int start, int end, AST ast, int tagKind, String value) {
        super(start, end, ast, 2);
        this.tagKind = tagKind;
        this.value = PHPEplPlugin.getDefault().sharedString(value);
        this.updateReferences(start, end);
    }

    private static int getNonWhitespaceIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (!Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getWhitespaceIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (Character.isWhitespace(line.charAt(i))) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassStartIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) != '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int getClassEndIndex(String line, int startIndex) {
        int i = startIndex;
        while (i < line.length()) {
            if (line.charAt(i) == '|') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private void updateReferences(int start, int end) {
        int secondWordEnd;
        int secondWordStart;
        int firstWordEnd;
        int firstWordStart;
        int valueStart = start + PHPDocTag.getTagKind(this.tagKind).length() + 1;
        if (this.tagKind == 6 || this.tagKind == 12 || this.tagKind == 29) {
            int wordEnd;
            int wordStart = PHPDocTag.getNonWhitespaceIndex(this.value, 0);
            if (wordStart < (wordEnd = PHPDocTag.getWhitespaceIndex(this.value, wordStart))) {
                String word = this.value.substring(wordStart, wordEnd);
                int classStart = PHPDocTag.getClassStartIndex(word, 0);
                int classEnd = PHPDocTag.getClassEndIndex(word, classStart);
                LinkedList<TypeReference> types = new LinkedList<TypeReference>();
                while (classStart < classEnd) {
                    String className = word.substring(classStart, classEnd);
                    types.add(new TypeReference(valueStart + wordStart + classStart, valueStart + wordStart + classEnd, className));
                    classStart = PHPDocTag.getClassStartIndex(word, classEnd);
                    classEnd = PHPDocTag.getClassEndIndex(word, classStart);
                }
                if (types.size() > 0) {
                    this.references = types.toArray(new TypeReference[types.size()]);
                }
            }
        } else if (this.tagKind == 7 && (firstWordStart = PHPDocTag.getNonWhitespaceIndex(this.value, 0)) < (firstWordEnd = PHPDocTag.getWhitespaceIndex(this.value, firstWordStart)) && (secondWordStart = PHPDocTag.getNonWhitespaceIndex(this.value, firstWordEnd)) < (secondWordEnd = PHPDocTag.getWhitespaceIndex(this.value, secondWordStart))) {
            String firstWord = this.value.substring(firstWordStart, firstWordEnd);
            String secondWord = this.value.substring(secondWordStart, secondWordEnd);
            if (firstWord.charAt(0) == '$') {
                this.references = new SimpleReference[2];
                this.references[0] = new VariableReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
                this.references[1] = new TypeReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
            } else if (secondWord.charAt(0) == '$') {
                this.references = new SimpleReference[2];
                this.references[0] = new VariableReference(valueStart + secondWordStart, valueStart + secondWordEnd, secondWord);
                this.references[1] = new TypeReference(valueStart + firstWordStart, valueStart + firstWordEnd, firstWord);
            }
        }
        if (this.references == null) {
            this.references = EMPTY;
        }
    }

    @Override
    public int getTagKind() {
        return this.tagKind;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public SimpleReference[] getReferences() {
        return this.references;
    }

    public static String getTagKind(int kind) {
        switch (kind) {
            case 0: {
                return ABSTRACT_NAME;
            }
            case 1: {
                return AUTHOR_NAME;
            }
            case 2: {
                return DEPRECATED_NAME;
            }
            case 3: {
                return FINAL_NAME;
            }
            case 4: {
                return GLOBAL_NAME;
            }
            case 5: {
                return NAME_NAME;
            }
            case 6: {
                return RETURN_NAME;
            }
            case 7: {
                return PARAM_NAME;
            }
            case 8: {
                return SEE_NAME;
            }
            case 9: {
                return STATIC_NAME;
            }
            case 10: {
                return STATICVAR_NAME;
            }
            case 11: {
                return TODO_NAME;
            }
            case 12: {
                return VAR_NAME;
            }
            case 13: {
                return PACKAGE_NAME;
            }
            case 14: {
                return ACCESS_NAME;
            }
            case 15: {
                return CATEGORY_NAME;
            }
            case 16: {
                return COPYRIGHT_NAME;
            }
            case 17: {
                return DESC_NAME;
            }
            case 18: {
                return EXAMPLE_NAME;
            }
            case 19: {
                return FILESOURCE_NAME;
            }
            case 20: {
                return IGNORE_NAME;
            }
            case 21: {
                return INTERNAL_NAME;
            }
            case 22: {
                return LICENSE_NAME;
            }
            case 23: {
                return LINK_NAME;
            }
            case 24: {
                return SINCE_NAME;
            }
            case 25: {
                return SUBPACKAGE_NAME;
            }
            case 26: {
                return TUTORIAL_NAME;
            }
            case 27: {
                return USES_NAME;
            }
            case 28: {
                return VERSION_NAME;
            }
            case 29: {
                return THROWS_NAME;
            }
            case 30: {
                return PROPERTY_NAME;
            }
            case 31: {
                return PROPERTY_READ_NAME;
            }
            case 32: {
                return PROPERTY_WRITE_NAME;
            }
            case 33: {
                return METHOD_NAME;
            }
        }
        return ERROR;
    }

    @Override
    public int getID() {
        return this.getTagKind();
    }
}

