/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.documentModel.phpElementData;

import org.eclipse.core.runtime.Platform;
import org2.eclipse.php.internal.core.documentModel.phpElementData.CodeData;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IUserData;

public abstract class AbstractCodeData
implements CodeData {
    private static final long serialVersionUID = -1584581365974401435L;
    protected String name;
    private String description;
    private boolean isUserCode;
    protected IUserData userData;

    public AbstractCodeData(String name, String description) {
        this(name, description, null);
    }

    public AbstractCodeData(String name, String description, IUserData userData) {
        this.name = name;
        this.description = description;
        this.userData = userData;
        this.isUserCode = userData != null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public final boolean isUserCode() {
        return this.isUserCode;
    }

    @Override
    public final IUserData getUserData() {
        return this.userData;
    }

    public int compareTo(Object o) {
        if (!(o instanceof CodeData)) {
            return -1;
        }
        CodeData other = (CodeData)o;
        int rv = this.name.compareToIgnoreCase(other.getName());
        if (rv != 0) {
            return rv;
        }
        boolean otherIsUserCode = other.isUserCode();
        if (!this.isUserCode) {
            if (!otherIsUserCode) {
                return 0;
            }
            return -1;
        }
        if (!otherIsUserCode) {
            return 1;
        }
        return this.userData.getFileName().compareTo(other.getUserData().getFileName());
    }

    public String toString() {
        if (this.getUserData() == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " (in " + this.getUserData().getFileName() + ")";
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

