/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.documentModel.phpElementData;

import java.util.HashMap;
import org2.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;

public class BasicPHPDocTag
implements IPHPDocTag {
    private static final long serialVersionUID = 1L;
    private int id;
    private String value;
    private static HashMap nameToID;

    public BasicPHPDocTag(int id, String value) {
        this.id = id;
        this.value = value;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getTagKind() {
        return -1;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static String getName(int id) {
        switch (id) {
            case 0: {
                return "abstract";
            }
            case 1: {
                return "author";
            }
            case 14: {
                return "access";
            }
            case 15: {
                return "category";
            }
            case 16: {
                return "copyright";
            }
            case 2: {
                return "deprecated";
            }
            case 18: {
                return "example";
            }
            case 3: {
                return "final";
            }
            case 19: {
                return "filesource";
            }
            case 4: {
                return "global";
            }
            case 20: {
                return "ignore";
            }
            case 21: {
                return "internal";
            }
            case 22: {
                return "license";
            }
            case 23: {
                return "link";
            }
            case 5: {
                return "name";
            }
            case 6: {
                return "return";
            }
            case 13: {
                return "package";
            }
            case 7: {
                return "param";
            }
            case 8: {
                return "see";
            }
            case 24: {
                return "since";
            }
            case 9: {
                return "static";
            }
            case 10: {
                return "staticvar";
            }
            case 25: {
                return "subpackage";
            }
            case 29: {
                return "throws";
            }
            case 11: {
                return "todo";
            }
            case 26: {
                return "tutorial";
            }
            case 27: {
                return "uses";
            }
            case 12: {
                return "var";
            }
            case 28: {
                return "version";
            }
            case 17: {
                return "desc";
            }
        }
        return "";
    }

    public static int getID(String name) {
        Integer rv = (Integer)BasicPHPDocTag.getNameToID().get(name);
        if (rv == null) {
            return -1;
        }
        return rv;
    }

    private static HashMap getNameToID() {
        if (nameToID == null) {
            nameToID = new HashMap();
            nameToID.put("abstract", new Integer(0));
            nameToID.put("access", new Integer(14));
            nameToID.put("author", new Integer(1));
            nameToID.put("category", new Integer(15));
            nameToID.put("copyright", new Integer(16));
            nameToID.put("deprecated", new Integer(2));
            nameToID.put("desc", new Integer(17));
            nameToID.put("example", new Integer(18));
            nameToID.put("final", new Integer(3));
            nameToID.put("filesource", new Integer(19));
            nameToID.put("global", new Integer(4));
            nameToID.put("ignore", new Integer(20));
            nameToID.put("internal", new Integer(21));
            nameToID.put("license", new Integer(22));
            nameToID.put("link", new Integer(23));
            nameToID.put("name", new Integer(5));
            nameToID.put("return", new Integer(6));
            nameToID.put("package", new Integer(13));
            nameToID.put("param", new Integer(7));
            nameToID.put("see", new Integer(8));
            nameToID.put("since", new Integer(24));
            nameToID.put("static", new Integer(9));
            nameToID.put("staticvar", new Integer(10));
            nameToID.put("subpackage", new Integer(25));
            nameToID.put("throws", new Integer(29));
            nameToID.put("todo", new Integer(11));
            nameToID.put("tutorial", new Integer(26));
            nameToID.put("uses", new Integer(27));
            nameToID.put("var", new Integer(12));
            nameToID.put("version", new Integer(28));
        }
        return nameToID;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("@");
        b.append("<b>" + BasicPHPDocTag.getName(this.getID()) + "</b>");
        b.append(" ");
        if (this.getValue() != null) {
            b.append(this.getValue().toString());
        }
        return b.toString();
    }

    public static IPHPDocTag fromASTDocTag(IPHPDocTag docTag) {
        if (docTag == null) {
            return null;
        }
        String tagKind = PHPDocTag.getTagKind(docTag.getTagKind());
        int thisId = BasicPHPDocTag.getID(tagKind);
        if (thisId == -1) {
            return null;
        }
        return new BasicPHPDocTag(thisId, docTag.getValue());
    }
}

