/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org2.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;

public abstract class AbstractPreferencesPropagator {
    protected HashMap listenersMap;
    protected boolean isInstalled;
    protected Object lock = new Object();

    public void addPropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        ArrayList<IPreferencesPropagatorListener> list = (ArrayList<IPreferencesPropagatorListener>)this.listenersMap.get(preferencesKey);
        if (list == null) {
            list = new ArrayList<IPreferencesPropagatorListener>(5);
            this.listenersMap.put(preferencesKey, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public void removePropagatorListener(IPreferencesPropagatorListener listener, String preferencesKey) {
        List list = (List)this.listenersMap.get(preferencesKey);
        if (list != null) {
            list.remove(listener);
        }
    }

    public void setPropagatorListeners(List listeners, String preferencesKey) {
        this.listenersMap.put(preferencesKey, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getPropagatorListeners(String preferencesKey) {
        Object object = this.lock;
        synchronized (object) {
            return (List)this.listenersMap.get(preferencesKey);
        }
    }

    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.listenersMap = new HashMap();
        this.isInstalled = true;
    }

    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        this.listenersMap = null;
        this.isInstalled = false;
    }
}

