/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.preferences;

import com.aptana.editor.php.epl.PHPEplPlugin;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org2.eclipse.php.internal.core.preferences.AbstractPreferencesPropagator;
import org2.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org2.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;

public class ProjectPreferencesPropagator
extends AbstractPreferencesPropagator {
    private IProject project;
    private IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    private ProjectScope scope;
    private String nodeQualifier;

    public ProjectPreferencesPropagator(IProject project, String nodeQualifier) {
        this.project = project;
        this.nodeQualifier = nodeQualifier;
        this.install();
    }

    @Override
    protected synchronized void install() {
        if (this.isInstalled) {
            return;
        }
        this.scope = new ProjectScope(this.project);
        this.preferenceChangeListener = new InnerPreferenceChangeListener();
        this.scope.getNode(this.nodeQualifier).addPreferenceChangeListener(this.preferenceChangeListener);
        super.install();
    }

    @Override
    protected synchronized void uninstall() {
        if (!this.isInstalled) {
            return;
        }
        try {
            try {
                IEclipsePreferences prefNode = this.scope.getNode(this.nodeQualifier);
                prefNode.removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (Exception exception) {
                this.scope = null;
                this.preferenceChangeListener = null;
                super.uninstall();
            }
        }
        finally {
            this.scope = null;
            this.preferenceChangeListener = null;
            super.uninstall();
        }
    }

    public List removePropagatorListeners(String preferencesKey) {
        return (List)this.listenersMap.remove(preferencesKey);
    }

    public void notifyPropagatorEvent(PreferencesPropagatorEvent event) {
        this.notifyEvent((String)event.getKey(), event.getOldValue(), event.getNewValue());
    }

    private void notifyPropagatorEvent(IEclipsePreferences.PreferenceChangeEvent event) {
        this.notifyEvent(event.getKey(), event.getOldValue(), event.getNewValue());
    }

    private void notifyEvent(String key, Object oldValue, Object newValue) {
        List listeners = this.getPropagatorListeners(key);
        if (listeners != null) {
            if (newValue == null && (newValue = this.getWorkspaceProperty(key)) != null && newValue.equals(oldValue)) {
                return;
            }
            PreferencesPropagatorEvent e = new PreferencesPropagatorEvent(this.project, oldValue, newValue, key);
            IPreferencesPropagatorListener[] allListeners = new IPreferencesPropagatorListener[listeners.size()];
            listeners.toArray(allListeners);
            IPreferencesPropagatorListener[] iPreferencesPropagatorListenerArray = allListeners;
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                IPreferencesPropagatorListener element = iPreferencesPropagatorListenerArray[n2];
                element.preferencesEventOccured(e);
                ++n2;
            }
        }
    }

    public String getWorkspaceProperty(String id) {
        return PHPEplPlugin.getDefault().getPluginPreferences().getString(id);
    }

    private class InnerPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private InnerPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            ProjectPreferencesPropagator.this.notifyPropagatorEvent(event);
        }
    }
}

