/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.search;

import com.aptana.editor.php.core.typebinding.IMethodBinding;
import com.aptana.editor.php.core.typebinding.ITypeBinding;
import com.aptana.editor.php.internal.core.typebinding.Bindings;
import org2.eclipse.php.core.compiler.PHPFlags;
import org2.eclipse.php.internal.core.CoreMessages;
import org2.eclipse.php.internal.core.ast.nodes.ASTNode;
import org2.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.IBinding;
import org2.eclipse.php.internal.core.ast.nodes.Identifier;
import org2.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org2.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org2.eclipse.php.internal.core.ast.nodes.Program;
import org2.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org2.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org2.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org2.eclipse.php.internal.core.search.IOccurrencesFinder;
import org2.eclipse.php.internal.core.search.Messages;

public class ImplementOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ImplementOccurrencesFinder";
    private Identifier fIdentifier;
    private TypeDeclaration fTypeDeclaration;
    private ITypeBinding fBinding;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (this.isIdendifier(node)) {
            StructuralPropertyDescriptor locationInParent;
            Identifier bindingHolder = this.fIdentifier = (Identifier)node;
            if (this.fIdentifier.getParent() instanceof NamespaceName) {
                locationInParent = this.fIdentifier.getParent().getLocationInParent();
                bindingHolder = (Identifier)this.fIdentifier.getParent();
            } else {
                locationInParent = this.fIdentifier.getLocationInParent();
            }
            if (locationInParent != NamespaceDeclaration.NAME_PROPERTY && locationInParent != ClassDeclaration.SUPER_CLASS_PROPERTY && locationInParent != ClassDeclaration.INTERFACES_PROPERTY && locationInParent != InterfaceDeclaration.INTERFACES_PROPERTY) {
                return "ImplementOccurrencesFinder_invalidTarget";
            }
            IBinding resolvedBinding = bindingHolder.resolveBinding();
            if (resolvedBinding == null || !(resolvedBinding instanceof ITypeBinding)) {
                return "ImplementOccurrencesFinder_invalidTarget";
            }
            this.fBinding = (ITypeBinding)resolvedBinding;
            this.fTypeDeclaration = this.fIdentifier.getParent() instanceof NamespaceName ? (TypeDeclaration)this.fIdentifier.getParent().getParent() : (TypeDeclaration)this.fIdentifier.getParent();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private final boolean isIdendifier(ASTNode node) {
        return node != null && node.getType() == 33;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(CoreMessages.getString("ImplementOccurrencesFinder.3"), this.fIdentifier.getName());
        String baseDescription = Messages.format(BASE_DESCRIPTION, this.fIdentifier.getName());
        this.fTypeDeclaration.accept(this);
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.fIdentifier.getStart(), this.fIdentifier.getLength(), this.getOccurrenceType(this.fIdentifier), baseDescription));
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration) {
        IMethodBinding method;
        IMethodBinding methodBinding = methodDeclaration.resolveMethodBinding();
        if (methodBinding != null && !PHPFlags.isStatic(methodBinding.getModifiers()) && (method = Bindings.findOverriddenMethodInHierarchy(this.fBinding, methodBinding)) != null) {
            Identifier name = methodDeclaration.getFunction().getFunctionName();
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), 0, this.fDescription));
        }
        return super.visit(methodDeclaration);
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        return 8;
    }

    @Override
    public String getElementName() {
        return this.fIdentifier.getName();
    }

    @Override
    public String getID() {
        return ID;
    }
}

