/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.ui.preferences;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.preferences.CommonEditorPreferencePage;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.ui.preferences.AptanaPreferencePage;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org2.eclipse.php.internal.ui.PHPUIMessages;

public final class PHPPreferencePage
extends CommonEditorPreferencePage {
    private Composite advancedOptions;
    private BooleanFieldEditor markOccurences;
    private Composite appearanceComposite;
    private Composite foldingGroup;
    private BooleanFieldEditor foldTypes;
    private BooleanFieldEditor foldFunctions;
    private BooleanFieldEditor foldPHPDoc;
    private BooleanFieldEditor foldComments;

    public PHPPreferencePage() {
        this.setDescription(PHPUIMessages.getString("PHPPreferencePage.Title"));
        this.setPreferenceStore(PHPEplPlugin.getDefault().getPreferenceStore());
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.markOccurences && this.advancedOptions != null) {
            if (!((Boolean)event.getNewValue()).booleanValue()) {
                this.toggleAdvancedOccurrenceSection(false);
            } else {
                this.toggleAdvancedOccurrenceSection(true);
            }
        } else if (event.getSource() == this.enableFolding) {
            Object newValue = event.getNewValue();
            boolean enableFoldingOptions = false;
            if (Boolean.TRUE.equals(newValue)) {
                enableFoldingOptions = true;
            }
            this.foldTypes.setEnabled(enableFoldingOptions, this.foldingGroup);
            this.foldFunctions.setEnabled(enableFoldingOptions, this.foldingGroup);
            this.foldComments.setEnabled(enableFoldingOptions, this.foldingGroup);
            this.foldPHPDoc.setEnabled(enableFoldingOptions, this.foldingGroup);
        }
        super.propertyChange(event);
    }

    protected void initialize() {
        super.initialize();
        if (this.advancedOptions != null) {
            boolean markOccurrences = this.getPreferenceStore().getBoolean("com.aptana.editor.common.editorMarkOccurrences");
            this.toggleAdvancedOccurrenceSection(markOccurrences);
        }
    }

    private void toggleAdvancedOccurrenceSection(boolean show) {
        this.advancedOptions.setVisible(show);
        if (this.advancedOptions.getLayoutData() != null) {
            ((GridData)this.advancedOptions.getLayoutData()).exclude = !show;
        }
        this.appearanceComposite.layout(true, true);
    }

    protected void createMarkOccurrenceOptions(Composite parent) {
        this.appearanceComposite = parent;
        Composite group = AptanaPreferencePage.createGroup((Composite)parent, (String)PHPUIMessages.getString("PHPPreferencePage.Mark_Occurrences_Heading"));
        this.markOccurences = new BooleanFieldEditor("com.aptana.editor.common.editorMarkOccurrences", Messages.EditorsPreferencePage_MarkOccurrences, group);
        this.addField((FieldEditor)this.markOccurences);
        this.advancedOptions = new Composite(group, 0);
        this.advancedOptions.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.advancedOptions.setLayoutData((Object)GridDataFactory.fillDefaults().indent(18, 0).create());
        this.addField((FieldEditor)new BooleanFieldEditor("markTypeOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markTypeOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markMethodOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markMethodOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markFunctionOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markFunctionOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markConstantOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markConstantOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markGlobalVariableOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markGlobalVariableOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markLocalVariableOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markLocalVariableOccurrences"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markMethodExitPoints", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markMethodExitPoints"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markImplementors", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markImplementors"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("markBreakContinueTargets", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_markBreakContinueTargets"), this.advancedOptions));
        this.addField((FieldEditor)new BooleanFieldEditor("stickyOccurrences", PHPUIMessages.getString("MarkOccurrencesConfigurationBlock_stickyOccurrences"), this.advancedOptions));
        Link link = new Link(group, 0);
        link.setText(Messages.CommonEditorPreferencePage_Default_Editor_Preference_Link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)Display.getDefault().getActiveShell(), (String)e.text, null, null);
            }
        });
    }

    protected IPreferenceStore getChainedEditorPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{PHPEplPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    protected IEclipsePreferences getPluginPreferenceStore() {
        return InstanceScope.INSTANCE.getNode("com.aptana.editor.php.epl");
    }

    protected Composite createFoldingOptions(Composite parent) {
        this.foldingGroup = super.createFoldingOptions(parent);
        Label initialFoldLabel = new Label(this.foldingGroup, 64);
        initialFoldLabel.setText(PHPUIMessages.getString("PHPPreferencePage_initial_fold_options_label"));
        this.foldTypes = new BooleanFieldEditor("foldClasses", PHPUIMessages.getString("PHPPreferencePage_fold_types_label"), this.foldingGroup);
        this.addField((FieldEditor)this.foldTypes);
        this.foldFunctions = new BooleanFieldEditor("foldFunctions", PHPUIMessages.getString("PHPPreferencePage_fold_functions_label"), this.foldingGroup);
        this.addField((FieldEditor)this.foldFunctions);
        this.foldPHPDoc = new BooleanFieldEditor("foldPHPDoc", PHPUIMessages.getString("PHPPreferencePage_fold_phpdoc_label"), this.foldingGroup);
        this.addField((FieldEditor)this.foldPHPDoc);
        this.foldComments = new BooleanFieldEditor("foldComments", PHPUIMessages.getString("PHPPreferencePage_fold_comments_label"), this.foldingGroup);
        this.addField((FieldEditor)this.foldComments);
        return this.foldingGroup;
    }

    protected Composite createContentAssistOptions(Composite parent) {
        IPreferenceStore s = this.getChainedEditorPreferenceStore();
        if (s.contains("com.aptana.editor.php.epl.strictNamespaceCodeAssist")) {
            Label stringNsLabel = new Label(parent, 64);
            stringNsLabel.setText(PHPUIMessages.getString("PHPPreferencePage.strictNsInfo"));
            this.addField((FieldEditor)new BooleanFieldEditor("com.aptana.editor.php.epl.strictNamespaceCodeAssist", PHPUIMessages.getString("PHPPreferencePage.strictNSContentAssist"), parent));
        }
        return parent;
    }
}

