/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.beaver;

import com.aptana.editor.beaver.parsing.lexer.BeaverTokenType;
import com.aptana.editor.common.text.rules.CharacterMapRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import com.aptana.editor.common.text.rules.WordDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class BeaverSourceScanner
extends RuleBasedScanner {
    public BeaverSourceScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SingleLineRule("\"", "\"", this.createToken(BeaverTokenType.STRING_DOUBLE)));
        rules.add(new SingleLineRule("'", "'", this.createToken(BeaverTokenType.STRING_SINGLE)));
        WordRule keywordRule = new WordRule((IWordDetector)new KeywordDetector(), Token.UNDEFINED);
        keywordRule.addWord("%class", this.createToken(BeaverTokenType.CLASS));
        keywordRule.addWord("%embed", this.createToken(BeaverTokenType.EMBED));
        keywordRule.addWord("%goal", this.createToken(BeaverTokenType.GOAL));
        keywordRule.addWord("%header", this.createToken(BeaverTokenType.HEADER));
        keywordRule.addWord("%implements", this.createToken(BeaverTokenType.IMPLEMENTS));
        keywordRule.addWord("%import", this.createToken(BeaverTokenType.IMPORT));
        keywordRule.addWord("%init", this.createToken(BeaverTokenType.INIT));
        keywordRule.addWord("%left", this.createToken(BeaverTokenType.LEFT));
        keywordRule.addWord("%package", this.createToken(BeaverTokenType.PACKAGE));
        keywordRule.addWord("%right", this.createToken(BeaverTokenType.RIGHT));
        keywordRule.addWord("%terminals", this.createToken(BeaverTokenType.TERMINALS));
        keywordRule.addWord("%typeof", this.createToken(BeaverTokenType.TYPEOF));
        keywordRule.addWord("%nonassoc", this.createToken(BeaverTokenType.NONASSOC));
        rules.add(keywordRule);
        CharacterMapRule cmRule = new CharacterMapRule();
        cmRule.add(';', this.createToken(BeaverTokenType.SEMICOLON));
        cmRule.add('=', this.createToken(BeaverTokenType.EQUAL));
        cmRule.add('|', this.createToken(BeaverTokenType.PIPE));
        cmRule.add('?', this.createToken(BeaverTokenType.QUESTION));
        cmRule.add('*', this.createToken(BeaverTokenType.STAR));
        cmRule.add('+', this.createToken(BeaverTokenType.PLUS));
        rules.add(cmRule);
        rules.add(new WordRule((IWordDetector)new WordDetector(), this.createToken(BeaverTokenType.IDENTIFIER)));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    protected IToken createToken(BeaverTokenType type) {
        return new Token((Object)type.getScope());
    }

    static class KeywordDetector
    implements IWordDetector {
        private int _index;

        KeywordDetector() {
        }

        public boolean isWordStart(char c) {
            this._index = 0;
            return c == '%';
        }

        public boolean isWordPart(char c) {
            ++this._index;
            if (this._index == 1) {
                return Character.isJavaIdentifierStart(c);
            }
            return Character.isJavaIdentifierPart(c);
        }
    }
}

