/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.sass;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.EmptyCommentRule;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.sass.SassCodeScanner;
import com.aptana.editor.sass.StringScanner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class SassSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__sass_";
    public static final String DEFAULT = "__sass___dftl_partition_content_type";
    public static final String STRING_SINGLE = "__sass_string_single";
    public static final String STRING_DOUBLE = "__sass_string_double";
    public static final String SINGLE_LINE_COMMENT = "__sass_singleline_comment";
    public static final String MULTI_LINE_COMMENT = "__sass_multiline_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__sass___dftl_partition_content_type", "__sass_singleline_comment", "__sass_multiline_comment", "__sass_string_single", "__sass_string_double"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.sass"}};
    private IPredicateRule[] partitioningRules;
    private static SassSourceConfiguration instance;

    public static SassSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new SassSourceConfiguration();
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.sass"}), new QualifiedContentType(new String[]{"source.sass"}));
        }
        return instance;
    }

    private SassSourceConfiguration() {
        IToken singleLineComment = SassSourceConfiguration.getToken(SINGLE_LINE_COMMENT);
        IToken multiLineComment = SassSourceConfiguration.getToken(MULTI_LINE_COMMENT);
        this.partitioningRules = new IPredicateRule[]{new SingleLineRule("\"", "\"", SassSourceConfiguration.getToken(STRING_DOUBLE), '\\'), new SingleLineRule("'", "'", SassSourceConfiguration.getToken(STRING_SINGLE), '\\'), new EmptyCommentRule(multiLineComment), new MultiLineRule("/*", "*/", multiLineComment), new EndOfLineRule("//", singleLineComment)};
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, SassSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.sass";
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getSingleLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, SINGLE_LINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, SINGLE_LINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getMultiLineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, MULTI_LINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, MULTI_LINE_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new ThemeingDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return null;
    }

    private ITokenScanner getCodeScanner() {
        return new SassCodeScanner();
    }

    private ITokenScanner getSingleLineCommentScanner() {
        return new CommentScanner(SassSourceConfiguration.getToken("comment.line.sass"));
    }

    private ITokenScanner getMultiLineCommentScanner() {
        return new CommentScanner(SassSourceConfiguration.getToken("comment.block.sass"));
    }

    private ITokenScanner getDoubleQuotedStringScanner() {
        return new StringScanner("string.quoted.double.sass");
    }

    private ITokenScanner getSingleQuotedStringScanner() {
        return new StringScanner("string.quoted.single.sass");
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

