/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.console.internal.expressions;

import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Expression {
    private boolean enabled = true;
    private String label;
    private String expression;
    private SortedMap<Integer, String> groupScopes;
    private Pattern pattern;

    public Expression(String label, String expression, SortedMap<Integer, String> groupScopes) {
        this.label = label;
        this.expression = expression;
        this.groupScopes = groupScopes;
    }

    public StyleRange[] calculateStyleRanges(int lineOffset, String lineText) {
        Matcher matcher;
        if (this.enabled && this.groupScopes != null && !this.groupScopes.isEmpty() && (matcher = this.getPattern().matcher(lineText)).matches()) {
            ArrayList<StyleRange> result = new ArrayList<StyleRange>();
            int groupCount = Math.min(matcher.groupCount(), this.groupScopes.lastKey());
            if (groupCount == 0) {
                TextAttribute textAttribute = this.getTextAttribute((String)this.groupScopes.get(this.groupScopes.firstKey()));
                result.add(Expression.createStyleRange(lineOffset, lineText.length(), textAttribute));
            } else {
                TextAttribute defaultTextAttribute = this.getTextAttribute((String)this.groupScopes.get(this.groupScopes.firstKey()));
                int previous = 0;
                int group = 1;
                while (group <= groupCount) {
                    int offset = matcher.start(group);
                    int length = matcher.group(group).length();
                    if (offset > previous) {
                        result.add(Expression.createStyleRange(lineOffset + previous, offset - previous, defaultTextAttribute));
                    }
                    previous = offset + length;
                    if (this.groupScopes.containsKey(group)) {
                        result.add(Expression.createStyleRange(lineOffset + offset, length, this.getTextAttribute((String)this.groupScopes.get(group))));
                    } else {
                        previous = offset;
                    }
                    ++group;
                }
                if (previous < lineText.length()) {
                    result.add(Expression.createStyleRange(lineOffset + previous, lineText.length() - previous, defaultTextAttribute));
                }
            }
            return result.toArray(new StyleRange[result.size()]);
        }
        return null;
    }

    private TextAttribute getTextAttribute(String scope) {
        TextAttribute ta = this.getCurrentTheme().getTextAttribute(scope);
        RGB defaultRGB = this.getCurrentTheme().getForeground();
        if (ta.getForeground().getRGB().equals((Object)defaultRGB)) {
            return new TextAttribute(null, ta.getBackground(), ta.getStyle());
        }
        return ta;
    }

    public Color calculateBackground(String lineText) {
        if (this.enabled && this.getPattern().matcher(lineText).matches()) {
            return this.getCurrentTheme().getBackground((String)this.groupScopes.get(this.groupScopes.firstKey()));
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.pattern = null;
    }

    public SortedMap<Integer, String> getGroupScopes() {
        return this.groupScopes;
    }

    public void setGroupScopes(SortedMap<Integer, String> groupScopes) {
        this.groupScopes = groupScopes;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.expression);
        }
        return this.pattern;
    }

    private static StyleRange createStyleRange(int offset, int length, TextAttribute textAttribute) {
        int style = textAttribute.getStyle();
        int fontStyle = style & 3;
        StyleRange styleRange = new StyleRange(offset, length, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
        styleRange.strikeout = (style & 0x20000000) != 0;
        styleRange.underline = (style & 0x40000000) != 0;
        return styleRange;
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }
}

