/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.ui.IPropertyDialogProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyDialogsRegistry {
    private static final String TAG_DIALOG = "dialog";
    private static final String ATT_OBJECT_CLASS = "objectClass";
    private static final String ATT_CLASS = "class";
    private static final String EXTENSION_POINT_ID = "propertyDialogs";
    private static PropertyDialogsRegistry instance;
    private Map<String, IConfigurationElement> classNameToElementMap = new HashMap<String, IConfigurationElement>();
    private Map<String, IPropertyDialogProvider> classNameToDialogProviderMap = new HashMap<String, IPropertyDialogProvider>();

    private PropertyDialogsRegistry() {
        this.readExtensionRegistry();
    }

    public static PropertyDialogsRegistry getInstance() {
        if (instance == null) {
            instance = new PropertyDialogsRegistry();
        }
        return instance;
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.ui", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                PropertyDialogsRegistry.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{PropertyDialogsRegistry.TAG_DIALOG});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_DIALOG.equals(element.getName())) {
            String objectClazz = element.getAttribute(ATT_OBJECT_CLASS);
            if (objectClazz == null || objectClazz.length() == 0) {
                return;
            }
            String clazz = element.getAttribute(ATT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            this.classNameToElementMap.put(objectClazz, element);
        }
    }

    public Dialog createPropertyDialog(Object element, IShellProvider shellProvider) throws CoreException {
        if (element != null) {
            return this.createPropertyDialog(element.getClass(), shellProvider);
        }
        return null;
    }

    public Dialog createPropertyDialog(Class<?> elementClass, IShellProvider shellProvider) throws CoreException {
        IPropertyDialogProvider provider = this.getPropertyDialogProvider(elementClass);
        if (provider != null) {
            return provider.createPropertyDialog(shellProvider);
        }
        return null;
    }

    private IPropertyDialogProvider getPropertyDialogProvider(Class<?> elementClass) throws CoreException {
        HashSet<String> classes = new HashSet<String>();
        if (this.classNameToDialogProviderMap.containsKey(elementClass.getCanonicalName())) {
            return this.classNameToDialogProviderMap.get(elementClass.getCanonicalName());
        }
        classes.add(elementClass.getCanonicalName());
        Class<?>[] classArray = elementClass.getClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            classes.add(i.getCanonicalName());
            ++n2;
        }
        for (String className : this.classNameToElementMap.keySet()) {
            if (!classes.contains(className)) continue;
            IPropertyDialogProvider provider = (IPropertyDialogProvider)this.classNameToElementMap.get(className).createExecutableExtension(ATT_CLASS);
            if (provider != null) {
                this.classNameToDialogProviderMap.put(elementClass.getCanonicalName(), provider);
            }
            return provider;
        }
        return null;
    }
}

