/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.commands;

import com.aptana.core.CorePlugin;
import com.aptana.core.diagnostic.IDiagnosticLog;
import com.aptana.core.diagnostic.IDiagnosticManager;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.dialogs.DiagnosticDialog;
import com.aptana.ui.util.UIUtils;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DiagnosticHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job = new Job("Getting Diagnostic Logs"){

            protected IStatus run(IProgressMonitor monitor) {
                final String content = DiagnosticHandler.getLogContent();
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        DiagnosticDialog dialog = new DiagnosticDialog(UIUtils.getActiveShell());
                        dialog.open();
                        dialog.setText(content);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
        return null;
    }

    public static String getLogContent() {
        StringBuilder content = new StringBuilder();
        List logs = DiagnosticHandler.getDiagnosticManager().getLogs();
        for (IDiagnosticLog log : logs) {
            String logText = log.getLog();
            if (StringUtil.isEmpty((String)logText)) continue;
            content.append(logText).append('\n');
        }
        return content.toString();
    }

    protected static IDiagnosticManager getDiagnosticManager() {
        return CorePlugin.getDefault().getDiagnosticManager();
    }
}

