/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.dialogs;

import com.aptana.core.util.StringUtil;
import com.aptana.ui.util.WorkbenchBrowserUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class HyperlinkMessageDialog
extends MessageDialog {
    private Link messageLink;
    private String toggleMessage;
    private boolean toggleState;

    public HyperlinkMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String toggleMessage) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.toggleMessage = toggleMessage;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        if (!StringUtil.isEmpty((String)this.toggleMessage)) {
            this.createToggleButton(dialogAreaComposite);
        }
        return dialogAreaComposite;
    }

    protected Control createMessageArea(Composite composite) {
        String message = this.message;
        this.message = null;
        Composite messageArea = (Composite)super.createMessageArea(composite);
        this.messageLink = new Link(messageArea, this.getMessageLabelStyle() | 0x80000);
        this.messageLink.setText("<a></a>" + message);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLink);
        this.messageLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkMessageDialog.this.openLink(e);
            }
        });
        return messageArea;
    }

    protected Button createToggleButton(Composite parent) {
        final Button button = new Button(parent, 16416);
        button.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        button.setFont(parent.getFont());
        button.setText(this.toggleMessage);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkMessageDialog.this.toggleState = button.getSelection();
            }
        });
        return button;
    }

    protected void openLink(SelectionEvent e) {
        WorkbenchBrowserUtil.launchExternalBrowser(e.text);
    }

    public static boolean open(int kind, Shell parent, String title, String message, int style) {
        return HyperlinkMessageDialog.open(kind, parent, title, message, null, style);
    }

    public static boolean open(int kind, Shell parent, String title, String message, String toggleMessage, int style) {
        HyperlinkMessageDialog dialog = new HyperlinkMessageDialog(parent, title, null, message, kind, HyperlinkMessageDialog.getButtonLabels(kind), 0, toggleMessage);
        return dialog.open() == 0;
    }

    public static void openInformation(Shell parent, String title, String message) {
        HyperlinkMessageDialog.open(2, parent, title, message, null, 0);
    }

    public static void openError(Shell parent, String title, String message) {
        HyperlinkMessageDialog.open(1, parent, title, message, 0);
    }

    public static String[] getButtonLabels(int kind) {
        switch (kind) {
            case 1: 
            case 2: 
            case 4: {
                return new String[]{IDialogConstants.OK_LABEL};
            }
            case 5: {
                return new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            }
            case 3: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
            }
            case 6: {
                return new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            }
        }
        throw new IllegalArgumentException("Illegal value for kind in HyperlinkMessageDialog.open()");
    }
}

