/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp.internal;

import com.aptana.core.io.vfs.BaseConnectionFileManager;
import com.aptana.core.io.vfs.ExtendedFileInfo;
import com.aptana.core.util.URLEncoder;
import com.aptana.filesystem.ftp.FTPPlugin;
import com.aptana.filesystem.ftp.Policy;
import com.aptana.filesystem.ftp.internal.Messages;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BaseFTPConnectionFileManager
extends BaseConnectionFileManager {
    protected static final int TIMEOUT = 20000;
    protected static final int RETRY = 3;
    protected static final int RETRY_DELAY = 5000;
    protected static final int KEEPALIVE_INTERVAL = 15000;
    protected static final int TRANSFER_BUFFER_SIZE = 32768;
    protected static final int CHECK_CONNECTION_TIMEOUT = 30000;
    protected static final String TMP_UPLOAD_SUFFIX = "._tmp_upload";
    protected static final Pattern PASS_COMMAND_PATTERN = Pattern.compile("^(.*PASS ).+$");
    protected String host;
    protected int port;
    private long lastOperationTime;
    protected String defaultOwner;
    protected String defaultGroup;

    protected boolean canUseTemporaryFile(IPath path, ExtendedFileInfo fileInfo, IProgressMonitor monitor) {
        ConnectionContext context = CoreIOPlugin.getConnectionContext((Object)((Object)this));
        if (context != null && context.containsKey((Object)"use_temporary_on_upload")) {
            return context.getBoolean("use_temporary_on_upload");
        }
        if (fileInfo.exists()) {
            if (this.defaultOwner == null || this.defaultGroup == null) {
                IPath tempFile = this.basePath.append(path).removeLastSegments(1).append(String.valueOf(System.currentTimeMillis()) + TMP_UPLOAD_SUFFIX + ".txt");
                ExtendedFileInfo tempFileInfo = null;
                monitor.beginTask(Messages.BaseFTPConnectionFileManager_GetheringServerDetails, 3);
                try {
                    try {
                        this.createFile(tempFile, Policy.subMonitorFor(monitor, 1));
                        tempFileInfo = this.fetchFileInternal(tempFile, 0, Policy.subMonitorFor(monitor, 1));
                    }
                    finally {
                        this.deleteFile(tempFile, Policy.subMonitorFor(monitor, 1));
                    }
                }
                catch (Exception e) {
                    FTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.ftp", Messages.BaseFTPConnectionFileManager_ErrorDetectOwnerGroup, (Throwable)e));
                }
                if (tempFileInfo != null) {
                    this.defaultOwner = tempFileInfo.getOwner();
                    this.defaultGroup = tempFileInfo.getGroup();
                }
            }
            if (this.defaultOwner == null) {
                this.defaultOwner = Long.toHexString(System.currentTimeMillis());
            }
            if (this.defaultGroup == null) {
                this.defaultGroup = Long.toHexString(System.currentTimeMillis());
            }
            if (!this.defaultOwner.equals(fileInfo.getOwner()) || !this.defaultGroup.equals(fileInfo.getGroup())) {
                return false;
            }
        }
        return true;
    }

    public URI getCanonicalURI(IPath path) {
        return this.getRootCanonicalURI().resolve(URLEncoder.encode((String)this.basePath.append(path).toPortableString(), null, null));
    }

    protected abstract void checkConnected() throws Exception;

    protected abstract URI getRootCanonicalURI();

    protected void testConnection(boolean force) {
        if (!this.isConnected()) {
            return;
        }
        if (force || System.currentTimeMillis() - this.lastOperationTime > 30000L) {
            try {
                this.checkConnected();
                if (this.isConnected()) {
                    this.setLastOperationTime();
                }
            }
            catch (Exception e) {
                FTPPlugin.log((IStatus)new Status(2, "com.aptana.filesystem.ftp", Messages.BaseFTPConnectionFileManager_connection_check_failed, (Throwable)e));
            }
        }
    }

    protected void setLastOperationTime() {
        this.lastOperationTime = System.currentTimeMillis();
    }
}

