/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.ftp.internal;

import com.aptana.core.util.ProgressMonitorInterrupter;
import com.aptana.filesystem.ftp.internal.FTPClientPool;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;

public class FTPFileUploadOutputStream
extends OutputStream {
    private FTPClientInterface ftpClient;
    private FileTransferOutputStream ftpOutputStream;
    private String filename;
    private Date modificationTime;
    private long permissions;
    private FTPClientPool pool;
    private Runnable completeRunnable;

    public FTPFileUploadOutputStream(FTPClientPool pool, FTPClientInterface _ftpClient, FileTransferOutputStream ftpOutputStream, String filename, Date modificationTime, long permissions, Runnable completeRunnable) {
        this.ftpClient = _ftpClient;
        this.ftpOutputStream = ftpOutputStream;
        this.filename = filename;
        this.modificationTime = modificationTime;
        this.permissions = permissions;
        this.pool = pool;
        this.completeRunnable = completeRunnable;
        ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate((ProgressMonitorInterrupter.InterruptDelegate)new ProgressMonitorInterrupter.InterruptDelegate(){

            public void interrupt() {
                try {
                    if (FTPFileUploadOutputStream.this.ftpClient.connected()) {
                        FTPFileUploadOutputStream.this.ftpClient.quitImmediately();
                    }
                }
                catch (Exception ignore) {
                    ignore.getCause();
                }
            }
        });
    }

    private void safeQuit(boolean failed) {
        try {
            try {
                if (this.ftpClient.connected() && failed && this.filename != null) {
                    this.ftpClient.delete(this.ftpOutputStream.getRemoteFile());
                }
            }
            catch (Exception ignore) {
                ignore.getCause();
                try {
                    this.ftpOutputStream.close();
                }
                catch (IOException ignore2) {
                    ignore2.getCause();
                }
                this.pool.checkIn(this.ftpClient);
                if (this.completeRunnable != null) {
                    this.completeRunnable.run();
                    this.completeRunnable = null;
                }
                ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
            }
        }
        finally {
            try {
                this.ftpOutputStream.close();
            }
            catch (IOException ignore) {
                ignore.getCause();
            }
            this.pool.checkIn(this.ftpClient);
            if (this.completeRunnable != null) {
                this.completeRunnable.run();
                this.completeRunnable = null;
            }
            ProgressMonitorInterrupter.setCurrentThreadInterruptDelegate(null);
        }
    }

    public void write(int b) throws IOException {
        try {
            this.ftpOutputStream.write(b);
        }
        catch (IOException e) {
            this.safeQuit(true);
            throw e;
        }
    }

    public void close() throws IOException {
        try {
            this.ftpOutputStream.close();
            try {
                String actualFilename;
                String string = actualFilename = this.filename != null ? this.filename : this.ftpOutputStream.getRemoteFile();
                if (this.filename != null) {
                    if (this.ftpClient.exists(this.filename)) {
                        this.ftpClient.delete(this.filename);
                        this.filename = null;
                    }
                    this.ftpClient.rename(this.ftpOutputStream.getRemoteFile(), actualFilename);
                    this.filename = null;
                }
                if (this.modificationTime != null) {
                    this.ftpClient.setModTime(actualFilename, this.modificationTime);
                }
                if (this.ftpClient instanceof FTPClient && this.permissions > 0L) {
                    ((FTPClient)this.ftpClient).site(MessageFormat.format("CHMOD {0} {1}", Long.toOctalString(this.permissions), actualFilename));
                }
            }
            catch (FTPException e) {
                this.safeQuit(true);
                throw new IOException(e.getMessage());
            }
        }
        finally {
            this.safeQuit(false);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.ftpOutputStream.write(b, off, len);
        }
        catch (IOException e) {
            this.safeQuit(true);
            throw e;
        }
    }
}

