/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml.internal;

import com.aptana.editor.common.text.rules.SingleCharacterRule;
import com.aptana.editor.common.text.rules.WhitespaceDetector;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class HAMLElementScanner
extends BufferedRuleBasedScanner {
    private IToken fLastToken;

    public HAMLElementScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        rules.add(new SingleCharacterRule('%', this.createToken("punctuation.definition.tag.haml")));
        rules.add(new WordRule((IWordDetector)new TagDetector(), this.createToken("entity.name.tag.haml")));
        rules.add(new WordRule((IWordDetector)new IDDetector(), this.createToken("entity.name.tag.id.haml")));
        rules.add(new WordRule((IWordDetector)new ClassDetector(), this.createToken("entity.name.tag.class.haml")));
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private IToken createToken(String string) {
        return new Token((Object)string);
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (token != null && "entity.name.tag.haml".equals(token.getData()) && (this.fLastToken == null || !"punctuation.definition.tag.haml".equals(this.fLastToken.getData()))) {
            token = this.createToken("");
        }
        this.fLastToken = token;
        return token;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fLastToken = null;
    }

    private static final class ClassDetector
    implements IWordDetector {
        private ClassDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '.';
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-';
        }
    }

    private static final class IDDetector
    implements IWordDetector {
        private IDDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '#';
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-';
        }
    }

    private static final class TagDetector
    implements IWordDetector {
        private TagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '-';
        }
    }
}

