/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import beaver.Scanner;
import com.aptana.buildpath.core.BuildPathManager;
import com.aptana.buildpath.core.IBuildPathEntry;
import com.aptana.core.IFilter;
import com.aptana.core.util.AndFilter;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.VersionUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.FunctionArgumentProposal;
import com.aptana.editor.js.contentassist.JSContextInformation;
import com.aptana.editor.js.contentassist.JSContextInformationValidator;
import com.aptana.editor.js.contentassist.JSLocationIdentifier;
import com.aptana.editor.js.contentassist.LocationType;
import com.aptana.editor.js.contentassist.Messages;
import com.aptana.editor.js.contentassist.ParseUtil;
import com.aptana.editor.js.contentassist.PropertyElementProposal;
import com.aptana.editor.js.internal.JSModelUtil;
import com.aptana.editor.js.text.JSFlexLexemeProvider;
import com.aptana.index.core.Index;
import com.aptana.js.core.JSLanguageConstants;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.JSNodeTypeInferrer;
import com.aptana.js.core.inferencing.JSPropertyCollection;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeUtil;
import com.aptana.js.core.inferencing.RequireResolverFactory;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.ParameterElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.parsing.JSFlexScanner;
import com.aptana.js.core.parsing.JSParseState;
import com.aptana.js.core.parsing.JSTokenType;
import com.aptana.js.core.parsing.ThisAssignmentCollector;
import com.aptana.js.core.parsing.ast.JSArgumentsNode;
import com.aptana.js.core.parsing.ast.JSAssignmentNode;
import com.aptana.js.core.parsing.ast.JSConstructNode;
import com.aptana.js.core.parsing.ast.JSFunctionNode;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSInvokeNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSObjectNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSPrimitiveNode;
import com.aptana.js.core.parsing.ast.JSThisNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.INameNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final String SDK_3_4_0 = "3.4.0.GA";
    private static final String API_JSCA = "api.jsca";
    private static final Image JS_FUNCTION = JSPlugin.getImage("/icons/js_function.png");
    private static final Image JS_PROPERTY = JSPlugin.getImage("/icons/js_property.png");
    private static final Image JS_KEYWORD = JSPlugin.getImage("/icons/keyword.png");
    private static final Image STRING_ICON = JSPlugin.getImage("icons/string.png");
    private static final IFilter<PropertyElement> isVisibleFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            return !item.isInternal();
        }
    };
    private static final IFilter<PropertyElement> isInstanceFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            String typeName = item.getOwningType();
            if (typeName.equals("module.exports") || typeName.startsWith("$module") && typeName.endsWith(".exports")) {
                if ("id".equals(item.getName()) || "uri".equals(item.getName())) {
                    return true;
                }
                return item.isClassProperty();
            }
            return item.isInstanceProperty();
        }
    };
    private static final IFilter<PropertyElement> isStaticFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            String typeName = item.getOwningType();
            if ((typeName.equals("module.exports") || typeName.startsWith("$module") && typeName.endsWith(".exports")) && ("id".equals(item.getName()) || "uri".equals(item.getName()))) {
                return true;
            }
            return item.isClassProperty();
        }
    };
    private static final IFilter<PropertyElement> isNotConstructorFilter = new IFilter<PropertyElement>(){

        public boolean include(PropertyElement item) {
            if (!(item instanceof FunctionElement)) {
                return true;
            }
            return !((FunctionElement)item).isConstructor();
        }
    };
    private static Set<String> AUTO_ACTIVATION_PARTITION_TYPES = CollectionsUtil.newSet((Object[])new String[]{"__js__dftl_partition_content_type", "__dftl_partition_content_type"});
    private JSIndexQueryHelper indexHelper;
    private IParseNode targetNode;
    private IParseNode statementNode;
    private IRange replaceRange;
    private IRange activeRange;
    private ITextViewer textViewer;

    public JSContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    public JSContentAssistProcessor(AbstractThemeableEditor editor, IRange activeRange) {
        this(editor);
        this.activeRange = activeRange;
    }

    private void addKeywords(Set<ICompletionProposal> proposals, int offset) {
        String[] activeUserAgentIds = this.getActiveUserAgentIds();
        for (String name : JSLanguageConstants.KEYWORDS) {
            String description = MessageFormat.format(Messages.JSContentAssistProcessor_KeywordDescription, name);
            this.addProposal(proposals, name, JS_KEYWORD, description, activeUserAgentIds, Messages.JSContentAssistProcessor_KeywordLocation, offset);
        }
    }

    protected void addObjectLiteralProperties(Set<ICompletionProposal> proposals, ITextViewer viewer, int offset) {
        FunctionElement function = this.getFunctionElement(viewer, offset);
        if (function == null) {
            return;
        }
        List params = function.getParameters();
        int index = this.getArgumentIndex(offset);
        if (index >= 0 && index < params.size()) {
            ParameterElement param = (ParameterElement)params.get(index);
            URI projectURI = this.getProjectURI();
            for (String type : param.getTypes()) {
                Collection properties = this.getQueryHelper().getTypeProperties(type);
                for (PropertyElement property : CollectionsUtil.filter((Collection)properties, isVisibleFilter)) {
                    this.addProposal(proposals, property, offset, projectURI, null);
                }
            }
        }
    }

    private void addGlobals(Set<ICompletionProposal> proposals, int offset) {
        Collection projectGlobals = this.getQueryHelper().getGlobals(this.getFilename());
        if (CollectionsUtil.isEmpty((Collection)projectGlobals)) {
            return;
        }
        String[] userAgentIds = this.getActiveUserAgentIds();
        URI projectURI = this.getProjectURI();
        for (PropertyElement property : CollectionsUtil.filter((Collection)projectGlobals, isVisibleFilter)) {
            String location = null;
            List documents = property.getDocuments();
            if (!CollectionsUtil.isEmpty((Collection)documents)) {
                String docString = (String)documents.get(0);
                int index = docString.lastIndexOf(47);
                location = index != -1 ? docString.substring(index + 1) : docString;
            }
            this.addProposal(proposals, property, offset, projectURI, location, userAgentIds);
        }
    }

    protected void addProperties(Set<ICompletionProposal> proposals, int offset) {
        JSGetPropertyNode node = ParseUtil.getGetPropertyNode(this.targetNode, this.statementNode);
        boolean isInstance = this.isInstance(node);
        List<String> types = this.getParentObjectTypes(node, offset);
        for (String type : types) {
            this.addTypeProperties(proposals, type, offset, isInstance);
        }
    }

    private boolean isInstance(JSGetPropertyNode node) {
        IParseNode left = node.getChild(0);
        if (left instanceof JSThisNode) {
            return true;
        }
        if (left instanceof JSConstructNode || left instanceof JSPrimitiveNode) {
            if (left instanceof JSIdentifierNode) {
                JSIdentifierNode ident = (JSIdentifierNode)left;
                String name = ident.getNameNode().getName();
                if ("$".equals(name) || "Ti".equals(name) || "jQuery".equals(name)) {
                    return false;
                }
                Collection types = this.getQueryHelper().getTypes(name, false);
                if (CollectionsUtil.isEmpty((Collection)types)) {
                    return true;
                }
                return !Character.isUpperCase(name.charAt(0));
            }
            return true;
        }
        return left instanceof JSInvokeNode;
    }

    private void addProposal(Set<ICompletionProposal> proposals, PropertyElement property, int offset, URI projectURI, String overriddenLocation) {
        List userAgentNameList = property.getUserAgentNames();
        String[] userAgentNames = userAgentNameList.toArray(new String[userAgentNameList.size()]);
        this.addProposal(proposals, property, offset, projectURI, overriddenLocation, userAgentNames);
    }

    private void addProposal(Set<ICompletionProposal> proposals, PropertyElement property, int offset, URI projectURI, String overriddenLocation, String[] userAgentNames) {
        if (this.isActiveByUserAgent(userAgentNames)) {
            int replaceLength = 0;
            if (this.replaceRange != null) {
                offset = this.replaceRange.getStartingOffset();
                replaceLength = this.replaceRange.getLength();
            }
            if (property.getOwningType().startsWith("$module")) {
                IPath path = this.getQueryHelper().getModulePath(property.getOwningType());
                property.setOwningType(path.toOSString());
            }
            PropertyElementProposal proposal = new PropertyElementProposal(property, offset, replaceLength, projectURI);
            proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
            if (!StringUtil.isEmpty((String)overriddenLocation)) {
                proposal.setFileLocation(overriddenLocation);
            }
            Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgentNames);
            proposal.setUserAgentImages(userAgents);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    private CommonCompletionProposal addProposal(Set<ICompletionProposal> proposals, String displayName, Image image, String description, String[] userAgentIds, String fileLocation, int offset) {
        if (this.isActiveByUserAgent(userAgentIds)) {
            int length = displayName.length();
            int replaceLength = 0;
            if (this.replaceRange != null) {
                offset = this.replaceRange.getStartingOffset();
                replaceLength = this.replaceRange.getLength();
            }
            IContextInformation contextInfo = null;
            Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgentIds);
            CommonCompletionProposal proposal = new CommonCompletionProposal(displayName, offset, replaceLength, length, image, displayName, contextInfo, description);
            proposal.setFileLocation(fileLocation);
            proposal.setUserAgentImages(userAgents);
            proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
            proposals.add((ICompletionProposal)proposal);
            return proposal;
        }
        return null;
    }

    protected void addSymbolsInScope(Set<ICompletionProposal> proposals, int offset) {
        if (this.targetNode == null) {
            return;
        }
        JSScope globalScope = ParseUtil.getGlobalScope(this.targetNode);
        if (globalScope == null) {
            return;
        }
        JSScope localScope = globalScope.getScopeAtOffset(offset);
        String fileLocation = this.getFilename();
        String[] userAgentNames = this.getActiveUserAgentIds();
        while (localScope != null && localScope != globalScope) {
            List symbols = localScope.getLocalSymbolNames();
            for (String symbol : symbols) {
                boolean isFunction = false;
                JSPropertyCollection object = localScope.getLocalSymbol(symbol);
                List nodes = object.getValues();
                if (nodes != null) {
                    for (JSNode node : nodes) {
                        if (!(node instanceof JSFunctionNode)) continue;
                        isFunction = true;
                        break;
                    }
                }
                String name = symbol;
                String description = null;
                Image image = isFunction ? JS_FUNCTION : JS_PROPERTY;
                this.addProposal(proposals, name, image, description, userAgentNames, fileLocation, offset);
            }
            localScope = localScope.getParentScope();
        }
    }

    protected void addThisProperties(Set<ICompletionProposal> proposals, int offset) {
        List<JSFunctionNode> functionsToAnalyze;
        IParseNode activeNode = this.getActiveASTNode(offset);
        while (!(activeNode instanceof JSFunctionNode)) {
            if (!((activeNode = activeNode.getParent()) instanceof JSParseRootNode)) continue;
            return;
        }
        JSFunctionNode currentFunctionNode = (JSFunctionNode)activeNode;
        String functionName = this.getFunctionName(currentFunctionNode);
        if (functionName != null && (functionName = StringUtil.dotFirst((String)functionName).trim()).length() == 0) {
            functionName = null;
        }
        if (functionName == null) {
            functionsToAnalyze = Arrays.asList(currentFunctionNode);
        } else {
            IParseNode parent = currentFunctionNode.getParent();
            if (parent.getNodeType() == 1) {
                parent = parent.getParent();
            }
            IParseNode[] children = parent.getChildren();
            functionsToAnalyze = new LinkedList<JSFunctionNode>();
            int i = 0;
            while (i < children.length) {
                JSAssignmentNode assignmentNode;
                IParseNode rightHandSide;
                String childName = null;
                IParseNode childNode = children[i];
                JSFunctionNode jsFunctionNode = null;
                if (childNode instanceof JSFunctionNode) {
                    jsFunctionNode = (JSFunctionNode)childNode;
                    childName = jsFunctionNode.getNameNode().getName();
                } else if (childNode.getNodeType() == 1 && (rightHandSide = (assignmentNode = (JSAssignmentNode)childNode).getRightHandSide()) instanceof JSFunctionNode) {
                    jsFunctionNode = (JSFunctionNode)rightHandSide;
                    childName = this.getAssignmentLeftNodeName(assignmentNode);
                }
                if (childName != null && jsFunctionNode != null && StringUtil.dotFirst((String)childName).equals(functionName)) {
                    functionsToAnalyze.add(jsFunctionNode);
                }
                ++i;
            }
        }
        for (JSFunctionNode function : functionsToAnalyze) {
            JSScope globalScope;
            ThisAssignmentCollector collector = new ThisAssignmentCollector();
            ((JSNode)function.getBody()).accept((JSTreeWalker)collector);
            List assignments = collector.getAssignments();
            if (CollectionsUtil.isEmpty((Collection)assignments) || (globalScope = ParseUtil.getGlobalScope(this.targetNode)) == null) continue;
            JSScope localScope = globalScope.getScopeAtOffset(offset);
            Index index = this.getIndex();
            URI location = EditorUtil.getURI((IEditorPart)this.editor);
            String typeName = StringUtil.concat((String[])new String[]{String.valueOf(this.getNestedFunctionTypeName(function)) + "#" + "this"});
            for (JSAssignmentNode assignment : assignments) {
                IParseNode lhs = assignment.getLeftHandSide();
                IParseNode rhs = assignment.getRightHandSide();
                String name = lhs.getLastChild().getText();
                JSNodeTypeInferrer nodeInferrer = new JSNodeTypeInferrer(localScope, index, location, this.getQueryHelper());
                ((JSNode)rhs).accept((JSTreeWalker)nodeInferrer);
                List types = nodeInferrer.getTypes();
                PropertyElement property = new PropertyElement();
                property.setName(name);
                property.setHasAllUserAgents();
                if (!CollectionsUtil.isEmpty((Collection)types)) {
                    for (String type : types) {
                        property.addType(type);
                    }
                }
                this.addProposal(proposals, property, offset, this.getProjectURI(), typeName);
            }
        }
    }

    private String getFunctionName(JSFunctionNode currentFunctionNode) {
        String functionName = null;
        INameNode nameNode = currentFunctionNode.getNameNode();
        if (nameNode.getName().length() == 0) {
            IParseNode functionParent = currentFunctionNode.getParent();
            if (functionParent.getNodeType() == 1) {
                functionName = this.getAssignmentLeftNodeName((JSAssignmentNode)functionParent);
            }
        } else {
            functionName = nameNode.getName();
        }
        return functionName;
    }

    private String getAssignmentLeftNodeName(JSAssignmentNode assignmentNode) {
        IParseNode leftHandSide = assignmentNode.getLeftHandSide();
        if (leftHandSide.getNodeType() == 48) {
            return leftHandSide.toString();
        }
        return null;
    }

    protected void addTypeProperties(Set<ICompletionProposal> proposals, String typeName, int offset, boolean isInstance) {
        List allTypes = this.getQueryHelper().getTypeAncestorNames(typeName);
        allTypes.add(0, typeName);
        Collection properties = this.getQueryHelper().getTypeMembers(allTypes);
        URI projectURI = this.getProjectURI();
        List propertyFilters = CollectionsUtil.newList((Object[])new IFilter[]{isNotConstructorFilter, isVisibleFilter});
        IProject project = this.getProject();
        if (!this.hasSDKLessThanOrEqualToVersion(project, SDK_3_4_0)) {
            CollectionsUtil.addToList((List)propertyFilters, (Object[])new IFilter[]{isInstance ? isInstanceFilter : isStaticFilter});
        }
        IFilter[] filters = propertyFilters.toArray(new IFilter[propertyFilters.size()]);
        for (PropertyElement property : CollectionsUtil.filter((Collection)properties, (IFilter)new AndFilter(filters))) {
            this.addProposal(proposals, property, offset, projectURI, null);
        }
    }

    protected boolean hasSDKLessThanOrEqualToVersion(IProject project, String sdkVersion) {
        Set entries = this.getBuildPathManager().getBuildPaths(project);
        for (IBuildPathEntry entry : entries) {
            String projectSdk;
            URI indexPathUri = entry.getPath();
            IPath indexPath = Path.fromOSString((String)indexPathUri.getPath());
            String apiJSCA = indexPath.lastSegment();
            if (!API_JSCA.equals(apiJSCA) || VersionUtil.compareVersions((String)sdkVersion, (String)(projectSdk = (indexPath = indexPath.removeLastSegments(1)).lastSegment())) < 0) continue;
            return true;
        }
        return false;
    }

    protected BuildPathManager getBuildPathManager() {
        return BuildPathManager.getInstance();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        JSArgumentsNode node;
        this.textViewer = viewer;
        ArrayList<JSContextInformation> result = new ArrayList<JSContextInformation>(2);
        FunctionElement function = this.getFunctionElement(viewer, offset);
        if (function != null && (node = this.getArgumentsNode(offset)) != null) {
            boolean inObjectLiteral = false;
            for (IParseNode arg : node) {
                if (!arg.contains(offset)) continue;
                inObjectLiteral = arg instanceof JSObjectNode;
                break;
            }
            if (!inObjectLiteral) {
                JSContextInformation ci = new JSContextInformation(function, this.getProjectURI(), node.getStartingOffset());
                result.add(ci);
            }
        }
        return result.toArray(new IContextInformation[result.size()]);
    }

    ILexemeProvider<JSTokenType> createLexemeProvider(IDocument document, int offset) {
        JSFlexScanner scanner = new JSFlexScanner();
        JSFlexLexemeProvider result = this.activeRange != null ? new JSFlexLexemeProvider(document, this.activeRange, (Scanner)scanner) : (this.statementNode != null ? new JSFlexLexemeProvider(document, (IRange)this.statementNode, (Scanner)scanner) : new JSFlexLexemeProvider(document, offset, (Scanner)scanner));
        return result;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this.textViewer = viewer;
        LinkedHashSet<ICompletionProposal> result = new LinkedHashSet<ICompletionProposal>();
        IDocument document = viewer.getDocument();
        LocationType location = this.getLocationType(document, offset);
        switch (location) {
            case IN_PROPERTY_NAME: {
                this.addProperties(result, offset);
                break;
            }
            case IN_ARGUMENTS: 
            case IN_VARIABLE_NAME: {
                this.addFunctionArgumentProposals(result, viewer, offset);
            }
            case IN_GLOBAL: 
            case IN_CONSTRUCTOR: {
                this.addKeywords(result, offset);
                this.addGlobals(result, offset);
                this.addSymbolsInScope(result, offset);
                break;
            }
            case IN_OBJECT_LITERAL_PROPERTY: {
                this.addObjectLiteralProperties(result, viewer, offset);
                break;
            }
            case IN_THIS: {
                this.addThisProperties(result, offset);
                break;
            }
        }
        List<ICompletionProposal> filteredProposalList = this.getMergedProposals(new ArrayList<ICompletionProposal>(result));
        ICompletionProposal[] resultList = filteredProposalList.toArray(new ICompletionProposal[filteredProposalList.size()]);
        if (this.replaceRange != null) {
            try {
                String prefix = document.get(this.replaceRange.getStartingOffset(), this.replaceRange.getLength());
                this.setSelectedProposal(prefix, resultList);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return resultList;
    }

    private void addFunctionArgumentProposals(Set<ICompletionProposal> result, ITextViewer viewer, int offset) {
        ParameterElement param;
        List constants;
        FunctionElement function = this.getFunctionElement(viewer, offset);
        if (function == null) {
            return;
        }
        List params = function.getParameters();
        int index = this.getArgumentIndex(offset);
        if (index == -1) {
            index = 0;
        }
        if ("require".equals(function.getName())) {
            IProject project = EditorUtil.getProject((AbstractThemeableEditor)this.editor);
            URI editorURI = EditorUtil.getURI((IEditorPart)this.editor);
            IPath currentDirectory = Path.fromPortableString((String)editorURI.getPath()).removeLastSegments(1);
            List possible = RequireResolverFactory.getPossibleModuleIds((IProject)project, (IPath)currentDirectory, (IPath)project.getLocation());
            String[] userAgentIds = this.getActiveUserAgentIds();
            if (this.replaceRange == null) {
                this.replaceRange = new Range(offset);
            }
            for (String moduleId : possible) {
                CommonCompletionProposal proposal = this.addProposal(result, "'" + moduleId + "'", STRING_ICON, null, userAgentIds, String.valueOf(moduleId) + ".js", offset);
                if (proposal == null) continue;
                proposal.setRelevance(100);
            }
            return;
        }
        if (index >= 0 && index < params.size() && !CollectionsUtil.isEmpty((Collection)(constants = (param = (ParameterElement)params.get(index)).getConstants()))) {
            IProject project = this.getProject();
            String[] userAgentIds = this.getActiveUserAgentIds();
            Image[] userAgents = UserAgentManager.getInstance().getUserAgentImages(this.getProject(), userAgentIds);
            if (this.replaceRange == null) {
                this.replaceRange = new Range(offset);
            }
            for (String displayName : constants) {
                FunctionArgumentProposal proposal = new FunctionArgumentProposal(displayName, this.replaceRange.getStartingOffset(), this.replaceRange.getLength(), project);
                proposal.setUserAgentImages(userAgents);
                proposal.setTriggerCharacters(this.getProposalTriggerCharacters());
                result.add((ICompletionProposal)proposal);
            }
        }
    }

    protected JSIndexQueryHelper getQueryHelper() {
        if (this.indexHelper == null) {
            this.indexHelper = JSModelUtil.createQueryHelper(this.editor);
        }
        return this.indexHelper;
    }

    IParseNode getActiveASTNode(int offset) {
        IParseNode result = null;
        try {
            IDocument doc = this.getDocument();
            String source = this.activeRange != null ? doc.get(this.activeRange.getStartingOffset(), this.activeRange.getLength()) : doc.get();
            int startingOffset = this.activeRange != null ? this.activeRange.getStartingOffset() : 0;
            JSParseState parseState = new JSParseState(source, startingOffset, true, true);
            IParseRootNode ast = ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (IParseState)parseState).getRootNode();
            if (ast != null && (result = ast.getNodeAtOffset(offset)) == null) {
                if (offset < ast.getStartingOffset()) {
                    result = ast.getNodeAtOffset(ast.getStartingOffset());
                } else if (ast.getEndingOffset() < offset) {
                    result = ast.getNodeAtOffset(ast.getEndingOffset());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected IDocument getDocument() {
        return this.textViewer.getDocument();
    }

    private int getArgumentIndex(int offset) {
        JSArgumentsNode arguments = this.getArgumentsNode(offset);
        if (arguments != null) {
            for (IParseNode child : arguments) {
                if (!child.contains(offset)) continue;
                return child.getIndex();
            }
        }
        return -1;
    }

    private JSArgumentsNode getArgumentsNode(int offset) {
        IParseNode node = this.getActiveASTNode(offset);
        JSArgumentsNode result = null;
        while (node instanceof JSNode && node.getNodeType() != 61) {
            node = node.getParent();
        }
        if (node instanceof JSNode && node.getNodeType() == 61 && node.getStartingOffset() != offset) {
            result = (JSArgumentsNode)node;
        }
        return result;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new JSContextInformationValidator();
    }

    private FunctionElement getFunctionElement(ITextViewer viewer, int offset) {
        JSArgumentsNode node = this.getArgumentsNode(offset);
        if (node == null) {
            return null;
        }
        IRange range = this.replaceRange;
        int functionOffset = node.getStartingOffset();
        LocationType location = this.getLocationType(viewer.getDocument(), functionOffset);
        this.replaceRange = range;
        String typeName = null;
        String methodName = null;
        switch (location) {
            case IN_VARIABLE_NAME: {
                typeName = JSTypeUtil.getGlobalType((IProject)this.getProject(), (String)this.getFilename());
                methodName = node.getParent().getFirstChild().getText();
                break;
            }
            case IN_PROPERTY_NAME: {
                JSGetPropertyNode propertyNode = ParseUtil.getGetPropertyNode((IParseNode)node, node.getContainingStatementNode());
                List<String> types = this.getParentObjectTypes(propertyNode, offset);
                if (types.size() <= 0) break;
                typeName = types.get(0);
                methodName = propertyNode.getLastChild().getText();
                break;
            }
        }
        if (typeName != null && methodName != null) {
            JSIndexQueryHelper helper = this.getQueryHelper();
            return helper.findFunctionInHierarchy(typeName, methodName);
        }
        return null;
    }

    LocationType getLocationByLexeme(IDocument document, int offset) {
        LocationType result;
        block25: {
            ILexemeProvider<JSTokenType> lexemeProvider;
            block24: {
                int candidateIndex;
                Lexeme lexeme;
                lexemeProvider = this.createLexemeProvider(document, offset);
                result = LocationType.UNKNOWN;
                int index = lexemeProvider.getLexemeIndex(offset);
                if (index < 0 && (lexeme = lexemeProvider.getLexeme(candidateIndex = lexemeProvider.getLexemeFloorIndex(offset))) != null) {
                    if (lexeme.getEndingOffset() == offset) {
                        index = candidateIndex;
                    } else if (lexeme.getType() == JSTokenType.NEW) {
                        index = candidateIndex;
                    }
                }
                if (index < 0) break block24;
                Lexeme lexeme2 = lexemeProvider.getLexeme(index);
                block0 : switch ((JSTokenType)lexeme2.getType()) {
                    case DOT: {
                        result = LocationType.IN_PROPERTY_NAME;
                        break;
                    }
                    case SEMICOLON: {
                        Lexeme previousLexeme;
                        if (index > 0) {
                            previousLexeme = lexemeProvider.getLexeme(index - 1);
                            switch ((JSTokenType)previousLexeme.getType()) {
                                case IDENTIFIER: {
                                    result = LocationType.IN_GLOBAL;
                                    break block0;
                                }
                            }
                            break;
                        }
                        break block25;
                    }
                    case LPAREN: {
                        Lexeme previousLexeme;
                        if (offset == lexeme2.getEndingOffset() && (previousLexeme = lexemeProvider.getLexeme(index - 1)).getType() != JSTokenType.IDENTIFIER) {
                            result = LocationType.IN_GLOBAL;
                            break;
                        }
                        break block25;
                    }
                    case RPAREN: {
                        if (offset == lexeme2.getStartingOffset()) {
                            result = LocationType.IN_GLOBAL;
                            break;
                        }
                        break block25;
                    }
                    case IDENTIFIER: {
                        Lexeme previousLexeme;
                        if (index > 0) {
                            previousLexeme = lexemeProvider.getLexeme(index - 1);
                            switch ((JSTokenType)previousLexeme.getType()) {
                                case DOT: {
                                    result = LocationType.IN_PROPERTY_NAME;
                                    break block0;
                                }
                                case NEW: {
                                    result = LocationType.IN_CONSTRUCTOR;
                                    break block0;
                                }
                                case VAR: {
                                    result = LocationType.IN_VARIABLE_DECLARATION;
                                    break block0;
                                }
                            }
                            result = LocationType.IN_VARIABLE_NAME;
                            break;
                        }
                        result = LocationType.IN_VARIABLE_NAME;
                        break;
                    }
                }
                break block25;
            }
            if (lexemeProvider.size() == 0) {
                result = LocationType.IN_GLOBAL;
            }
        }
        return result;
    }

    LocationType getLocationType(IDocument document, int offset) {
        JSLocationIdentifier identifier = new JSLocationIdentifier(offset, this.getActiveASTNode(offset - 1));
        LocationType result = identifier.getType();
        this.targetNode = identifier.getTargetNode();
        this.statementNode = identifier.getStatementNode();
        this.replaceRange = identifier.getReplaceRange();
        if (result == LocationType.UNKNOWN) {
            result = this.getLocationByLexeme(document, offset);
        }
        return result;
    }

    protected List<ICompletionProposal> getMergedProposals(List<ICompletionProposal> proposals) {
        return CollectionsUtil.filter(proposals, (IFilter)new ProposalMerger());
    }

    private String getNestedFunctionTypeName(JSFunctionNode function) {
        ArrayList<String> names = new ArrayList<String>();
        JSFunctionNode current = function;
        while (current != null && !(current instanceof JSParseRootNode)) {
            if (current instanceof JSFunctionNode) {
                JSFunctionNode currentFunction = current;
                names.add(currentFunction.getName().getText());
            }
            current = current.getParent();
        }
        Collections.reverse(names);
        return StringUtil.join((String)"#", names);
    }

    protected List<String> getParentObjectTypes(JSGetPropertyNode node, int offset) {
        return ParseUtil.getReceiverTypeNames(this.getQueryHelper(), this.getIndex(), this.getURI(), this.targetNode, node, offset);
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.js";
    }

    IRange getReplaceRange() {
        return this.replaceRange;
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return Character.isWhitespace(c);
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        boolean result;
        block6: {
            result = false;
            try {
                ITypedRegion partition = document.getPartition(offset);
                if (partition == null || !AUTO_ACTIVATION_PARTITION_TYPES.contains(partition.getType())) break block6;
                int start = partition.getOffset();
                int index = offset - 1;
                while (index >= start) {
                    char candidate = document.getChar(index);
                    if (candidate == ',' || candidate == '(' || candidate == '{') {
                        result = true;
                    } else if (Character.isWhitespace(candidate)) {
                        --index;
                        continue;
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c) || c == '$';
    }

    public void setActiveRange(IRange activeRange) {
        this.activeRange = activeRange;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProposalMerger
    implements IFilter<ICompletionProposal> {
        private ICompletionProposal lastProposal = null;

        public boolean include(ICompletionProposal item) {
            boolean result;
            if (this.lastProposal == null || !this.lastProposal.getDisplayString().equals(item.getDisplayString())) {
                result = true;
                this.lastProposal = item;
            } else {
                result = false;
            }
            return result;
        }
    }
}

