/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.hover.TagStripperAndTypeBolder;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.Messages;
import com.aptana.js.core.model.BaseElement;
import com.aptana.js.core.model.FunctionElement;
import com.aptana.js.core.model.ParameterElement;
import com.aptana.js.core.model.PropertyElement;
import com.aptana.js.core.model.SinceElement;
import com.aptana.js.core.model.TypeElement;
import com.aptana.js.core.model.UserAgentElement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSModelFormatter {
    private static final String COLON_SPACE = ": ";
    private static final String COMMA_SPACE = ", ";
    private static final String HTML_NEWLINE = "<br>";
    private static final Map<String, Image> TYPE_IMAGE_MAP;
    private static final Image PROPERTY;
    private static final String PROTOTYPE_PROPERTY = ".prototype";
    private static final ImageDescriptor STATIC_OVERLAY;
    private static final ImageDescriptor DEPRECATED_OVERLAY;
    public static final JSModelFormatter LABEL;
    public static final JSModelFormatter ADDITIONAL_INFO;
    public static final JSModelFormatter TEXT_HOVER;
    public static final JSModelFormatter DYNAMIC_HELP;
    public static final JSModelFormatter CONTEXT_INFO;
    private List<Section> fSections;
    private boolean useHTML;

    static {
        PROPERTY = JSPlugin.getImage("/icons/js_property.png");
        STATIC_OVERLAY = JSPlugin.getImageDescriptor("icons/overlays/static.png");
        DEPRECATED_OVERLAY = JSPlugin.getImageDescriptor("icons/overlays/deprecated.gif");
        TYPE_IMAGE_MAP = new HashMap<String, Image>();
        TYPE_IMAGE_MAP.put("Array", JSPlugin.getImage("/icons/array-literal.png"));
        TYPE_IMAGE_MAP.put("Boolean", JSPlugin.getImage("/icons/boolean.png"));
        TYPE_IMAGE_MAP.put("Function", JSPlugin.getImage("/icons/js_function.png"));
        TYPE_IMAGE_MAP.put("null", JSPlugin.getImage("/icons/null.png"));
        TYPE_IMAGE_MAP.put("Number", JSPlugin.getImage("/icons/number.png"));
        TYPE_IMAGE_MAP.put("Object", JSPlugin.getImage("/icons/object-literal.png"));
        TYPE_IMAGE_MAP.put("RegExp", JSPlugin.getImage("/icons/regex.png"));
        TYPE_IMAGE_MAP.put("String", JSPlugin.getImage("/icons/string.png"));
        LABEL = new JSModelFormatter(false, Section.SIGNATURE);
        ADDITIONAL_INFO = new JSModelFormatter(true, Section.SIGNATURE, Section.DESCRIPTION, Section.PLATFORMS);
        TEXT_HOVER = new JSModelFormatter(true, Section.SIGNATURE, Section.LOCATIONS, Section.DESCRIPTION, Section.PLATFORMS, Section.EXAMPLE, Section.SPECIFICATIONS);
        DYNAMIC_HELP = new JSModelFormatter(true, Section.DESCRIPTION, Section.PARAMETERS, Section.RETURNS, Section.EXAMPLES, Section.PLATFORMS, Section.SPECIFICATIONS);
        CONTEXT_INFO = new JSModelFormatter(false, new Section[]{Section.SIGNATURE}){
            private static final String BULLET = "\u2022";
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String getDocumentation(Collection<? extends BaseElement> properties) {
                if (CollectionsUtil.isEmpty(properties)) {
                    return null;
                }
                BaseElement prop = properties.iterator().next();
                if (prop instanceof FunctionElement) {
                    FunctionElement function = (FunctionElement)prop;
                    ArrayList<String> result = new ArrayList<String>();
                    result.add(this.getHeader((BaseElement)function, null));
                    ArrayList buffer = new ArrayList();
                    for (ParameterElement parameter : function.getParameters()) {
                        buffer.clear();
                        CollectionsUtil.addToList(buffer, (Object[])new String[]{" ", BULLET, "\t", parameter.getName()});
                        String description = parameter.getDescription();
                        if (!StringUtil.isEmpty((String)description)) {
                            description = this.stripAndBold.searchAndReplace(description);
                            CollectionsUtil.addToList(buffer, (Object[])new String[]{":", FileUtil.NEW_LINE, " \t", description});
                        }
                        result.add(StringUtil.concat(buffer));
                    }
                    return StringUtil.join((String)(String.valueOf(FileUtil.NEW_LINE) + "\ufeff"), result);
                }
                return null;
            }
        };
    }

    private JSModelFormatter(boolean useHTML, Section ... sectionsToDisplay) {
        this.fSections = Arrays.asList(sectionsToDisplay);
        this.useHTML = useHTML;
        for (Section s : this.fSections) {
            s.useHTML = useHTML;
        }
    }

    public String getDescription(BaseElement property, URI projectURI) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getHeader(property, projectURI));
        String docs = this.getDocumentation(property);
        if (!StringUtil.isEmpty((String)docs)) {
            buffer.append(this.newline());
            buffer.append(docs);
        }
        return buffer.toString();
    }

    public String getHeader(BaseElement property, URI root) {
        return this.getHeader(CollectionsUtil.newList((Object[])new BaseElement[]{property}), root);
    }

    public String getHeader(final Collection<? extends BaseElement> properties, URI root) {
        if (CollectionsUtil.isEmpty(properties)) {
            return "";
        }
        ArrayList<String> stringParts = new ArrayList<String>();
        if (this.useHTML) {
            stringParts.add("<b>");
        }
        List headerSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section item) {
                return item.isHeader();
            }
        });
        stringParts.addAll(CollectionsUtil.map((Collection)headerSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(properties, null);
            }
        }));
        if (this.useHTML) {
            stringParts.add("</b>");
        }
        return StringUtil.concat(stringParts);
    }

    public String getDocumentation(BaseElement property) {
        return this.getDocumentation(CollectionsUtil.newList((Object[])new BaseElement[]{property}));
    }

    public String getDocumentation(final Collection<? extends BaseElement> properties) {
        List docSections = CollectionsUtil.filter(this.fSections, (IFilter)new IFilter<Section>(){

            public boolean include(Section s) {
                return !s.isHeader();
            }
        });
        List sectionStrings = CollectionsUtil.map((Collection)docSections, (IMap)new IMap<Section, String>(){

            public String map(Section s) {
                return s.generate(properties, null);
            }
        });
        return StringUtil.concat((Collection)sectionStrings);
    }

    public Image getImage(PropertyElement property) {
        String key = "property";
        Image result = PROPERTY;
        if (property instanceof FunctionElement) {
            key = "function";
            result = TYPE_IMAGE_MAP.get("Function");
        }
        if (property != null) {
            List types = property.getTypeNames();
            if (types != null && types.size() == 1) {
                String type = (String)types.get(0);
                if (TYPE_IMAGE_MAP.containsKey(type)) {
                    result = TYPE_IMAGE_MAP.get(type);
                    key = type;
                } else if (type.startsWith("-dynamic-type-")) {
                    result = TYPE_IMAGE_MAP.get("Object");
                    key = "object";
                } else if (type.startsWith("Function")) {
                    result = TYPE_IMAGE_MAP.get("Function");
                    key = "function";
                } else if (type.endsWith("[]")) {
                    result = TYPE_IMAGE_MAP.get("Array");
                    key = "array";
                }
            }
            if (property.isClassProperty()) {
                key = String.valueOf(key) + ".static";
                result = this.addOverlay(result, STATIC_OVERLAY, 1, key);
            }
            if (property.isDeprecated()) {
                key = String.valueOf(key) + ".deprecated";
                result = this.addOverlay(result, DEPRECATED_OVERLAY, 0, key);
            }
        }
        return result;
    }

    private Image addOverlay(Image base, ImageDescriptor overlay, int location, String key) {
        ImageRegistry reg = this.getImageRegistry();
        Image cached = reg.get(key);
        if (cached != null) {
            return cached;
        }
        DecorationOverlayIcon decorator = new DecorationOverlayIcon(base, overlay, location);
        Image result = decorator.createImage();
        reg.put(key, result);
        return result;
    }

    protected ImageRegistry getImageRegistry() {
        return JSPlugin.getDefault().getImageRegistry();
    }

    public static String getTypeDisplayName(String type) {
        String result = null;
        if (type != null) {
            result = type.startsWith("Class<") && type.endsWith(">") ? type.substring("Class<".length(), type.length() - 1) : (type.startsWith("-dynamic-type-") ? "UserType" : (type.startsWith("Function<") && type.endsWith(">") ? type.substring("Function<".length(), type.length() - 1) : (type.endsWith(PROTOTYPE_PROPERTY) ? type.substring(0, type.length() - PROTOTYPE_PROPERTY.length()) : type)));
        }
        return result;
    }

    protected String newline() {
        return this.useHTML ? HTML_NEWLINE : FileUtil.NEW_LINE;
    }

    /* synthetic */ JSModelFormatter(boolean bl, Section[] sectionArray, JSModelFormatter jSModelFormatter) {
        this(bl, sectionArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Section {
        protected boolean useHTML;
        static final Section SIGNATURE = new Section(){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                BaseElement base = properties.iterator().next();
                ArrayList<String> builder = new ArrayList<String>();
                builder.add(base.getName());
                if (base instanceof PropertyElement) {
                    PropertyElement prop = (PropertyElement)base;
                    List typeNames = prop.getTypeNames();
                    if (prop instanceof FunctionElement) {
                        FunctionElement fe = (FunctionElement)prop;
                        builder.add("(");
                        builder.add(this.formatParameters(fe.getParameters()));
                        builder.add(")");
                        typeNames = fe.getReturnTypeNames();
                    }
                    builder.add(JSModelFormatter.COLON_SPACE);
                    builder.add(this.formatTypes(typeNames));
                }
                return StringUtil.concat(builder);
            }

            private String formatParameters(Collection<ParameterElement> parameters) {
                List strings = CollectionsUtil.map(parameters, (IMap)new IMap<ParameterElement, String>(){

                    public String map(ParameterElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        List types = item.getTypes();
                        if (!CollectionsUtil.isEmpty((Collection)types)) {
                            b.append(JSModelFormatter.COLON_SPACE).append(JSModelFormatter.getTypeDisplayName((String)types.get(0)));
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };
        static final Section LOCATIONS = new Section(){

            @Override
            public boolean isHeader() {
                return true;
            }

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                LinkedHashSet documents = new LinkedHashSet();
                for (BaseElement baseElement : properties) {
                    documents.addAll(baseElement.getDocuments());
                }
                if (!documents.isEmpty()) {
                    ArrayList<String> arrayList = new ArrayList<String>(3);
                    String first = (String)documents.iterator().next();
                    if (root != null) {
                        try {
                            first = root.relativize(new URI(first)).getPath();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    arrayList.add(" - ");
                    arrayList.add(first);
                    if (documents.size() > 1) {
                        arrayList.add(", ...");
                    }
                    return StringUtil.concat(arrayList);
                }
                return "";
            }
        };
        static final Section EXAMPLE = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                String example = this.getFirstExample(properties);
                return this.addSection(Messages.JSTextHover_Example, example);
            }

            private String getFirstExample(Collection<? extends BaseElement> properties) {
                for (BaseElement baseElement : properties) {
                    List<String> examples = 3.getExamples(baseElement);
                    for (String example : examples) {
                        if (StringUtil.isEmpty((String)example)) continue;
                        return example;
                    }
                }
                return "";
            }
        };
        static final Section EXAMPLES = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                List examples = new ArrayList<String>();
                for (BaseElement baseElement : properties) {
                    examples.addAll(4.getExamples(baseElement));
                }
                if ((examples = CollectionsUtil.filter(examples, (IFilter)new IFilter<String>(){

                    public boolean include(String item) {
                        return !StringUtil.isEmpty((String)item);
                    }
                })).size() == 1) {
                    return this.addSection(Messages.JSTextHover_Example, (String)examples.get(0));
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                int i = 0;
                while (i < examples.size()) {
                    arrayList.add(this.addSection(String.valueOf(Messages.JSTextHover_Example) + " " + (i + 1), (String)examples.get(i)));
                    ++i;
                }
                return StringUtil.concat(arrayList);
            }
        };
        static final Section SPECIFICATIONS = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                HashSet<SinceElement> sinceElements = new HashSet<SinceElement>();
                for (BaseElement baseElement : properties) {
                    sinceElements.addAll(baseElement.getSinceList());
                }
                return this.addSection(Messages.JSTextHover_Specification, this.getSpecificationsString(sinceElements));
            }

            private String getSpecificationsString(Collection<SinceElement> sinceElements) {
                List strings = CollectionsUtil.map(sinceElements, (IMap)new IMap<SinceElement, String>(){

                    public String map(SinceElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getName());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(JSModelFormatter.COLON_SPACE).append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };
        static final Section DESCRIPTION = new Section(){
            private TagStripperAndTypeBolder stripAndBold = new TagStripperAndTypeBolder();

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                HashSet<String> descriptions = new HashSet<String>();
                for (BaseElement baseElement : properties) {
                    this.stripAndBold.setUseHTML(this.useHTML);
                    String desc = baseElement.getDescription();
                    if (baseElement.isDeprecated()) {
                        desc = "<b>Deprecated</b><br>" + desc;
                    }
                    if (StringUtil.isEmpty((String)(desc = this.stripAndBold.searchAndReplace(desc)))) continue;
                    descriptions.add(desc);
                }
                if (CollectionsUtil.isEmpty(descriptions)) {
                    return Messages.JSTextHover_NoDescription;
                }
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, descriptions);
            }
        };
        static final Section PLATFORMS = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                HashSet<UserAgentElement> userAgents = new HashSet<UserAgentElement>();
                for (BaseElement baseElement : properties) {
                    userAgents.addAll(baseElement.getUserAgents());
                }
                return this.addSection(Messages.JSTextHover_SupportedPlatforms, this.getPlatforms(userAgents));
            }

            private String getPlatforms(Collection<UserAgentElement> userAgents) {
                List strings = CollectionsUtil.map(userAgents, (IMap)new IMap<UserAgentElement, String>(){

                    public String map(UserAgentElement item) {
                        StringBuilder b = new StringBuilder();
                        b.append(item.getPlatform());
                        String version = item.getVersion();
                        if (!StringUtil.isEmpty((String)version)) {
                            b.append(JSModelFormatter.COLON_SPACE).append(version);
                        }
                        return b.toString();
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };
        static final Section RETURNS = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                List<String> returnTypeNames = new ArrayList<String>();
                for (BaseElement baseElement : properties) {
                    if (!(baseElement instanceof FunctionElement)) continue;
                    FunctionElement function = (FunctionElement)baseElement;
                    returnTypeNames = function.getReturnTypeNames();
                }
                return this.addSection(Messages.JSModelFormatter_Returns, this.formatTypes(returnTypeNames));
            }
        };
        static final Section PARAMETERS = new Section(){

            @Override
            public String generate(Collection<? extends BaseElement> properties, URI root) {
                List<Object> parameters = new ArrayList<ParameterElement>();
                for (BaseElement baseElement : properties) {
                    if (!(baseElement instanceof FunctionElement)) continue;
                    FunctionElement function = (FunctionElement)baseElement;
                    parameters = function.getParameters();
                }
                return this.addSection(Messages.JSModelFormatter_Parameters, this.getLongformParameters(parameters));
            }

            private String getLongformParameters(List<ParameterElement> parameters) {
                List strings = CollectionsUtil.map(parameters, (IMap)new IMap<ParameterElement, String>(){

                    public String map(ParameterElement item) {
                        String desc;
                        ArrayList<String> b = new ArrayList<String>();
                        b.add(item.getName());
                        List types = item.getTypes();
                        if (!CollectionsUtil.isEmpty((Collection)types)) {
                            b.add(" (");
                            b.add(JSModelFormatter.getTypeDisplayName((String)types.get(0)));
                            b.add(")");
                        }
                        if (!StringUtil.isEmpty((String)(desc = item.getDescription()))) {
                            b.add(JSModelFormatter.COLON_SPACE);
                            b.add(desc);
                        }
                        return StringUtil.concat(b);
                    }
                });
                return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)strings);
            }
        };

        private Section() {
        }

        public boolean isHeader() {
            return false;
        }

        private String newline() {
            return this.useHTML ? JSModelFormatter.HTML_NEWLINE : FileUtil.NEW_LINE;
        }

        protected String addSection(String title, String value) {
            StringBuilder builder = new StringBuilder();
            if (!StringUtil.isEmpty((String)value)) {
                builder.append(this.newline()).append(this.newline());
                if (this.useHTML) {
                    builder.append("<b>");
                }
                builder.append(title);
                if (this.useHTML) {
                    builder.append("</b>");
                }
                builder.append(this.newline());
                builder.append(value.trim());
            }
            return builder.toString();
        }

        public abstract String generate(Collection<? extends BaseElement> var1, URI var2);

        protected String formatTypes(List<String> typeNames) {
            if (CollectionsUtil.isEmpty(typeNames)) {
                return "none";
            }
            List typeDisplayNames = CollectionsUtil.map(typeNames, (IMap)new IMap<String, String>(){

                public String map(String type) {
                    return JSModelFormatter.getTypeDisplayName(type);
                }
            });
            return StringUtil.join((String)JSModelFormatter.COMMA_SPACE, (Collection)typeDisplayNames);
        }

        protected static List<String> getExamples(BaseElement prop) {
            if (prop instanceof TypeElement) {
                TypeElement te = (TypeElement)prop;
                return te.getExamples();
            }
            if (prop instanceof PropertyElement) {
                PropertyElement pe = (PropertyElement)prop;
                return pe.getExamples();
            }
            return Collections.emptyList();
        }
    }
}

