/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSNameValuePairNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSStringNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;

public class JSRangeFinder
extends JSTreeWalker {
    private int _offset;
    private IRange _range;

    public JSRangeFinder(int offset) {
        this._offset = offset - 1;
        this._range = new Range(offset, offset - 1);
    }

    public IRange getRange() {
        return this._range;
    }

    private void setRange(int startingOffset, int endingOffset) {
        this._range = new Range(startingOffset, endingOffset);
    }

    private void setRange(IParseNode node) {
        if (node instanceof JSNode) {
            ((JSNode)node).accept((JSTreeWalker)this);
        }
    }

    public void visit(JSIdentifierNode node) {
        if (node.contains(this._offset)) {
            this.setRange(node.getStart(), this._offset);
        }
    }

    public void visit(JSNameValuePairNode node) {
        if (node.contains(this._offset)) {
            IParseNode name = node.getName();
            IParseNode value = node.getValue();
            if (name.contains(this._offset) || name.getEndingOffset() == this._offset) {
                this.setRange(name);
            } else if (value.contains(this._offset)) {
                this.setRange(value);
            }
        }
    }

    public void visit(JSParseRootNode node) {
        if (node.contains(this._offset)) {
            for (IParseNode child : node) {
                if (!child.contains(this._offset)) continue;
                this.setRange(child);
                break;
            }
        }
    }

    public void visit(JSStringNode node) {
        if (node.contains(this._offset)) {
            this.setRange(node.getStart() + 1, this._offset - 1);
        }
    }

    protected void visitChildren(JSNode node) {
        if (node.contains(this._offset)) {
            for (IParseNode child : node) {
                if (!child.contains(this._offset)) continue;
                this.setRange(child);
                break;
            }
        }
    }
}

