/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.contentassist;

import beaver.Scanner;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.text.JSFlexLexemeProvider;
import com.aptana.index.core.Index;
import com.aptana.js.core.JSTypeConstants;
import com.aptana.js.core.index.JSIndexQueryHelper;
import com.aptana.js.core.inferencing.JSNodeTypeInferrer;
import com.aptana.js.core.inferencing.JSScope;
import com.aptana.js.core.inferencing.JSTypeMapper;
import com.aptana.js.core.parsing.JSFlexScanner;
import com.aptana.js.core.parsing.JSTokenType;
import com.aptana.js.core.parsing.ast.JSGetPropertyNode;
import com.aptana.js.core.parsing.ast.JSIdentifierNode;
import com.aptana.js.core.parsing.ast.JSNode;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.Lexeme;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUtil {
    public static List<String> getFunctionParameters(IDocument document, int offset) {
        return new FunctionParameterParser(document, offset).getFunctionParameters();
    }

    public static JSGetPropertyNode getGetPropertyNode(IParseNode targetNode, IParseNode statementNode) {
        JSGetPropertyNode propertyNode = null;
        if (targetNode != null) {
            if (targetNode.getNodeType() == 48) {
                propertyNode = (JSGetPropertyNode)targetNode;
            } else if (targetNode.getNodeType() == 61) {
                IParseNode candidate = targetNode.getParent().getFirstChild();
                if (candidate instanceof JSGetPropertyNode) {
                    propertyNode = (JSGetPropertyNode)candidate;
                }
            } else {
                IParseNode parentNode = targetNode.getParent();
                if (parentNode != null && parentNode.getNodeType() == 48) {
                    propertyNode = (JSGetPropertyNode)parentNode;
                }
            }
        }
        if (propertyNode == null && statementNode != null) {
            if (statementNode.getNodeType() == 48) {
                propertyNode = (JSGetPropertyNode)statementNode;
            } else {
                IParseNode child = statementNode.getFirstChild();
                if (child != null && child.getNodeType() == 48) {
                    propertyNode = (JSGetPropertyNode)child;
                }
            }
        }
        return propertyNode;
    }

    public static JSScope getGlobalScope(IParseNode node) {
        JSScope result = null;
        if (node != null) {
            IParseNode root = node;
            while (root != null) {
                if (root instanceof JSParseRootNode) {
                    result = ((JSParseRootNode)root).getGlobals();
                    break;
                }
                root = root.getParent();
            }
        }
        return result;
    }

    public static List<String> getReceiverTypeNames(JSIndexQueryHelper queryHelper, Index projectIndex, URI fileURI, IParseNode targetNode, JSGetPropertyNode getPropertyNode, int offset) {
        JSScope localScope;
        ArrayList<String> result = new ArrayList<String>();
        if (getPropertyNode != null && (localScope = ParseUtil.getScopeAtOffset(targetNode, offset)) != null) {
            List typeList = Collections.emptyList();
            IParseNode lhs = getPropertyNode.getLeftHandSide();
            if (lhs instanceof JSNode) {
                JSNodeTypeInferrer typeWalker = new JSNodeTypeInferrer(localScope, projectIndex, fileURI, queryHelper);
                typeWalker.visit((JSNode)lhs);
                typeList = typeWalker.getTypes();
            }
            IdeLog.logInfo((Plugin)JSPlugin.getDefault(), (String)("types: " + StringUtil.join((String)", ", typeList)), (String)"com.aptana.editor.js/debug/show_content_assist_types");
            for (String type : typeList) {
                type = JSTypeMapper.getInstance().getMappedType(type);
                if (JSTypeConstants.FUNCTION_JQUERY.equals(type) && lhs instanceof JSIdentifierNode && ("$".equals(lhs.getText()) || "jQuery".equals(lhs.getText()))) {
                    result.add(JSTypeConstants.CLASS_JQUERY);
                    continue;
                }
                result.add(type);
            }
        }
        return result;
    }

    public static JSScope getScopeAtOffset(IParseNode node, int offset) {
        JSScope result = null;
        JSScope global = ParseUtil.getGlobalScope(node);
        if (global != null) {
            JSScope candidate = global.getScopeAtOffset(offset);
            result = candidate != null ? candidate : global;
        }
        return result;
    }

    private ParseUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionParameterParser {
        private final IDocument document;
        private final int offset;
        private ArrayList<String> parameters;
        private JSFlexLexemeProvider lexemeProvider;
        private Lexeme<JSTokenType> currentLexeme;
        private int lexemeIndex;

        public FunctionParameterParser(IDocument document, int offset) {
            this.document = document;
            this.offset = offset;
        }

        private void advance() {
            this.currentLexeme = this.lexemeIndex < this.lexemeProvider.size() ? this.lexemeProvider.getLexeme(this.lexemeIndex++) : null;
        }

        private boolean advanceIfType(JSTokenType type) {
            boolean result = this.isType(type);
            if (result) {
                this.advance();
            }
            return result;
        }

        private void extractParameters() throws Exception {
            if (this.currentLexeme != null) {
                switch ((JSTokenType)this.currentLexeme.getType()) {
                    case LPAREN: {
                        this.parseSelfInvokingLambda();
                        break;
                    }
                    case FUNCTION: {
                        this.parseFunctionDeclaration();
                        break;
                    }
                    case VAR: {
                        this.parseVarDeclaration();
                        break;
                    }
                    case IDENTIFIER: {
                        this.parseIdentifier();
                        break;
                    }
                    case STRING: {
                        this.parseString();
                    }
                }
            }
        }

        public List<String> getFunctionParameters() {
            this.parameters = new ArrayList();
            this.lexemeProvider = new JSFlexLexemeProvider(this.document, this.offset, (Scanner)new JSFlexScanner());
            this.lexemeIndex = this.lexemeProvider.getLexemeCeilingIndex(this.offset);
            this.advance();
            try {
                this.extractParameters();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.parameters.trimToSize();
            return this.parameters;
        }

        private boolean isType(JSTokenType type) {
            return this.currentLexeme != null && this.currentLexeme.getType() == type;
        }

        private void parseFunctionDeclaration() throws Exception {
            this.testAndAdvance(JSTokenType.FUNCTION);
            this.advanceIfType(JSTokenType.IDENTIFIER);
            if (this.advanceIfType(JSTokenType.LPAREN)) {
                while (this.isType(JSTokenType.IDENTIFIER)) {
                    this.parameters.add(this.currentLexeme.getText());
                    this.advance();
                    if (this.advanceIfType(JSTokenType.COMMA)) continue;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void parseIdentifier() throws Exception {
            block2: {
                this.testAndAdvance(JSTokenType.IDENTIFIER);
                if (!this.advanceIfType(JSTokenType.COLON)) ** GOTO lbl-1000
                this.parseFunctionDeclaration();
                break block2;
                while (this.advanceIfType(JSTokenType.IDENTIFIER)) lbl-1000:
                // 2 sources

                {
                    if (this.advanceIfType(JSTokenType.DOT)) continue;
                }
                if (this.advanceIfType(JSTokenType.EQUAL)) {
                    this.parseFunctionDeclaration();
                }
            }
        }

        private void parseString() throws Exception {
            this.testAndAdvance(JSTokenType.STRING);
            if (this.advanceIfType(JSTokenType.COLON)) {
                this.parseFunctionDeclaration();
            }
        }

        private void parseSelfInvokingLambda() throws Exception {
            this.testAndAdvance(JSTokenType.LPAREN);
            this.parseFunctionDeclaration();
        }

        private void parseVarDeclaration() throws Exception {
            this.testAndAdvance(JSTokenType.VAR);
            while (this.advanceIfType(JSTokenType.IDENTIFIER)) {
                this.advanceIfType(JSTokenType.COMMA);
            }
            if (this.advanceIfType(JSTokenType.EQUAL)) {
                this.parseFunctionDeclaration();
            }
        }

        private void testAndAdvance(JSTokenType type) throws Exception {
            if (!this.advanceIfType(type)) {
                String message = MessageFormat.format("Parser error: Expected {0} but encountered {1}", type, this.currentLexeme != null ? (JSTokenType)this.currentLexeme.getType() : JSTokenType.EOF);
                throw new Exception(message);
            }
        }
    }
}

