/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.preferences;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.preferences.Messages;
import com.aptana.js.core.JSCorePlugin;
import com.aptana.js.core.node.INodeJS;
import com.aptana.js.core.node.INodeJSService;
import com.aptana.ui.util.UIUtils;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class NodePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String NODE_JS_SOURCE_URL = "http://go.appcelerator.com/nodejs-source";
    public static final String NODE_JS_ROOT_NAME = "node-v0.8.3";
    public static final String ID = "com.aptana.editor.js.nodejs.page";
    private StringFieldEditor sfe;
    private Composite fep;
    private DirectoryFieldEditor sourceEditor;

    public NodePreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        FileFieldEditor fileEditor = new FileFieldEditor("nodejs_path", StringUtil.makeFormLabel((String)Messages.NodePreferencePage_LocationLabel), true, 0, this.getFieldEditorParent()){

            protected boolean doCheckState() {
                IStatus status;
                String text = this.getTextControl().getText();
                if (!StringUtil.isEmpty((String)text) && !(status = NodePreferencePage.this.getNodeService().acceptBinary(Path.fromOSString((String)text))).isOK()) {
                    this.setErrorMessage(status.getMessage());
                    return false;
                }
                return true;
            }
        };
        this.addField((FieldEditor)fileEditor);
        this.fep = this.getFieldEditorParent();
        this.sfe = new StringFieldEditor("some_non_existent_pref_key", StringUtil.makeFormLabel((String)Messages.NodePreferencePage_DetectedPathLabel), this.fep);
        this.addField((FieldEditor)this.sfe);
        this.sourceEditor = new DirectoryFieldEditor("nodejs_source_path", StringUtil.makeFormLabel((String)Messages.NodePreferencePage_SourceLocationLabel), this.getFieldEditorParent()){

            public int getNumberOfControls() {
                return super.getNumberOfControls() + 1;
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns - 1);
                this.createDownloadButton(parent);
                Text textControl = this.getTextControl();
                ((GridData)textControl.getLayoutData()).widthHint = this.convertHorizontalDLUsToPixels((Control)textControl, 180);
            }

            protected void adjustForNumColumns(int numColumns) {
                super.adjustForNumColumns(numColumns - 1);
            }

            protected boolean doCheckState() {
                String text = this.getTextControl().getText();
                if (!StringUtil.isEmpty((String)text)) {
                    IPath path = Path.fromOSString((String)text);
                    IStatus status = NodePreferencePage.this.getNodeService().validateSourcePath(path);
                    if (!status.isOK()) {
                        this.setErrorMessage(status.getMessage());
                        return false;
                    }
                }
                return true;
            }

            private Button createDownloadButton(Composite parent) {
                Button downloadBt = new Button(parent, 8);
                downloadBt.setText(Messages.NodePreferencePage_downloadButtonText);
                downloadBt.setFont(parent.getFont());
                GridData gd = GridDataFactory.fillDefaults().create();
                int widthHint = this.convertHorizontalDLUsToPixels((Control)downloadBt, 61);
                gd.widthHint = Math.max(widthHint, downloadBt.computeSize((int)-1, (int)-1, (boolean)true).x);
                downloadBt.setLayoutData((Object)gd);
                downloadBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        NodePreferencePage.this.downloadNodeJS();
                    }
                });
                return downloadBt;
            }
        };
        this.addField((FieldEditor)this.sourceEditor);
    }

    private void downloadNodeJS() {
        ProgressMonitorDialog downloadProgressMonitor = new ProgressMonitorDialog(UIUtils.getActiveShell());
        try {
            downloadProgressMonitor.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        Control control;
                        final INodeJS node = NodePreferencePage.this.getDetectedPath();
                        IStatus status = node.downloadSource(monitor);
                        if (status.isOK() && (control = NodePreferencePage.this.getControl()) != null && !control.isDisposed()) {
                            UIUtils.runInUIThread((Runnable)new Runnable(){

                                public void run() {
                                    NodePreferencePage.this.sourceEditor.setStringValue(node.getSourcePath().toOSString());
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)JSPlugin.getDefault(), (String)"Error while downloading NodeJS sources", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void initialize() {
        super.initialize();
        INodeJS path = this.getDetectedPath();
        this.sfe.setStringValue(path == null ? Messages.NodePreferencePage_NotDetected : path.getPath().toOSString());
        this.sfe.setEnabled(false, this.fep);
    }

    private INodeJS getDetectedPath() {
        return this.getNodeService().detectInstall();
    }

    protected INodeJSService getNodeService() {
        return JSCorePlugin.getDefault().getNodeJSService();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.aptana.js.core");
    }
}

