/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.core;

import com.aptana.editor.php.core.IPHPVersionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPVersionProvider {
    public static final String DEFAULT_PREFERENCES_QUALIFIER = "com.aptana.editor.php";
    private static PHPVersionProvider instance;
    private String preferencesQualifier = "com.aptana.editor.php";
    private Map<IProject, ListenerList> listeners = new HashMap<IProject, ListenerList>();

    public static PHPVersionProvider getInstance() {
        if (instance == null) {
            instance = new PHPVersionProvider();
        }
        return instance;
    }

    private PHPVersionProvider() {
    }

    public void setPreferencesQualifier(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException("Qualifier cannot be null");
        }
        this.preferencesQualifier = qualifier;
    }

    public void addPHPVersionListener(IProject project, IPHPVersionListener listener) {
        ListenerList listenerList = this.listeners.get(project);
        if (listenerList == null) {
            listenerList = new ListenerList();
            this.listeners.put(project, listenerList);
        }
        listenerList.add((Object)listener);
    }

    public void removePHPVersionListener(IPHPVersionListener listener) {
        Collection<ListenerList> lists = this.listeners.values();
        for (ListenerList listenerList : lists) {
            listenerList.remove((Object)listener);
        }
    }

    public void notifyChange(IProject project, PHPVersion newVersion) {
        ListenerList listenersList = this.listeners.get(project);
        if (listenersList != null) {
            Object[] allListeners;
            Object[] objectArray = allListeners = listenersList.getListeners();
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((IPHPVersionListener)listener).phpVersionChanged(newVersion);
                ++n2;
            }
        }
    }

    public static PHPVersion getPHPVersion(IProject project) {
        return PHPVersionProvider.getInstance().getVersion(project, "phpVersion");
    }

    public static boolean isPHP54(IProject project) {
        PHPVersion version = PHPVersionProvider.getPHPVersion(project);
        return PHPVersion.PHP5_4.equals((Object)version);
    }

    public static boolean isPHP53(IProject project) {
        PHPVersion version = PHPVersionProvider.getPHPVersion(project);
        return PHPVersion.PHP5_3.equals((Object)version);
    }

    public static boolean isPHP5(IProject project) {
        PHPVersion version = PHPVersionProvider.getPHPVersion(project);
        return PHPVersion.PHP5.equals((Object)version);
    }

    public static boolean isPHP4(IProject project) {
        PHPVersion version = PHPVersionProvider.getPHPVersion(project);
        return PHPVersion.PHP4.equals((Object)version);
    }

    private PHPVersion getVersion(IProject project, String prefKey) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] contexts = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String versionAlias = service.getString(this.preferencesQualifier, prefKey, PHPVersion.getLatest().getAlias(), contexts);
        return PHPVersion.byAlias((String)versionAlias);
    }

    public static PHPVersion getDefaultPHPVersion() {
        return PHPVersion.getLatest();
    }
}

